/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.profile.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeOperation<T extends Operation>
extends Operation
implements Iterable<T> {
    private List<T> children = new ArrayList<T>();

    public CompositeOperation(Iterable<? extends T> children) {
        this.children = Lists.newArrayList(children);
    }

    public List<T> getOperations() {
        return this.children;
    }

    @Override
    public Iterator<T> iterator() {
        return this.children.iterator();
    }

    @Override
    long getElapsedTime() {
        long sum = 0L;
        for (Operation child : this.children) {
            sum += child.getElapsedTime();
        }
        return sum;
    }

    @Override
    public String getDescription() {
        return "<composite operation>";
    }
}

