/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildevents;

import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.format.DurationFormatter;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.time.Clock;

public class BuildResultLogger
extends BuildAdapter {
    private final StyledTextOutputFactory textOutputFactory;
    private final Clock buildTimeClock;
    private final DurationFormatter durationFormatter;

    public BuildResultLogger(StyledTextOutputFactory textOutputFactory, Clock buildTimeClock, DurationFormatter durationFormatter) {
        this.textOutputFactory = textOutputFactory;
        this.buildTimeClock = buildTimeClock;
        this.durationFormatter = durationFormatter;
    }

    public void buildFinished(BuildResult result) {
        boolean buildSucceeded = result.getFailure() == null;
        StyledTextOutput textOutput = this.textOutputFactory.create(BuildResultLogger.class, buildSucceeded ? LogLevel.LIFECYCLE : LogLevel.ERROR);
        textOutput.println();
        String action = result.getAction().toUpperCase();
        if (buildSucceeded) {
            textOutput.withStyle(StyledTextOutput.Style.SuccessHeader).text((Object)(action + " SUCCESSFUL"));
        } else {
            textOutput.withStyle(StyledTextOutput.Style.FailureHeader).text((Object)(action + " FAILED"));
        }
        textOutput.formatln(" in %s", new Object[]{this.durationFormatter.format(this.buildTimeClock.getElapsedMillis())});
    }
}

