/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Action;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.Nullable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.CachingTaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.TaskDestroyablesInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.execution.TaskFailureHandler;
import org.gradle.execution.taskgraph.TaskDependencyGraph;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskInfo;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.Pair;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.graph.GraphNodeRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.resources.DefaultResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceDeadlockException;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.CollectionUtils;
import org.gradle.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskExecutionPlan
implements TaskExecutionPlan {
    private final Set<TaskInfo> tasksInUnknownState = new LinkedHashSet<TaskInfo>();
    private final Set<TaskInfo> entryTasks = new LinkedHashSet<TaskInfo>();
    private final TaskDependencyGraph graph = new TaskDependencyGraph();
    private final LinkedHashMap<Task, TaskInfo> executionPlan = new LinkedHashMap();
    private final List<TaskInfo> executionQueue = new LinkedList<TaskInfo>();
    private final Map<Project, ResourceLock> projectLocks = Maps.newHashMap();
    private final List<Throwable> failures = new ArrayList<Throwable>();
    private Spec<? super Task> filter = Specs.satisfyAll();
    private TaskFailureHandler failureHandler = new RethrowingFailureHandler();
    private final BuildCancellationToken cancellationToken;
    private final Set<TaskInfo> runningTasks = Sets.newIdentityHashSet();
    private final Set<Task> filteredTasks = Sets.newIdentityHashSet();
    private final Map<TaskInfo, TaskMutationInfo> taskMutations = Maps.newIdentityHashMap();
    private final Map<File, String> canonicalizedFileCache = Maps.newIdentityHashMap();
    private final Map<Pair<TaskInfo, TaskInfo>, Boolean> reachableCache = Maps.newHashMap();
    private final Set<TaskInfo> dependenciesCompleteCache = Sets.newHashSet();
    private final ResourceLockCoordinationService coordinationService;
    private final WorkerLeaseService workerLeaseService;
    private boolean tasksCancelled;

    public DefaultTaskExecutionPlan(BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService, WorkerLeaseService workerLeaseService) {
        this.cancellationToken = cancellationToken;
        this.coordinationService = coordinationService;
        this.workerLeaseService = workerLeaseService;
    }

    public void addToTaskGraph(Collection<? extends Task> tasks) {
        TaskInfo node;
        ArrayList<TaskInfo> queue = new ArrayList<TaskInfo>();
        ArrayList<? extends Task> sortedTasks = new ArrayList<Task>(tasks);
        Collections.sort(sortedTasks);
        for (Task task : sortedTasks) {
            node = this.graph.addNode(task);
            if (node.isMustNotRun()) {
                this.requireWithDependencies(node);
            } else if (this.filter.isSatisfiedBy((Object)task)) {
                node.require();
            }
            this.entryTasks.add(node);
            queue.add(node);
        }
        HashSet<TaskInfo> visiting = new HashSet<TaskInfo>();
        CachingTaskDependencyResolveContext cachingTaskDependencyResolveContext = new CachingTaskDependencyResolveContext();
        while (!queue.isEmpty()) {
            boolean filtered;
            node = (TaskInfo)queue.get(0);
            if (node.getDependenciesProcessed()) {
                queue.remove(0);
                continue;
            }
            TaskInternal task = node.getTask();
            boolean bl = filtered = !this.filter.isSatisfiedBy((Object)task);
            if (filtered) {
                queue.remove(0);
                node.dependenciesProcessed();
                node.doNotRequire();
                this.filteredTasks.add(task);
                continue;
            }
            if (visiting.add(node)) {
                TaskInfo targetNode;
                ((TaskContainerInternal)task.getProject().getTasks()).prepareForExecution(task);
                Set<? extends Task> dependsOnTasks = cachingTaskDependencyResolveContext.getDependencies(task);
                for (Task task2 : dependsOnTasks) {
                    targetNode = this.graph.addNode(task2);
                    node.addDependencySuccessor(targetNode);
                    if (visiting.contains(targetNode)) continue;
                    queue.add(0, targetNode);
                }
                for (Task task3 : task.getFinalizedBy().getDependencies(task)) {
                    targetNode = this.graph.addNode(task3);
                    this.addFinalizerNode(node, targetNode);
                    if (visiting.contains(targetNode)) continue;
                    queue.add(0, targetNode);
                }
                for (Task task4 : task.getMustRunAfter().getDependencies(task)) {
                    targetNode = this.graph.addNode(task4);
                    node.addMustSuccessor(targetNode);
                }
                for (Task task5 : task.getShouldRunAfter().getDependencies(task)) {
                    targetNode = this.graph.addNode(task5);
                    node.addShouldSuccessor(targetNode);
                }
                if (node.isRequired()) {
                    for (TaskInfo taskInfo : node.getDependencySuccessors()) {
                        if (!this.filter.isSatisfiedBy((Object)taskInfo.getTask())) continue;
                        taskInfo.require();
                    }
                    continue;
                }
                this.tasksInUnknownState.add(node);
                continue;
            }
            queue.remove(0);
            visiting.remove(node);
            node.dependenciesProcessed();
        }
        this.resolveTasksInUnknownState();
    }

    private void resolveTasksInUnknownState() {
        ArrayList<TaskInfo> queue = new ArrayList<TaskInfo>(this.tasksInUnknownState);
        HashSet<TaskInfo> visiting = new HashSet<TaskInfo>();
        block0: while (!queue.isEmpty()) {
            TaskInfo task = (TaskInfo)queue.get(0);
            if (task.isInKnownState()) {
                queue.remove(0);
                continue;
            }
            if (visiting.add(task)) {
                for (TaskInfo hardPredecessor : task.getDependencyPredecessors()) {
                    if (visiting.contains(hardPredecessor)) continue;
                    queue.add(0, hardPredecessor);
                }
                continue;
            }
            queue.remove(0);
            visiting.remove(task);
            task.mustNotRun();
            for (TaskInfo predecessor : task.getDependencyPredecessors()) {
                assert (predecessor.isRequired() || predecessor.isMustNotRun());
                if (!predecessor.isRequired()) continue;
                task.require();
                continue block0;
            }
        }
    }

    private void addFinalizerNode(TaskInfo node, TaskInfo finalizerNode) {
        if (this.filter.isSatisfiedBy((Object)finalizerNode.getTask())) {
            node.addFinalizer(finalizerNode);
            if (!finalizerNode.isInKnownState()) {
                finalizerNode.mustNotRun();
            }
            finalizerNode.addMustSuccessor(node);
        }
    }

    private <T> void addAllReversed(List<T> list, TreeSet<T> set) {
        List elements = CollectionUtils.toList(set);
        Collections.reverse(elements);
        list.addAll(elements);
    }

    private void requireWithDependencies(TaskInfo taskInfo) {
        if (taskInfo.isMustNotRun() && this.filter.isSatisfiedBy((Object)taskInfo.getTask())) {
            taskInfo.require();
            for (TaskInfo dependency : taskInfo.getDependencySuccessors()) {
                this.requireWithDependencies(dependency);
            }
        }
    }

    public void determineExecutionPlan() {
        ArrayList nodeQueue = Lists.newArrayList((Iterable)Iterables.transform(this.entryTasks, (Function)new Function<TaskInfo, TaskInfoInVisitingSegment>(){
            int index;

            public TaskInfoInVisitingSegment apply(TaskInfo taskInfo) {
                return new TaskInfoInVisitingSegment(taskInfo, this.index++);
            }
        }));
        int visitingSegmentCounter = nodeQueue.size();
        HashMultimap visitingNodes = HashMultimap.create();
        Stack<GraphEdge> walkedShouldRunAfterEdges = new Stack<GraphEdge>();
        Stack<TaskInfo> path = new Stack<TaskInfo>();
        HashMap<TaskInfo, Integer> planBeforeVisiting = new HashMap<TaskInfo, Integer>();
        while (!nodeQueue.isEmpty()) {
            TaskInfoInVisitingSegment taskInfoInVisitingSegment = (TaskInfoInVisitingSegment)nodeQueue.get(0);
            int currentSegment = taskInfoInVisitingSegment.visitingSegment;
            TaskInfo taskNode = taskInfoInVisitingSegment.taskInfo;
            if (taskNode.isIncludeInGraph() || this.executionPlan.containsKey(taskNode.getTask())) {
                nodeQueue.remove(0);
                visitingNodes.remove((Object)taskNode, (Object)currentSegment);
                this.maybeRemoveProcessedShouldRunAfterEdge(walkedShouldRunAfterEdges, taskNode);
                continue;
            }
            boolean alreadyVisited = visitingNodes.containsKey((Object)taskNode);
            visitingNodes.put((Object)taskNode, (Object)currentSegment);
            if (!alreadyVisited) {
                this.recordEdgeIfArrivedViaShouldRunAfter(walkedShouldRunAfterEdges, path, taskNode);
                this.removeShouldRunAfterSuccessorsIfTheyImposeACycle((HashMultimap<TaskInfo, Integer>)visitingNodes, taskInfoInVisitingSegment);
                this.takePlanSnapshotIfCanBeRestoredToCurrentTask(planBeforeVisiting, taskNode);
                ArrayList<TaskInfo> successors = new ArrayList<TaskInfo>();
                this.addAllSuccessorsInReverseOrder(taskNode, successors);
                for (TaskInfo successor : successors) {
                    if (visitingNodes.containsEntry((Object)successor, (Object)currentSegment)) {
                        if (!walkedShouldRunAfterEdges.empty()) {
                            GraphEdge toBeRemoved = walkedShouldRunAfterEdges.pop();
                            toBeRemoved.from.removeShouldRunAfterSuccessor(toBeRemoved.to);
                            this.restorePath(path, toBeRemoved);
                            this.restoreQueue(nodeQueue, (HashMultimap<TaskInfo, Integer>)visitingNodes, toBeRemoved);
                            this.restoreExecutionPlan(planBeforeVisiting, toBeRemoved);
                            break;
                        }
                        this.onOrderingCycle();
                    }
                    nodeQueue.add(0, new TaskInfoInVisitingSegment(successor, currentSegment));
                }
                path.push(taskNode);
                continue;
            }
            nodeQueue.remove(0);
            this.maybeRemoveProcessedShouldRunAfterEdge(walkedShouldRunAfterEdges, taskNode);
            visitingNodes.remove((Object)taskNode, (Object)currentSegment);
            path.pop();
            this.executionPlan.put(taskNode.getTask(), taskNode);
            Project project = taskNode.getTask().getProject();
            this.projectLocks.put(project, this.getOrCreateProjectLock(project));
            TaskMutationInfo taskMutationInfo = this.getOrCreateMutationsOf(taskNode);
            for (TaskInfo dependency : taskNode.getDependencySuccessors()) {
                this.getOrCreateMutationsOf((TaskInfo)dependency).consumingTasks.add(taskNode);
                taskMutationInfo.consumesOutputOf.add(dependency);
            }
            ArrayList finalizerTasks = new ArrayList();
            this.addAllReversed(finalizerTasks, taskNode.getFinalizers());
            for (TaskInfo finalizer : finalizerTasks) {
                if (visitingNodes.containsKey((Object)finalizer)) continue;
                nodeQueue.add(this.finalizerTaskPosition(finalizer, nodeQueue), new TaskInfoInVisitingSegment(finalizer, visitingSegmentCounter++));
            }
        }
        this.executionQueue.clear();
        this.executionQueue.addAll(this.executionPlan.values());
    }

    private TaskMutationInfo getOrCreateMutationsOf(TaskInfo taskInfo) {
        TaskMutationInfo mutations = this.taskMutations.get(taskInfo);
        if (mutations == null) {
            mutations = new TaskMutationInfo(taskInfo);
            this.taskMutations.put(taskInfo, mutations);
        }
        return mutations;
    }

    private void maybeRemoveProcessedShouldRunAfterEdge(Stack<GraphEdge> walkedShouldRunAfterEdges, TaskInfo taskNode) {
        if (!walkedShouldRunAfterEdges.isEmpty() && walkedShouldRunAfterEdges.peek().to.equals(taskNode)) {
            walkedShouldRunAfterEdges.pop();
        }
    }

    private void restoreExecutionPlan(HashMap<TaskInfo, Integer> planBeforeVisiting, GraphEdge toBeRemoved) {
        Iterator<Map.Entry<Task, TaskInfo>> executionPlanIterator = this.executionPlan.entrySet().iterator();
        for (int i = 0; i < planBeforeVisiting.get(toBeRemoved.from); ++i) {
            executionPlanIterator.next();
        }
        while (executionPlanIterator.hasNext()) {
            executionPlanIterator.next();
            executionPlanIterator.remove();
        }
    }

    private void restoreQueue(List<TaskInfoInVisitingSegment> nodeQueue, HashMultimap<TaskInfo, Integer> visitingNodes, GraphEdge toBeRemoved) {
        TaskInfoInVisitingSegment nextInQueue = null;
        while (nextInQueue == null || !toBeRemoved.from.equals(nextInQueue.taskInfo)) {
            nextInQueue = nodeQueue.get(0);
            visitingNodes.remove((Object)nextInQueue.taskInfo, (Object)nextInQueue.visitingSegment);
            if (toBeRemoved.from.equals(nextInQueue.taskInfo)) continue;
            nodeQueue.remove(0);
        }
    }

    private void restorePath(Stack<TaskInfo> path, GraphEdge toBeRemoved) {
        TaskInfo removedFromPath = null;
        while (!toBeRemoved.from.equals(removedFromPath)) {
            removedFromPath = path.pop();
        }
    }

    private void addAllSuccessorsInReverseOrder(TaskInfo taskNode, ArrayList<TaskInfo> dependsOnTasks) {
        this.addAllReversed(dependsOnTasks, taskNode.getDependencySuccessors());
        this.addAllReversed(dependsOnTasks, taskNode.getMustSuccessors());
        this.addAllReversed(dependsOnTasks, taskNode.getShouldSuccessors());
    }

    private void removeShouldRunAfterSuccessorsIfTheyImposeACycle(final HashMultimap<TaskInfo, Integer> visitingNodes, final TaskInfoInVisitingSegment taskNodeWithVisitingSegment) {
        TaskInfo taskNode = taskNodeWithVisitingSegment.taskInfo;
        Iterables.removeIf(taskNode.getShouldSuccessors(), (Predicate)new Predicate<TaskInfo>(){

            public boolean apply(TaskInfo input) {
                return visitingNodes.containsEntry((Object)input, (Object)taskNodeWithVisitingSegment.visitingSegment);
            }
        });
    }

    private void takePlanSnapshotIfCanBeRestoredToCurrentTask(HashMap<TaskInfo, Integer> planBeforeVisiting, TaskInfo taskNode) {
        if (taskNode.getShouldSuccessors().size() > 0) {
            planBeforeVisiting.put(taskNode, this.executionPlan.size());
        }
    }

    private void recordEdgeIfArrivedViaShouldRunAfter(Stack<GraphEdge> walkedShouldRunAfterEdges, Stack<TaskInfo> path, TaskInfo taskNode) {
        if (!path.empty() && path.peek().getShouldSuccessors().contains(taskNode)) {
            walkedShouldRunAfterEdges.push(new GraphEdge(path.peek(), taskNode));
        }
    }

    private int finalizerTaskPosition(TaskInfo finalizer, final List<TaskInfoInVisitingSegment> nodeQueue) {
        if (nodeQueue.size() == 0) {
            return 0;
        }
        Set<TaskInfo> precedingTasks = this.getAllPrecedingTasks(finalizer);
        Set precedingTaskIndices = CollectionUtils.collect(precedingTasks, (Transformer)new Transformer<Integer, TaskInfo>(){

            public Integer transform(final TaskInfo dependsOnTask) {
                return Iterables.indexOf((Iterable)nodeQueue, (Predicate)new Predicate<TaskInfoInVisitingSegment>(){

                    public boolean apply(TaskInfoInVisitingSegment taskInfoInVisitingSegment) {
                        return taskInfoInVisitingSegment.taskInfo.equals(dependsOnTask);
                    }
                });
            }
        });
        return (Integer)Collections.max(precedingTaskIndices) + 1;
    }

    private Set<TaskInfo> getAllPrecedingTasks(TaskInfo finalizer) {
        HashSet<TaskInfo> precedingTasks = new HashSet<TaskInfo>();
        ArrayDeque<TaskInfo> candidateTasks = new ArrayDeque<TaskInfo>();
        candidateTasks.addAll(finalizer.getDependencySuccessors());
        candidateTasks.addAll(finalizer.getMustSuccessors());
        candidateTasks.addAll(finalizer.getShouldSuccessors());
        while (!candidateTasks.isEmpty()) {
            TaskInfo precedingTask = (TaskInfo)candidateTasks.pop();
            if (!precedingTasks.add(precedingTask)) continue;
            candidateTasks.addAll(precedingTask.getMustSuccessors());
        }
        return precedingTasks;
    }

    private void onOrderingCycle() {
        CachingDirectedGraphWalker<TaskInfo, Void> graphWalker = new CachingDirectedGraphWalker<TaskInfo, Void>(new DirectedGraph<TaskInfo, Void>(){

            @Override
            public void getNodeValues(TaskInfo node, Collection<? super Void> values, Collection<? super TaskInfo> connectedNodes) {
                connectedNodes.addAll(node.getDependencySuccessors());
                connectedNodes.addAll(node.getMustSuccessors());
            }
        });
        graphWalker.add((Iterable<TaskInfo>)this.entryTasks);
        final ArrayList firstCycle = new ArrayList(graphWalker.findCycles().get(0));
        Collections.sort(firstCycle);
        DirectedGraphRenderer<TaskInfo> graphRenderer = new DirectedGraphRenderer<TaskInfo>(new GraphNodeRenderer<TaskInfo>(){

            @Override
            public void renderTo(TaskInfo node, StyledTextOutput output) {
                output.withStyle(StyledTextOutput.Style.Identifier).text((Object)node.getTask().getPath());
            }
        }, new DirectedGraph<TaskInfo, Object>(){

            @Override
            public void getNodeValues(TaskInfo node, Collection<? super Object> values, Collection<? super TaskInfo> connectedNodes) {
                for (TaskInfo dependency : firstCycle) {
                    if (!node.getDependencySuccessors().contains(dependency) && !node.getMustSuccessors().contains(dependency)) continue;
                    connectedNodes.add(dependency);
                }
            }
        });
        StringWriter writer = new StringWriter();
        graphRenderer.renderTo((TaskInfo)firstCycle.get(0), writer);
        throw new CircularReferenceException(String.format("Circular dependency between the following tasks:%n%s", writer.toString()));
    }

    public void clear() {
        this.coordinationService.withStateLock((Transformer)new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

            public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                DefaultTaskExecutionPlan.this.graph.clear();
                DefaultTaskExecutionPlan.this.entryTasks.clear();
                DefaultTaskExecutionPlan.this.executionPlan.clear();
                DefaultTaskExecutionPlan.this.executionQueue.clear();
                DefaultTaskExecutionPlan.this.projectLocks.clear();
                DefaultTaskExecutionPlan.this.failures.clear();
                DefaultTaskExecutionPlan.this.taskMutations.clear();
                DefaultTaskExecutionPlan.this.canonicalizedFileCache.clear();
                DefaultTaskExecutionPlan.this.reachableCache.clear();
                DefaultTaskExecutionPlan.this.dependenciesCompleteCache.clear();
                DefaultTaskExecutionPlan.this.runningTasks.clear();
                return ResourceLockState.Disposition.FINISHED;
            }
        });
    }

    @Override
    public List<Task> getTasks() {
        return new ArrayList<Task>(this.executionPlan.keySet());
    }

    @Override
    public Set<Task> getFilteredTasks() {
        return this.filteredTasks;
    }

    public void useFilter(Spec<? super Task> filter) {
        this.filter = filter;
    }

    public void useFailureHandler(TaskFailureHandler handler) {
        this.failureHandler = handler;
    }

    @Override
    public boolean executeWithTask(final WorkerLeaseRegistry.WorkerLease workerLease, Action<TaskInfo> taskExecution) {
        final AtomicReference selected = new AtomicReference();
        final AtomicBoolean workRemaining = new AtomicBoolean();
        this.coordinationService.withStateLock((Transformer)new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

            public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                if (DefaultTaskExecutionPlan.this.cancellationToken.isCancellationRequested() && DefaultTaskExecutionPlan.this.abortExecution()) {
                    DefaultTaskExecutionPlan.this.tasksCancelled = true;
                }
                workRemaining.set(DefaultTaskExecutionPlan.this.workRemaining());
                if (!workRemaining.get()) {
                    return ResourceLockState.Disposition.FINISHED;
                }
                if (DefaultTaskExecutionPlan.this.allProjectsLocked()) {
                    return ResourceLockState.Disposition.RETRY;
                }
                try {
                    selected.set(DefaultTaskExecutionPlan.this.selectNextTask(workerLease));
                }
                catch (Throwable t) {
                    DefaultTaskExecutionPlan.this.abortAndFail(t);
                    workRemaining.set(false);
                }
                if (selected.get() == null && workRemaining.get()) {
                    return ResourceLockState.Disposition.RETRY;
                }
                return ResourceLockState.Disposition.FINISHED;
            }
        });
        TaskInfo selectedTask = (TaskInfo)selected.get();
        this.execute(selectedTask, workerLease, taskExecution);
        return workRemaining.get();
    }

    private TaskInfo selectNextTask(final WorkerLeaseRegistry.WorkerLease workerLease) {
        final AtomicReference selected = new AtomicReference();
        final Iterator<TaskInfo> iterator = this.executionQueue.iterator();
        while (iterator.hasNext()) {
            final TaskInfo taskInfo = iterator.next();
            if (!taskInfo.isReady() || !this.allDependenciesComplete(taskInfo)) continue;
            this.coordinationService.withStateLock((Transformer)new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

                public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                    ResourceLock projectLock = DefaultTaskExecutionPlan.this.getProjectLock(taskInfo);
                    if (!(projectLock.tryLock() && workerLease.tryLock() && DefaultTaskExecutionPlan.this.canRunWithCurrentlyExecutedTasks(taskInfo))) {
                        return ResourceLockState.Disposition.FAILED;
                    }
                    selected.set(taskInfo);
                    if (taskInfo.allDependenciesSuccessful()) {
                        DefaultTaskExecutionPlan.this.recordTaskStarted(taskInfo);
                        taskInfo.startExecution();
                    } else {
                        taskInfo.skipExecution();
                    }
                    iterator.remove();
                    return ResourceLockState.Disposition.FINISHED;
                }
            });
            if (selected.get() == null) continue;
            break;
        }
        return (TaskInfo)selected.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(TaskInfo selectedTask, WorkerLeaseRegistry.WorkerLease workerLease, Action<TaskInfo> taskExecution) {
        if (selectedTask == null) {
            return;
        }
        try {
            if (!selectedTask.isComplete()) {
                taskExecution.execute((Object)selectedTask);
            }
        }
        catch (Throwable throwable) {
            this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock((ResourceLock[])new ResourceLock[]{workerLease, this.getProjectLock(selectedTask)}));
            throw throwable;
        }
        this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock((ResourceLock[])new ResourceLock[]{workerLease, this.getProjectLock(selectedTask)}));
    }

    private boolean allDependenciesComplete(TaskInfo taskInfo) {
        if (this.dependenciesCompleteCache.contains(taskInfo)) {
            return true;
        }
        boolean dependenciesComplete = taskInfo.allDependenciesComplete();
        if (dependenciesComplete) {
            this.dependenciesCompleteCache.add(taskInfo);
        }
        return dependenciesComplete;
    }

    private boolean allProjectsLocked() {
        for (ResourceLock lock : this.projectLocks.values()) {
            if (lock.isLocked()) continue;
            return false;
        }
        return true;
    }

    private ResourceLock getProjectLock(TaskInfo taskInfo) {
        return this.projectLocks.get(taskInfo.getTask().getProject());
    }

    private ResourceLock getOrCreateProjectLock(Project project) {
        String gradlePath = ((GradleInternal)project.getGradle()).getIdentityPath().toString();
        String projectPath = ((ProjectInternal)project).getIdentityPath().toString();
        return this.workerLeaseService.getProjectLock(gradlePath, projectPath);
    }

    private boolean canRunWithCurrentlyExecutedTasks(TaskInfo taskInfo) {
        Set<String> candidateTaskOutputs;
        Set<String> candidateTaskMutations;
        Pair<TaskInfo, String> overlap;
        Set<String> candidateTaskDestroyables = this.getDestroyablePaths(taskInfo);
        if (!candidateTaskDestroyables.isEmpty() && !taskInfo.getTask().getOutputs().getFileProperties().isEmpty()) {
            throw new IllegalStateException("Task " + taskInfo.getTask().getPath() + " has both outputs and destroyables defined.  A task can define either outputs or destroyables, but not both.");
        }
        if (!candidateTaskDestroyables.isEmpty() && !taskInfo.getTask().getInputs().getFileProperties().isEmpty()) {
            throw new IllegalStateException("Task " + taskInfo.getTask().getPath() + " has both inputs and destroyables defined.  A task can define either inputs or destroyables, but not both.");
        }
        if (!this.runningTasks.isEmpty() && (overlap = this.firstRunningTaskWithOverlappingMutations(candidateTaskMutations = !(candidateTaskOutputs = this.getOutputPaths(taskInfo)).isEmpty() ? candidateTaskOutputs : candidateTaskDestroyables)) != null) {
            return false;
        }
        Pair<TaskInfo, String> overlap2 = this.firstTaskWithDestroyedIntermediateInput(taskInfo, candidateTaskDestroyables);
        return overlap2 == null;
    }

    private Set<String> canonicalizedPaths(final Map<File, String> cache, Iterable<File> files) {
        Function<File, String> canonicalize = new Function<File, String>(){

            public String apply(File file) {
                String path;
                try {
                    path = (String)cache.get(file);
                    if (path == null) {
                        path = file.getCanonicalPath();
                        cache.put(file, path);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
                return path;
            }
        };
        return Sets.newHashSet((Iterable)Iterables.transform(files, (Function)canonicalize));
    }

    @Nullable
    private Pair<TaskInfo, String> firstRunningTaskWithOverlappingMutations(Set<String> candidateTaskMutations) {
        if (!candidateTaskMutations.isEmpty()) {
            for (TaskInfo runningTask : this.runningTasks) {
                TaskMutationInfo taskMutationInfo = this.taskMutations.get(runningTask);
                Iterable runningTaskMutations = Iterables.concat(taskMutationInfo.outputPaths, taskMutationInfo.destroyablePaths);
                String firstOverlap = this.findFirstOverlap(candidateTaskMutations, runningTaskMutations);
                if (firstOverlap == null) continue;
                return Pair.of((Object)runningTask, (Object)firstOverlap);
            }
        }
        return null;
    }

    @Nullable
    private Pair<TaskInfo, String> firstTaskWithDestroyedIntermediateInput(TaskInfo taskInfo, Set<String> destroyablePaths) {
        if (!destroyablePaths.isEmpty()) {
            for (TaskMutationInfo taskMutationInfo : this.taskMutations.values()) {
                String firstOverlap;
                if (!taskMutationInfo.task.isComplete() || taskMutationInfo.consumingTasks.isEmpty() || (firstOverlap = this.findFirstOverlap(destroyablePaths, taskMutationInfo.outputPaths)) == null) continue;
                for (TaskInfo consumingTask : taskMutationInfo.consumingTasks) {
                    if (consumingTask == taskInfo || this.isReachableFrom(consumingTask, taskInfo)) continue;
                    return Pair.of((Object)consumingTask, (Object)firstOverlap);
                }
            }
        }
        return null;
    }

    private boolean isReachableFrom(TaskInfo fromTask, TaskInfo toTask) {
        Pair taskPair = Pair.of((Object)fromTask, (Object)toTask);
        if (this.reachableCache.get(taskPair) != null) {
            return this.reachableCache.get(taskPair);
        }
        boolean reachable = false;
        for (TaskInfo dependency : Iterables.concat(fromTask.getMustSuccessors(), fromTask.getDependencySuccessors())) {
            if (dependency.isComplete()) continue;
            if (dependency == toTask) {
                reachable = true;
            }
            if (!this.isReachableFrom(dependency, toTask)) continue;
            reachable = true;
        }
        this.reachableCache.put((Pair<TaskInfo, TaskInfo>)taskPair, reachable);
        return reachable;
    }

    private String findFirstOverlap(Iterable<String> paths1, Iterable<String> paths2) {
        for (String path1 : paths1) {
            for (String path2 : paths2) {
                if (!this.pathsOverlap(path1, path2)) continue;
                return TextUtil.shorterOf((String)path1, (String)path2);
            }
        }
        return null;
    }

    private Set<String> getOutputPaths(TaskInfo task) {
        try {
            return this.canonicalizedPaths(this.canonicalizedFileCache, task.getTask().getOutputs().getFiles());
        }
        catch (ResourceDeadlockException e) {
            throw new IllegalStateException("A deadlock was detected while resolving the task outputs for " + task.getTask().getPath() + ".  This can be caused, for instance, by a task output causing dependency resolution.", e);
        }
    }

    private Set<String> getDestroyablePaths(TaskInfo task) {
        return this.canonicalizedPaths(this.canonicalizedFileCache, ((TaskDestroyablesInternal)task.getTask().getDestroyables()).getFilesReadOnly());
    }

    private boolean pathsOverlap(String firstPath, String secondPath) {
        String longer;
        String shorter;
        if (firstPath.equals(secondPath)) {
            return true;
        }
        if (firstPath.length() > secondPath.length()) {
            shorter = secondPath;
            longer = firstPath;
        } else {
            shorter = firstPath;
            longer = secondPath;
        }
        return longer.startsWith(shorter + StandardSystemProperty.FILE_SEPARATOR.value());
    }

    private void recordTaskStarted(TaskInfo taskInfo) {
        this.runningTasks.add(taskInfo);
        TaskMutationInfo taskMutationInfo = this.taskMutations.get(taskInfo);
        taskMutationInfo.outputPaths.addAll(this.getOutputPaths(taskInfo));
        taskMutationInfo.destroyablePaths.addAll(this.getDestroyablePaths(taskInfo));
    }

    private void recordTaskCompleted(TaskInfo taskInfo) {
        this.runningTasks.remove(taskInfo);
        TaskMutationInfo taskMutationInfo = this.taskMutations.get(taskInfo);
        for (TaskInfo producerTask : taskMutationInfo.consumesOutputOf) {
            TaskMutationInfo producerTaskMutationInfo = this.taskMutations.get(producerTask);
            if (!producerTaskMutationInfo.consumingTasks.remove(taskInfo) || !this.canRemoveTaskMutation(producerTaskMutationInfo)) continue;
            this.taskMutations.remove(producerTask);
        }
        if (this.canRemoveTaskMutation(taskMutationInfo)) {
            this.taskMutations.remove(taskInfo);
        }
    }

    private boolean canRemoveTaskMutation(TaskMutationInfo taskMutationInfo) {
        return taskMutationInfo != null && taskMutationInfo.task.isComplete() && taskMutationInfo.consumingTasks.isEmpty();
    }

    @Override
    public void taskComplete(final TaskInfo taskInfo) {
        this.coordinationService.withStateLock((Transformer)new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

            public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                DefaultTaskExecutionPlan.this.enforceFinalizerTasks(taskInfo);
                if (taskInfo.isFailed()) {
                    DefaultTaskExecutionPlan.this.handleFailure(taskInfo);
                }
                taskInfo.finishExecution();
                DefaultTaskExecutionPlan.this.recordTaskCompleted(taskInfo);
                return ResourceLockState.Disposition.FINISHED;
            }
        });
    }

    private void enforceFinalizerTasks(TaskInfo taskInfo) {
        for (TaskInfo finalizerNode : taskInfo.getFinalizers()) {
            if (!finalizerNode.isRequired() && !finalizerNode.isMustNotRun()) continue;
            this.enforceWithDependencies(finalizerNode, Sets.newHashSet());
        }
    }

    private void enforceWithDependencies(TaskInfo nodeInfo, Set<TaskInfo> enforcedTasks) {
        ArrayDeque<TaskInfo> candidateNodes = new ArrayDeque<TaskInfo>();
        candidateNodes.add(nodeInfo);
        while (!candidateNodes.isEmpty()) {
            TaskInfo node = (TaskInfo)candidateNodes.pop();
            if (enforcedTasks.contains(node)) continue;
            enforcedTasks.add(node);
            candidateNodes.addAll(node.getDependencySuccessors());
            if (!node.isMustNotRun() && !node.isRequired()) continue;
            node.enforceRun();
        }
    }

    private void abortAndFail(Throwable t) {
        this.abortExecution();
        this.failures.add(t);
    }

    private void handleFailure(TaskInfo taskInfo) {
        Throwable executionFailure = taskInfo.getExecutionFailure();
        if (executionFailure != null) {
            this.abortExecution();
            this.failures.add(executionFailure);
            return;
        }
        try {
            this.failureHandler.onTaskFailure(taskInfo.getTask());
            this.failures.add(taskInfo.getTaskFailure());
        }
        catch (Exception e) {
            this.abortExecution();
            this.failures.add(e);
        }
    }

    private boolean abortExecution() {
        boolean aborted = false;
        for (TaskInfo taskInfo : this.executionPlan.values()) {
            if (!taskInfo.isRequired()) continue;
            taskInfo.skipExecution();
            aborted = true;
        }
        return aborted;
    }

    @Override
    public void awaitCompletion() {
        this.coordinationService.withStateLock((Transformer)new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

            public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                if (DefaultTaskExecutionPlan.this.allTasksComplete()) {
                    DefaultTaskExecutionPlan.this.rethrowFailures();
                    return ResourceLockState.Disposition.FINISHED;
                }
                return ResourceLockState.Disposition.RETRY;
            }
        });
    }

    private void rethrowFailures() {
        if (this.tasksCancelled) {
            this.failures.add((Throwable)((Object)new BuildCancelledException()));
        }
        if (this.failures.isEmpty()) {
            return;
        }
        if (this.failures.size() > 1) {
            throw new MultipleBuildFailures(this.failures);
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)this.failures.get(0));
    }

    private boolean allTasksComplete() {
        for (TaskInfo taskInfo : this.executionPlan.values()) {
            if (taskInfo.isComplete()) continue;
            return false;
        }
        return true;
    }

    private boolean workRemaining() {
        for (TaskInfo taskInfo : this.executionQueue) {
            if (taskInfo.isComplete()) continue;
            return true;
        }
        return false;
    }

    private static class TaskMutationInfo {
        final TaskInfo task;
        final Set<TaskInfo> consumingTasks = Sets.newHashSet();
        final Set<TaskInfo> consumesOutputOf = Sets.newHashSet();
        final Set<String> outputPaths = Sets.newHashSet();
        final Set<String> destroyablePaths = Sets.newHashSet();

        TaskMutationInfo(TaskInfo task) {
            this.task = task;
        }
    }

    private static class RethrowingFailureHandler
    implements TaskFailureHandler {
        private RethrowingFailureHandler() {
        }

        public void onTaskFailure(Task task) {
            task.getState().rethrowFailure();
        }
    }

    private static class TaskInfoInVisitingSegment {
        private final TaskInfo taskInfo;
        private final int visitingSegment;

        private TaskInfoInVisitingSegment(TaskInfo taskInfo, int visitingSegment) {
            this.taskInfo = taskInfo;
            this.visitingSegment = visitingSegment;
        }
    }

    private static class GraphEdge {
        private final TaskInfo from;
        private final TaskInfo to;

        private GraphEdge(TaskInfo from, TaskInfo to) {
            this.from = from;
            this.to = to;
        }
    }
}

