/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class SkipTaskWithNoActionsExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(SkipTaskWithNoActionsExecuter.class);
    private final TaskExecuter executer;

    public SkipTaskWithNoActionsExecuter(TaskExecuter executer) {
        this.executer = executer;
    }

    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        if (task.getTaskActions().isEmpty()) {
            LOGGER.info("Skipping {} as it has no actions.", (Object)task);
            boolean upToDate = true;
            for (Task task2 : task.getTaskDependencies().getDependencies(task)) {
                if (task2.getState().getSkipped()) continue;
                upToDate = false;
                break;
            }
            state.setActionable(false);
            state.setOutcome(upToDate ? TaskExecutionOutcome.UP_TO_DATE : TaskExecutionOutcome.EXECUTED);
            return;
        }
        this.executer.execute(task, state, context);
    }
}

