/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.SortedSet;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.tasks.ResolvedTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskOutputsGenerationListener;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.caching.internal.tasks.TaskOutputPacker;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginFactory;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginMetadata;
import org.gradle.internal.time.Timer;
import org.gradle.internal.time.Timers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipCachedTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipCachedTaskExecuter.class);
    private final BuildCacheService buildCache;
    private final TaskOutputPacker packer;
    private final TaskExecuter delegate;
    private final TaskOutputsGenerationListener taskOutputsGenerationListener;
    private final TaskOutputOriginFactory taskOutputOriginFactory;

    public SkipCachedTaskExecuter(TaskOutputOriginFactory taskOutputOriginFactory, BuildCacheService buildCache, TaskOutputPacker packer, TaskOutputsGenerationListener taskOutputsGenerationListener, TaskExecuter delegate) {
        this.taskOutputOriginFactory = taskOutputOriginFactory;
        this.buildCache = buildCache;
        this.packer = packer;
        this.taskOutputsGenerationListener = taskOutputsGenerationListener;
        this.delegate = delegate;
    }

    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        Timer clock = Timers.startTimer();
        LOGGER.debug("Determining if {} is cached already", (Object)task);
        TaskOutputsInternal taskOutputs = task.getOutputs();
        TaskOutputCachingBuildCacheKey cacheKey = context.getBuildCacheKey();
        boolean taskOutputCachingEnabled = state.getTaskOutputCaching().isEnabled();
        SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties = null;
        if (taskOutputCachingEnabled) {
            if (task.isHasCustomActions()) {
                LOGGER.info("Custom actions are attached to {}.", (Object)task);
            }
            if (cacheKey.isValid()) {
                TaskArtifactState taskState = context.getTaskArtifactState();
                outputProperties = TaskPropertyUtils.resolveFileProperties(taskOutputs.getFileProperties());
                if (taskState.isAllowedToUseCachedResults()) {
                    EntryReader reader = new EntryReader(outputProperties, task, clock);
                    boolean found = this.buildCache.load(cacheKey, reader);
                    if (found) {
                        state.setOutcome(TaskExecutionOutcome.FROM_CACHE);
                        context.setOriginBuildInvocationId(reader.originMetadata.getBuildInvocationId());
                        return;
                    }
                } else {
                    LOGGER.info("Not loading {} from cache because pulling from cache is disabled for this task", (Object)task);
                }
            } else {
                LOGGER.info("Not caching {} because no valid cache key was generated", (Object)task);
            }
        }
        this.delegate.execute(task, state, context);
        if (taskOutputCachingEnabled) {
            if (cacheKey.isValid()) {
                if (state.getFailure() == null) {
                    this.buildCache.store(cacheKey, new EntryWriter(outputProperties, task, clock));
                } else {
                    LOGGER.debug("Not pushing result from {} to cache because the task failed", (Object)task);
                }
            } else {
                LOGGER.info("Not pushing results from {} to cache because no valid cache key was generated", (Object)task);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryWriter
    implements BuildCacheEntryWriter {
        private final TaskInternal task;
        private final SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties;
        private final Timer clock;

        public EntryWriter(SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties, TaskInternal task, Timer clock) {
            this.task = task;
            this.outputProperties = outputProperties;
            this.clock = clock;
        }

        @Override
        public void writeTo(OutputStream output) {
            LOGGER.info("Packing {}", (Object)this.task.getPath());
            SkipCachedTaskExecuter.this.packer.pack(this.outputProperties, output, SkipCachedTaskExecuter.this.taskOutputOriginFactory.createWriter(this.task, this.clock.getElapsedMillis()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryReader
    implements BuildCacheEntryReader {
        private final SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties;
        private final TaskInternal task;
        private final Timer clock;
        private TaskOutputOriginMetadata originMetadata;

        private EntryReader(SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties, TaskInternal task, Timer clock) {
            this.outputProperties = outputProperties;
            this.task = task;
            this.clock = clock;
        }

        @Override
        public void readFrom(InputStream input) {
            SkipCachedTaskExecuter.this.taskOutputsGenerationListener.beforeTaskOutputsGenerated();
            this.originMetadata = SkipCachedTaskExecuter.this.packer.unpack(this.outputProperties, input, SkipCachedTaskExecuter.this.taskOutputOriginFactory.createReader(this.task));
            LOGGER.info("Unpacked output for {} from cache (took {}).", (Object)this.task, (Object)this.clock.getElapsed());
        }
    }
}

