/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.DirContentSnapshot;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.IgnoredPathFileSnapshot;
import org.gradle.api.internal.changedetection.state.IndexedNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.MissingFileContentSnapshot;
import org.gradle.api.internal.changedetection.state.NonNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotMapSerializer
extends AbstractSerializer<Map<String, NormalizedFileSnapshot>> {
    private static final byte DIR_SNAPSHOT = 1;
    private static final byte MISSING_FILE_SNAPSHOT = 2;
    private static final byte REGULAR_FILE_SNAPSHOT = 3;
    private static final byte NO_NORMALIZATION = 1;
    private static final byte DEFAULT_NORMALIZATION = 2;
    private static final byte INDEXED_NORMALIZATION = 3;
    private static final byte IGNORED_PATH_NORMALIZATION = 4;
    private final HashCodeSerializer hashCodeSerializer = new HashCodeSerializer();
    private final StringInterner stringInterner;

    public SnapshotMapSerializer(StringInterner stringInterner) {
        this.stringInterner = stringInterner;
    }

    public Map<String, NormalizedFileSnapshot> read(Decoder decoder) throws Exception {
        int snapshotsCount = decoder.readSmallInt();
        LinkedHashMap<String, NormalizedFileSnapshot> snapshots = new LinkedHashMap<String, NormalizedFileSnapshot>(snapshotsCount);
        for (int i = 0; i < snapshotsCount; ++i) {
            String absolutePath = this.stringInterner.intern(decoder.readString());
            NormalizedFileSnapshot snapshot = this.readSnapshot(absolutePath, decoder, this.stringInterner);
            snapshots.put(absolutePath, snapshot);
        }
        return snapshots;
    }

    private NormalizedFileSnapshot readSnapshot(String absolutePath, Decoder decoder, StringInterner stringInterner) throws IOException {
        FileContentSnapshot snapshot;
        byte fileSnapshotKind = decoder.readByte();
        switch (fileSnapshotKind) {
            case 1: {
                snapshot = DirContentSnapshot.getInstance();
                break;
            }
            case 2: {
                snapshot = MissingFileContentSnapshot.getInstance();
                break;
            }
            case 3: {
                snapshot = new FileHashSnapshot(this.hashCodeSerializer.read(decoder));
                break;
            }
            default: {
                throw new RuntimeException("Unable to read serialized file snapshot. Unrecognized value found in the data stream.");
            }
        }
        byte normalizedSnapshotKind = decoder.readByte();
        switch (normalizedSnapshotKind) {
            case 1: {
                return new NonNormalizedFileSnapshot(absolutePath, snapshot);
            }
            case 2: {
                String normalizedPath = stringInterner.intern(decoder.readString());
                return new DefaultNormalizedFileSnapshot(normalizedPath, snapshot);
            }
            case 3: {
                int index = decoder.readSmallInt();
                return new IndexedNormalizedFileSnapshot(absolutePath, index, snapshot);
            }
            case 4: {
                return new IgnoredPathFileSnapshot(snapshot);
            }
        }
        throw new RuntimeException("Unable to read serialized file snapshot. Unrecognized value found in the data stream.");
    }

    public void write(Encoder encoder, Map<String, NormalizedFileSnapshot> value) throws Exception {
        encoder.writeSmallInt(value.size());
        for (String key : value.keySet()) {
            encoder.writeString((CharSequence)key);
            NormalizedFileSnapshot snapshot = value.get(key);
            this.writeSnapshot(encoder, snapshot);
        }
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SnapshotMapSerializer rhs = (SnapshotMapSerializer)((Object)obj);
        return Objects.equal((Object)this.hashCodeSerializer, (Object)rhs.hashCodeSerializer);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.hashCodeSerializer});
    }

    private void writeSnapshot(Encoder encoder, NormalizedFileSnapshot value) throws IOException {
        FileContentSnapshot snapshot = value.getSnapshot();
        if (snapshot instanceof DirContentSnapshot) {
            encoder.writeByte((byte)1);
        } else if (snapshot instanceof MissingFileContentSnapshot) {
            encoder.writeByte((byte)2);
        } else if (snapshot instanceof FileHashSnapshot) {
            encoder.writeByte((byte)3);
            this.hashCodeSerializer.write(encoder, snapshot.getContentMd5());
        } else {
            throw new AssertionError();
        }
        if (value instanceof NonNormalizedFileSnapshot) {
            encoder.writeByte((byte)1);
        } else if (value instanceof DefaultNormalizedFileSnapshot) {
            encoder.writeByte((byte)2);
            encoder.writeString((CharSequence)value.getNormalizedPath());
        } else if (value instanceof IndexedNormalizedFileSnapshot) {
            encoder.writeByte((byte)3);
            encoder.writeSmallInt(((IndexedNormalizedFileSnapshot)value).getIndex());
        } else if (value instanceof IgnoredPathFileSnapshot) {
            encoder.writeByte((byte)4);
        } else {
            throw new AssertionError();
        }
    }
}

