/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.hash.HashCode;
import org.gradle.api.internal.changedetection.state.Snapshot;
import org.gradle.caching.internal.BuildCacheHasher;

public class ImplementationSnapshot
implements Snapshot {
    private final String typeName;
    private final HashCode classLoaderHash;

    public ImplementationSnapshot(String typeName, HashCode classLoaderHash) {
        this.typeName = typeName;
        this.classLoaderHash = classLoaderHash;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public HashCode getClassLoaderHash() {
        if (this.classLoaderHash == null) {
            throw new NullPointerException("classLoaderHash");
        }
        return this.classLoaderHash;
    }

    public boolean hasUnknownClassLoader() {
        return this.classLoaderHash == null;
    }

    public void appendToHasher(BuildCacheHasher hasher) {
        hasher.putString(ImplementationSnapshot.class.getName());
        hasher.putString(this.typeName);
        hasher.putHash(this.classLoaderHash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplementationSnapshot that = (ImplementationSnapshot)o;
        if (!this.typeName.equals(that.typeName)) {
            return false;
        }
        if (this.classLoaderHash == null || that.classLoaderHash == null) {
            return false;
        }
        return this.classLoaderHash.equals((Object)that.classLoaderHash);
    }

    public int hashCode() {
        int result = this.typeName.hashCode();
        result = 31 * result + (this.classLoaderHash != null ? this.classLoaderHash.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.typeName + "@" + this.classLoaderHash;
    }
}

