/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.gradle.api.Nullable;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.AbstractNamedFileSnapshotTaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotterRegistry;
import org.gradle.api.internal.changedetection.state.OutputFilesSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.normalization.internal.InputNormalizationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilesTaskStateChanges
extends AbstractNamedFileSnapshotTaskStateChanges {
    private final OutputFilesSnapshotter outputSnapshotter;

    public OutputFilesTaskStateChanges(@Nullable TaskExecution previous, TaskExecution current, TaskInternal task, FileCollectionSnapshotterRegistry snapshotterRegistry, OutputFilesSnapshotter outputSnapshotter, InputNormalizationStrategy normalizationStrategy) {
        super(task.getName(), previous, current, snapshotterRegistry, "Output", task.getOutputs().getFileProperties(), normalizationStrategy);
        this.outputSnapshotter = outputSnapshotter;
        this.detectOverlappingOutputs();
    }

    @Override
    public ImmutableSortedMap<String, FileCollectionSnapshot> getPrevious() {
        return this.previous.getOutputFilesSnapshot();
    }

    @Override
    public void saveCurrent() {
        final ImmutableSortedMap<String, FileCollectionSnapshot> outputFilesAfter = this.buildSnapshots(this.getTaskName(), this.getSnapshotterRegistry(), this.getTitle(), (SortedSet<? extends TaskFilePropertySpec>)this.getFileProperties());
        ImmutableSortedMap results = ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformEntries(this.getCurrent(), (Maps.EntryTransformer)new Maps.EntryTransformer<String, FileCollectionSnapshot, FileCollectionSnapshot>(){

            public FileCollectionSnapshot transformEntry(String propertyName, FileCollectionSnapshot beforeExecution) {
                FileCollectionSnapshot afterExecution = (FileCollectionSnapshot)outputFilesAfter.get((Object)propertyName);
                FileCollectionSnapshot afterPreviousExecution = OutputFilesTaskStateChanges.this.getSnapshotAfterPreviousExecution(propertyName);
                return OutputFilesTaskStateChanges.this.outputSnapshotter.createOutputSnapshot(afterPreviousExecution, beforeExecution, afterExecution);
            }
        }));
        this.current.setOutputFilesSnapshot((ImmutableSortedMap<String, FileCollectionSnapshot>)results);
    }

    private FileCollectionSnapshot getSnapshotAfterPreviousExecution(String propertyName) {
        FileCollectionSnapshot afterPreviousExecution;
        ImmutableSortedMap<String, FileCollectionSnapshot> previousSnapshots;
        if (this.previous != null && (previousSnapshots = this.previous.getOutputFilesSnapshot()) != null && (afterPreviousExecution = (FileCollectionSnapshot)previousSnapshots.get(propertyName)) != null) {
            return afterPreviousExecution;
        }
        return FileCollectionSnapshot.EMPTY;
    }

    private void detectOverlappingOutputs() {
        for (Map.Entry entry : this.getCurrent().entrySet()) {
            String propertyName = (String)entry.getKey();
            FileCollectionSnapshot beforeExecution = (FileCollectionSnapshot)entry.getValue();
            FileCollectionSnapshot afterPreviousExecution = this.getSnapshotAfterPreviousExecution(propertyName);
            TaskExecutionHistory.OverlappingOutputs overlappingOutputs = this.outputSnapshotter.detectOverlappingOutputs(propertyName, afterPreviousExecution, beforeExecution);
            if (overlappingOutputs == null) continue;
            this.current.setDetectedOverlappingOutputs(overlappingOutputs);
            return;
        }
    }
}

