/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.spring.boot.application.config.SpringBootConfigurationPropertyReferenceSearcher;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlAccessor;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.util.Processor;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;

public class SpringBootApplicationYamlConfigurationPropertyReferenceSearcher
extends SpringBootConfigurationPropertyReferenceSearcher {
    protected boolean processModelConfigFiles(MethodReferencesSearch.SearchParameters queryParameters, PsiManager psiManager, String prefix, Module module, SpringBootModelConfigFileContributor contributor) {
        if (contributor.getFileType() != YAMLFileType.YML) {
            return true;
        }
        Processor processor = value -> {
            String qualifiedKeyName;
            return value.getValue() instanceof YAMLMapping || !StringUtil.charsEqualIgnoreCase((char)(qualifiedKeyName = SpringBootApplicationYamlUtil.getQualifiedConfigKeyName(value)).charAt(0), (char)prefix.charAt(0)) || SpringBootConfigurationPropertyReferenceSearcher.searchMetaConfigKeyReferences((MethodReferencesSearch.SearchParameters)queryParameters, (PsiReference[])value.getReferences());
        };
        for (VirtualFile file : contributor.getConfigurationFiles(module, true)) {
            PsiFile psiFile = psiManager.findFile(file);
            if (!(psiFile instanceof YAMLFile)) continue;
            YAMLFile yamlFile = (YAMLFile)psiFile;
            for (YAMLDocument document : yamlFile.getDocuments()) {
                if (SpringBootApplicationYamlAccessor.processAllKeys((YAMLPsiElement)document, (Processor<YAMLKeyValue>)processor)) continue;
                return false;
            }
        }
        return true;
    }
}

