/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.application.metadata.RelaxedNames;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

class SpringBootApplicationYamlAccessor {
    @Nullable
    private final YAMLDocument myDocument;

    SpringBootApplicationYamlAccessor(@Nullable YAMLDocument document) {
        this.myDocument = document;
    }

    SpringBootApplicationYamlAccessor(PsiElement context) {
        this((YAMLDocument)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{YAMLDocument.class}));
    }

    private boolean isValid() {
        return this.myDocument != null;
    }

    @Nullable
    YAMLKeyValue findExistingKey(@NotNull String qualifiedKey) {
        if (qualifiedKey == null) {
            SpringBootApplicationYamlAccessor.$$$reportNull$$$0(0);
        }
        if (!this.isValid()) {
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)qualifiedKey)) {
            return null;
        }
        assert (this.myDocument != null);
        YAMLValue searchElement = this.myDocument.getTopLevelValue();
        List key = StringUtil.split((String)qualifiedKey, (String)".");
        for (int i = 0; i < key.size(); ++i) {
            if (!(searchElement instanceof YAMLMapping)) {
                return null;
            }
            String subKey = (String)key.get(i);
            YAMLKeyValue relaxedChild = SpringBootApplicationYamlAccessor.findChildRelaxed((YAMLMapping)searchElement, subKey);
            if (relaxedChild == null || i + 1 == key.size()) {
                return relaxedChild;
            }
            searchElement = relaxedChild.getValue();
        }
        throw new IllegalStateException("Should have returned from the loop '" + qualifiedKey + "'");
    }

    @Nullable
    private static YAMLKeyValue findChildRelaxed(@NotNull YAMLMapping searchElement, final String subKey) {
        YAMLKeyValue byKey;
        if (searchElement == null) {
            SpringBootApplicationYamlAccessor.$$$reportNull$$$0(1);
        }
        if ((byKey = searchElement.getKeyValueByKey(subKey)) != null) {
            return byKey;
        }
        char subKeyLastChar = subKey.charAt(subKey.length() - 1);
        NotNullLazyValue<RelaxedNames> subKeyRelaxedNames = new NotNullLazyValue<RelaxedNames>(){

            @NotNull
            protected RelaxedNames compute() {
                RelaxedNames relaxedNames = new RelaxedNames(subKey);
                if (relaxedNames == null) {
                    1.$$$reportNull$$$0(0);
                }
                return relaxedNames;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlAccessor$1", "compute"));
            }
        };
        for (YAMLKeyValue value : searchElement.getKeyValues()) {
            String myName = value.getName();
            if (myName == null || !StringUtil.charsEqualIgnoreCase((char)myName.charAt(myName.length() - 1), (char)subKeyLastChar)) continue;
            for (String relaxedName : (RelaxedNames)subKeyRelaxedNames.getValue()) {
                if (!myName.equals(relaxedName)) continue;
                return value;
            }
        }
        return null;
    }

    @Nullable
    YAMLKeyValue create(String qualifiedKey) throws IncorrectOperationException {
        Runnable writeRunnable;
        if (!this.isValid()) {
            return null;
        }
        List keyParts = StringUtil.split((String)qualifiedKey, (String)".");
        assert (this.myDocument != null);
        YAMLElementGenerator generator = YAMLElementGenerator.getInstance((Project)this.myDocument.getProject());
        if (!(this.myDocument.getTopLevelValue() instanceof YAMLMapping)) {
            YAMLFile dummyFile = generator.createDummyYamlWithText(YAMLElementGenerator.createChainedKey((List)keyParts, (int)0));
            YAMLValue dummyValue = ((YAMLDocument)dummyFile.getDocuments().get(0)).getTopLevelValue();
            assert (dummyValue != null);
            writeRunnable = () -> {
                if (this.myDocument.getTopLevelValue() == null) {
                    this.myDocument.add((PsiElement)dummyValue);
                } else {
                    this.myDocument.getTopLevelValue().replace((PsiElement)dummyValue);
                }
            };
        } else {
            YAMLMapping topMostExistingMapping = (YAMLMapping)this.myDocument.getTopLevelValue();
            YAMLKeyValue topMostExistingKey = null;
            int foundHierarchies = 0;
            for (String subKey : keyParts) {
                if (topMostExistingMapping == null || (topMostExistingKey = SpringBootApplicationYamlAccessor.findChildRelaxed(topMostExistingMapping, subKey)) == null) break;
                topMostExistingMapping = (YAMLMapping)ObjectUtils.tryCast((Object)topMostExistingKey.getValue(), YAMLMapping.class);
                ++foundHierarchies;
            }
            if (foundHierarchies == keyParts.size()) {
                throw new IncorrectOperationException("key exists already: " + qualifiedKey + "\n" + this.myDocument.getText());
            }
            assert (topMostExistingKey != null || topMostExistingMapping != null);
            int indent = topMostExistingMapping != null ? YAMLUtil.getIndentToThisElement((PsiElement)topMostExistingMapping) : YAMLUtil.getIndentToThisElement((PsiElement)topMostExistingKey) + 2;
            String chainedKey = YAMLElementGenerator.createChainedKey(keyParts.subList(foundHierarchies, keyParts.size()), (int)indent);
            YAMLFile dummyFile = generator.createDummyYamlWithText(chainedKey);
            YAMLKeyValue dummyKeyValue = (YAMLKeyValue)YAMLUtil.getTopLevelKeys((YAMLFile)dummyFile).iterator().next();
            if (topMostExistingMapping == null) {
                YAMLKeyValue finalTopMostExistingKey = topMostExistingKey;
                writeRunnable = () -> finalTopMostExistingKey.setValue((YAMLValue)dummyKeyValue.getParentMapping());
            } else {
                YAMLMapping finalTopMostExistingMapping = topMostExistingMapping;
                writeRunnable = () -> finalTopMostExistingMapping.putKeyValue(dummyKeyValue);
            }
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myDocument.getProject(), (Runnable)writeRunnable);
        return this.findExistingKey(qualifiedKey);
    }

    List<YAMLKeyValue> getAllKeys() {
        if (!this.isValid()) {
            return Collections.emptyList();
        }
        ArrayList<YAMLKeyValue> allKeys = new ArrayList<YAMLKeyValue>();
        Processor collectProcessor = Processors.cancelableCollectProcessor(allKeys);
        SpringBootApplicationYamlAccessor.processAllKeys((YAMLPsiElement)this.myDocument, (Processor<YAMLKeyValue>)collectProcessor);
        return allKeys;
    }

    static boolean processAllKeys(YAMLPsiElement start, Processor<YAMLKeyValue> processor) {
        for (YAMLPsiElement element : start.getYAMLElements()) {
            if (element instanceof YAMLKeyValue) {
                YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element;
                YAMLValue value = yamlKeyValue.getValue();
                if (!processor.process((Object)yamlKeyValue)) {
                    return false;
                }
                if (value instanceof YAMLScalar) continue;
            }
            if (SpringBootApplicationYamlAccessor.processAllKeys(element, processor)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlAccessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findChildRelaxed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

