/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3ApplicationPropertyGroup;
import com.intellij.javaee.openshift.cloud.OS3ApplicationRuntime;
import com.intellij.javaee.openshift.cloud.OS3ServerRuntimeInstance;
import com.intellij.javaee.openshift.cloud.view.OS3PropertiesRuntimeEditor;
import com.intellij.javaee.openshift.cloud.view.OS3ViewContribution;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContribution;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedPaneContentUI;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OS3TreeStructure
extends ServersTreeStructure {
    private static final Key<LoggingHandlerBase> ADDITIONAL_LOG_KEY = Key.create((String)"ADDITIONAL_LOG");
    private final Map<Deployment, DeploymentContent> myDeployment2Content = new HashMap<Deployment, DeploymentContent>();

    public OS3TreeStructure(Project project, OS3ViewContribution contribution, ServersTreeNodeSelector selector) {
        super(project, (RemoteServersViewContribution)contribution, selector);
    }

    protected AbstractTreeNode createDeploymentNode(ServerConnection<?> connection, ServersTreeStructure.RemoteServerNode serverNode, Deployment deployment) {
        return new OS3DeploymentNode(connection, serverNode, deployment);
    }

    private static class OS3TabContentListener
    extends ContentManagerAdapter {
        private OS3TabContentListener() {
        }

        public void contentRemoved(ContentManagerEvent event) {
            Content content = event.getContent();
            LoggingHandlerBase additionalLog = (LoggingHandlerBase)content.getUserData(ADDITIONAL_LOG_KEY);
            TerminalHandlerBase terminalHandler = (TerminalHandlerBase)ObjectUtils.tryCast((Object)additionalLog, TerminalHandlerBase.class);
            if (terminalHandler != null) {
                terminalHandler.close();
            }
            if (additionalLog != null && content.isCloseable()) {
                Disposer.dispose((Disposable)additionalLog);
            }
        }
    }

    private class DeploymentContent {
        private final ContentManager myManager;
        private final Deployment myDeployment;
        private boolean myShown = false;
        private boolean myContentInitialized = false;
        private JPanel myLogPanel;
        private Content myLogContent;
        private List<Content> myPropertiesContents = new ArrayList<Content>();
        private Map<String, OS3PropertiesRuntimeEditor> myPropertyGroupName2Editor = new HashMap<String, OS3PropertiesRuntimeEditor>();

        public DeploymentContent(Deployment deployment) {
            this.myDeployment = deployment;
            ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
            TabbedPaneContentUI contentUI = new TabbedPaneContentUI(1);
            this.myManager = new ContentManagerImpl((ContentUI)contentUI, true, OS3TreeStructure.this.doGetProject()){

                public boolean canCloseAllContents() {
                    return false;
                }
            };
            this.myManager.addContentManagerListener((ContentManagerListener)new OS3TabContentListener());
            DeploymentLogManagerImpl logManager = this.getLogManager();
            if (logManager != null && logManager.isMainHandlerVisible()) {
                Content content = contentFactory.createContent(logManager.getMainLoggingHandler().getConsole().getComponent(), "Log", true);
                content.setCloseable(false);
                this.myManager.addContent(content);
            }
        }

        public ContentManager getManager() {
            return this.myManager;
        }

        private OS3ApplicationRuntime getRuntime() {
            return (OS3ApplicationRuntime)this.myDeployment.getRuntime();
        }

        public void show() {
            if (this.myShown) {
                return;
            }
            this.myShown = true;
            this.initContent();
            this.updateProperties();
        }

        public void initContent() {
            if (this.myContentInitialized || !this.myShown || this.getRuntime() == null) {
                return;
            }
            this.doInitContent();
            this.myContentInitialized = true;
        }

        private void doInitContent() {
            OS3ServerRuntimeInstance.OS3PodApplicationRuntime podRuntime;
            for (Content content : this.myPropertiesContents) {
                this.removeOldContent(content);
            }
            this.removeOldContent(this.myLogContent);
            this.myPropertiesContents.clear();
            this.myPropertyGroupName2Editor.clear();
            OS3ApplicationRuntime runtime = this.getRuntime();
            if (runtime.getApplication() != null) {
                Object[] groups = runtime.getApplication().getPropertyGroups();
                this.myPropertiesContents.addAll(ContainerUtil.map((Object[])groups, this::createPropertiesContent));
            }
            if ((podRuntime = (OS3ServerRuntimeInstance.OS3PodApplicationRuntime)((Object)ObjectUtils.tryCast((Object)((Object)runtime), OS3ServerRuntimeInstance.OS3PodApplicationRuntime.class))) != null) {
                this.myLogPanel = new JPanel();
                this.myLogPanel.setLayout(new BorderLayout());
                this.myLogContent = this.myManager.getFactory().createContent((JComponent)this.myLogPanel, "Log", true);
                this.myLogContent.setCloseable(false);
                this.myManager.addContent(this.myLogContent);
                podRuntime.showLog(OS3TreeStructure.this.doGetProject(), EmptyRunnable.getInstance());
            }
        }

        private void removeOldContent(Content content) {
            if (content != null) {
                this.myManager.removeFromSelection(content);
                this.myManager.removeContent(content, true);
            }
        }

        public Content createPropertiesContent(OS3ApplicationPropertyGroup propertyGroup) {
            String name = propertyGroup.getName();
            OS3PropertiesRuntimeEditor editor = new OS3PropertiesRuntimeEditor(name);
            this.myPropertyGroupName2Editor.put(name, editor);
            this.myContentInitialized = false;
            Content result = this.myManager.getFactory().createContent((JComponent)editor.getMainPanel(), editor.getName(), true);
            result.setCloseable(false);
            this.myManager.addContent(result);
            return result;
        }

        public void updateLogs() {
            DeploymentLogManagerImpl logManager = this.getLogManager();
            if (logManager == null || !this.myContentInitialized) {
                return;
            }
            for (LoggingHandlerBase loggingHandler : logManager.getAdditionalLoggingHandlers()) {
                if (StringUtil.equals((CharSequence)"Log", (CharSequence)loggingHandler.getPresentableName()) && this.myLogPanel.getComponentCount() == 0) {
                    this.myLogPanel.add(loggingHandler.getComponent());
                    this.myLogContent.putUserData(ADDITIONAL_LOG_KEY, (Object)loggingHandler);
                    continue;
                }
                if (this.findAdditionalLogContent(loggingHandler) != null || Disposer.isDisposed((Disposable)loggingHandler)) continue;
                Content content = this.myManager.getFactory().createContent(loggingHandler.getComponent(), loggingHandler.getPresentableName(), true);
                content.putUserData(ADDITIONAL_LOG_KEY, (Object)loggingHandler);
                this.myManager.addContent(content);
            }
        }

        private Content findAdditionalLogContent(LoggingHandlerBase loggingHandler) {
            for (Content content : this.myManager.getContents()) {
                LoggingHandlerBase additionalLog = (LoggingHandlerBase)content.getUserData(ADDITIONAL_LOG_KEY);
                if (additionalLog != loggingHandler) continue;
                return content;
            }
            return null;
        }

        private DeploymentLogManagerImpl getLogManager() {
            return (DeploymentLogManagerImpl)this.myDeployment.getConnection().getLogManager(this.myDeployment);
        }

        public void updateProperties() {
            Object application = this.getRuntime().getApplication();
            if (application == null) {
                return;
            }
            String newVersion = application.getVersion();
            for (OS3ApplicationPropertyGroup group : application.getPropertyGroups()) {
                OS3PropertiesRuntimeEditor editor = this.myPropertyGroupName2Editor.get(group.getName());
                if (editor == null || StringUtil.equals((CharSequence)newVersion, (CharSequence)editor.getVersion())) continue;
                editor.updateItems(group);
                editor.setVersion(newVersion);
            }
        }
    }

    public class OS3DeploymentNode
    extends ServersTreeStructure.DeploymentNodeImpl {
        private final DeploymentContent myContent;

        protected OS3DeploymentNode(@NotNull ServerConnection<?> connection, @NotNull ServersTreeStructure.RemoteServerNode serverNode, Deployment value) {
            if (connection == null) {
                OS3DeploymentNode.$$$reportNull$$$0(0);
            }
            if (serverNode == null) {
                OS3DeploymentNode.$$$reportNull$$$0(1);
            }
            if (value == null) {
                OS3DeploymentNode.$$$reportNull$$$0(2);
            }
            super((ServersTreeStructure)OS3TreeStructure.this, connection, serverNode, value);
            this.myContent = (DeploymentContent)ContainerUtil.getOrCreate((Map)OS3TreeStructure.this.myDeployment2Content, (Object)value, () -> {
                if (value == null) {
                    OS3DeploymentNode.$$$reportNull$$$0(4);
                }
                return new DeploymentContent(value);
            });
            this.myContent.initContent();
            this.myContent.updateLogs();
            this.myContent.updateProperties();
        }

        @Nullable
        public JComponent getComponent() {
            this.myContent.show();
            return this.myContent.getManager().getComponent();
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ArrayList result = new ArrayList();
            this.collectDeploymentChildren(result);
            ArrayList arrayList = result;
            if (arrayList == null) {
                OS3DeploymentNode.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        protected void update(PresentationData presentation) {
            super.update(presentation);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverNode";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javaee/openshift/cloud/view/OS3TreeStructure$OS3DeploymentNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javaee/openshift/cloud/view/OS3TreeStructure$OS3DeploymentNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$new$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

