/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.info;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class CoberturaLoaderUtil {
    private static final Logger LOG = Logger.getInstance(CoberturaLoaderUtil.class);

    private CoberturaLoaderUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectData load(File sessionDataFile) {
        ProjectData projectInfo = new ProjectData();
        FilterInputStream dataFile = null;
        try {
            dataFile = new DataInputStream(new FileInputStream(sessionDataFile));
            int classesCount = dataFile.read();
            for (int i = 0; i < classesCount; ++i) {
                String classFQName = ((DataInputStream)dataFile).readUTF();
                ((DataInputStream)dataFile).readUTF();
                ClassData classData = projectInfo.getOrCreateClassData(classFQName);
                int numberOfLines = dataFile.read();
                for (int l = 0; l < numberOfLines; ++l) {
                    int lineNumber = dataFile.read();
                    Object lineData = null;
                    long hits = ((DataInputStream)dataFile).readLong();
                    int jumpsNumber = dataFile.read();
                    int trueHits = 0;
                    int falseHits = 0;
                    int totalHits = 0;
                    for (int j = 0; j < jumpsNumber; ++j) {
                        dataFile.read();
                        ++totalHits;
                        if (((DataInputStream)dataFile).readLong() > 0L) {
                            ++trueHits;
                        }
                        ++totalHits;
                        if (((DataInputStream)dataFile).readLong() <= 0L) continue;
                        ++falseHits;
                    }
                    int defaultHitsNumber = 0;
                    int branchHitNumber = 0;
                    int switchNumber = dataFile.read();
                    for (int s = 0; s < switchNumber; ++s) {
                        dataFile.read();
                        dataFile.read();
                        long defaultHits = ((DataInputStream)dataFile).readLong();
                        if (defaultHits > 0L) {
                            ++defaultHitsNumber;
                        }
                        int coveredSwitchBranches = 0;
                        int switchBranchesNumber = dataFile.read();
                        for (int b = 0; b < switchBranchesNumber; ++b) {
                            long branchHit = ((DataInputStream)dataFile).readLong();
                            if (branchHit <= 0L) continue;
                            ++coveredSwitchBranches;
                        }
                        if (coveredSwitchBranches != switchBranchesNumber) continue;
                        ++branchHitNumber;
                    }
                    if (hits > 0L) {
                        if (totalHits == trueHits + falseHits && defaultHitsNumber == switchNumber && branchHitNumber == switchNumber) {
                            lineData.setStatus((byte)2);
                            continue;
                        }
                        lineData.setStatus((byte)1);
                        continue;
                    }
                    lineData.setStatus((byte)0);
                }
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        finally {
            if (dataFile != null) {
                try {
                    dataFile.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return projectInfo;
    }
}

