/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageOptions;
import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.IdeBorderFactory;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JavaCoverageOptions
extends CoverageOptions {
    private final JavaCoverageOptionsProvider myCoverageOptionsProvider;
    private JavaCoverageOptionsEditor myEditor;

    public JavaCoverageOptions(JavaCoverageOptionsProvider coverageOptionsProvider) {
        this.myCoverageOptionsProvider = coverageOptionsProvider;
    }

    @Override
    public JComponent getComponent() {
        this.myEditor = new JavaCoverageOptionsEditor();
        return this.myEditor.getComponent();
    }

    @Override
    public boolean isModified() {
        return this.myEditor.isModified(this.myCoverageOptionsProvider);
    }

    @Override
    public void apply() {
        this.myEditor.apply(this.myCoverageOptionsProvider);
    }

    @Override
    public void reset() {
        this.myEditor.reset(this.myCoverageOptionsProvider);
    }

    @Override
    public void disposeUIResources() {
        this.myEditor = null;
    }

    private static class JavaCoverageOptionsEditor {
        private JPanel myPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        private JCheckBox myImplicitCheckBox = new JCheckBox("Ignore implicit constructors", true);
        private JCheckBox myEmptyCheckBox = new JCheckBox("Ignore empty private constructors of utility classes", true);

        public JavaCoverageOptionsEditor() {
            this.myPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Java coverage"));
            this.myPanel.add(this.myImplicitCheckBox);
            this.myPanel.add(this.myEmptyCheckBox);
        }

        public JPanel getComponent() {
            return this.myPanel;
        }

        public boolean isModified(JavaCoverageOptionsProvider provider) {
            return this.myImplicitCheckBox.isSelected() != provider.ignoreImplicitConstructors() || this.myEmptyCheckBox.isSelected() != provider.ignoreEmptyPrivateConstructors();
        }

        public void apply(JavaCoverageOptionsProvider provider) {
            provider.setIgnoreImplicitConstructors(this.myImplicitCheckBox.isSelected());
            provider.setIgnoreEmptyPrivateConstructors(this.myEmptyCheckBox.isSelected());
        }

        public void reset(JavaCoverageOptionsProvider provider) {
            this.myImplicitCheckBox.setSelected(provider.ignoreImplicitConstructors());
            this.myEmptyCheckBox.setSelected(provider.ignoreEmptyPrivateConstructors());
        }
    }
}

