/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Collections;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenPatternFileFilter
implements FileFilter {
    private String[] myNormalizedIncludes;
    private String[] myNormalizedExcludes;

    public MavenPatternFileFilter(@Nullable String includes, @Nullable String excludes) {
        this(includes == null ? Collections.emptyList() : StringUtil.split((String)includes, (String)","), excludes == null ? Collections.emptyList() : StringUtil.split((String)excludes, (String)","));
    }

    public MavenPatternFileFilter(@Nullable Collection<String> includes, @Nullable Collection<String> excludes) {
        this.myNormalizedIncludes = MavenPatternFileFilter.normalizePatterns(includes);
        this.myNormalizedExcludes = MavenPatternFileFilter.normalizePatterns(excludes);
    }

    @Override
    public boolean accept(File pathname) {
        return this.accept(pathname.getPath());
    }

    public boolean accept(String path) {
        return MavenPatternFileFilter.accept(path, this.myNormalizedIncludes, this.myNormalizedExcludes);
    }

    private static boolean accept(String path, String[] includes, String[] excludes) {
        boolean isIncluded = includes.length == 0;
        for (String each : includes) {
            if (!SelectorUtils.matchPath((String)each, (String)path)) continue;
            isIncluded = true;
            break;
        }
        if (!isIncluded) {
            return false;
        }
        for (String each : excludes) {
            if (!SelectorUtils.matchPath((String)each, (String)path)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static String[] normalizePatterns(@Nullable Collection<String> patterns) {
        if (ContainerUtil.isEmpty(patterns)) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                MavenPatternFileFilter.$$$reportNull$$$0(0);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] res = new String[patterns.size()];
        int i = 0;
        for (String pattern : patterns) {
            res[i++] = MavenPatternFileFilter.normalizePattern(pattern);
        }
        if (res == null) {
            MavenPatternFileFilter.$$$reportNull$$$0(1);
        }
        return res;
    }

    private static String normalizePattern(String pattern) {
        if ((pattern = pattern.trim()).startsWith("%regex[")) {
            pattern = File.separatorChar == '\\' ? StringUtils.replace((String)pattern, (String)"/", (String)"\\\\") : StringUtils.replace((String)pattern, (String)"\\\\", (String)"/");
        } else if ((pattern = pattern.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/maven/compiler/MavenPatternFileFilter", "normalizePatterns"));
    }
}

