/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.ui;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.jboss.jbpm.dnd.ChartDnDSupport;
import com.intellij.jboss.jbpm.layout.ChartLayoutCoordinator;
import com.intellij.jboss.jbpm.layout.ChartPersistentLayouter;
import com.intellij.jboss.jbpm.model.ChartDataModel;
import com.intellij.jboss.jbpm.model.ChartSource;
import com.intellij.jboss.jbpm.settings.ChartProvider;
import com.intellij.jboss.jbpm.ui.ChartBuilder;
import com.intellij.jboss.jbpm.ui.ChartBuilderFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.GraphEvent;
import com.intellij.openapi.graph.base.GraphListener;
import com.intellij.openapi.graph.builder.dnd.SimpleDnDPanel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ChartDesignerComponent<T>
extends JPanel
implements Disposable {
    public static final byte POST_EVENT = 13;
    private final MergingUpdateQueue mergingUpdateQueue;
    private ChartBuilder<T> chartBuilder;
    private ChartPersistentLayouter<T> chartPersistentLayouter;

    public ChartDesignerComponent(Project project, ChartSource source, ChartProvider<T> chartProvider) {
        this.chartBuilder = this.createChartBuilder(project, source, chartProvider);
        Disposer.register((Disposable)this, this.chartBuilder);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createToolbarPanel(), "North");
        this.mergingUpdateQueue = new MergingUpdateQueue(chartProvider.getChartId(), 100, true, (JComponent)this);
        ChartDnDSupport dnDSupport = chartProvider.creteDnDSupport((ChartDataModel<T>)this.chartBuilder.getDataModel());
        if (dnDSupport != null) {
            SimpleDnDPanel simpleDnDPanel = dnDSupport.createDnDActions(project, this.chartBuilder);
            simpleDnDPanel.getTree().setShowsRootHandles(true);
            Splitter splitter = new Splitter(false, 0.85f);
            this.add((Component)splitter, "Center");
            splitter.setFirstComponent(this.chartBuilder.getView().getJComponent());
            splitter.setSecondComponent((JComponent)simpleDnDPanel.getTree());
            splitter.setDividerWidth(5);
        } else {
            this.add(this.chartBuilder.getView().getJComponent());
        }
        new UiNotifyConnector((Component)this, new Activatable(){

            public void showNotify() {
                ChartDesignerComponent.this.refreshDataModel();
            }

            public void hideNotify() {
            }
        });
        Disposer.register((Disposable)this, this.chartBuilder);
        Disposer.register((Disposable)this, (Disposable)this.mergingUpdateQueue);
    }

    private JComponent createToolbarPanel() {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)GraphViewUtil.getBasicToolbar((Graph2D)this.chartBuilder.getGraph()));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("JbpmChartDesigner", (ActionGroup)actions, true);
        return actionToolbar.getComponent();
    }

    private ChartBuilder<T> createChartBuilder(Project project, ChartSource source, ChartProvider<T> chartProvider) {
        VirtualFile file = source.getFile();
        PsiFile psiFile = file == null ? null : PsiManager.getInstance((Project)project).findFile(file);
        ChartBuilder<T> chartBuilder = ChartBuilderFactory.create(project, chartProvider, source);
        ChartLayoutCoordinator chartLayoutCoordinator = chartBuilder.getChartLayoutCoordinator();
        chartBuilder.getView().setFitContentOnResize(true);
        chartBuilder.getPresentationModel().registerActions();
        Graph2DView view = chartBuilder.getView();
        view.getCanvasComponent().setBackground((Color)JBColor.GRAY);
        GraphSettings settings = GraphSettingsProvider.getInstance((Project)project).getSettings((Graph)chartBuilder.getGraph());
        if (chartLayoutCoordinator != null) {
            this.chartPersistentLayouter = new ChartPersistentLayouter(chartLayoutCoordinator, chartProvider.getVfsResolver(), chartBuilder.getDataModel(), new PsiFile[]{psiFile}, DocumentReference.EMPTY_ARRAY);
            settings.setCurrentLayouter(this.chartPersistentLayouter);
            chartBuilder.getGraph().addGraphListener(new GraphListener(){

                public void onGraphEvent(GraphEvent _e) {
                    if (_e.getType() == 13) {
                        ChartDesignerComponent.this.chartPersistentLayouter.applyLayoutChanges();
                    }
                }
            });
        }
        source.addChangeListener(new ChartSource.ChartSourceChangeListener(){

            @Override
            public void chartSourceHasChanged() {
                if (ChartDesignerComponent.this.isShowing()) {
                    ChartDesignerComponent.this.scheduleUpdate();
                }
            }
        });
        return chartBuilder;
    }

    public void scheduleUpdate() {
        this.mergingUpdateQueue.queue(new Update("Update"){

            public void run() {
                ChartDesignerComponent.this.refreshDataModel();
            }
        });
    }

    public void refreshDataModel() {
        DiagramDataModel model = this.chartBuilder.getDataModel();
        Collection nodes = model.getNodes();
        model.refreshDataModel();
        model.setModelInitializationFinished();
        SwingUtilities.invokeLater(() -> this.chartBuilder.update(true, true));
    }

    public void dispose() {
    }
}

