/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.providers;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ProvidersCoordinator {
    private final Map<Class<?>, Object> providers = new HashMap();

    public static ProvidersCoordinator getInstance() {
        return SingletonHolder.HOLDER_INSTANCE;
    }

    public <T> T getProvider(Class<? extends T> clazz) {
        Object provider = this.providers.get(clazz);
        if (provider == null) {
            provider = this.createProvider(clazz);
            assert (provider != null) : "Could not create instance of type " + clazz.getName();
            this.providers.put(clazz, provider);
        }
        return (T)provider;
    }

    @Nullable
    public <T> T createProvider(Class<? extends T> providerClass) {
        try {
            return providerClass.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private static class SingletonHolder {
        public static final ProvidersCoordinator HOLDER_INSTANCE = new ProvidersCoordinator();

        private SingletonHolder() {
        }
    }
}

