/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinRecursiveElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractCucumberExtension;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public abstract class AbstractCucumberJavaExtension
extends AbstractCucumberExtension {
    public boolean isStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            AbstractCucumberJavaExtension.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            AbstractCucumberJavaExtension.$$$reportNull$$$0(1);
        }
        return child instanceof PsiClassOwner;
    }

    public boolean isWritableStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        VirtualFile vFile;
        PsiFile file;
        if (child == null) {
            AbstractCucumberJavaExtension.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            AbstractCucumberJavaExtension.$$$reportNull$$$0(3);
        }
        if (child instanceof PsiClassOwner && (file = child.getContainingFile()) != null && (vFile = file.getVirtualFile()) != null) {
            VirtualFile rootForFile = ProjectRootManager.getInstance((Project)child.getProject()).getFileIndex().getSourceRootForFile(vFile);
            return rootForFile != null;
        }
        return false;
    }

    @NotNull
    public Collection<String> getGlues(@NotNull GherkinFile file, Set<String> gluesFromOtherFiles) {
        if (file == null) {
            AbstractCucumberJavaExtension.$$$reportNull$$$0(4);
        }
        if (gluesFromOtherFiles == null) {
            gluesFromOtherFiles = ContainerUtil.newHashSet();
        }
        final HashSet glues = gluesFromOtherFiles;
        file.accept((PsiElementVisitor)new GherkinRecursiveElementVisitor(){

            public void visitStep(GherkinStep step) {
                String glue = CucumberJavaUtil.getPackageOfStep(step);
                if (glue != null) {
                    CucumberJavaUtil.addGlue(glue, glues);
                }
            }
        });
        HashSet hashSet = glues;
        if (hashSet == null) {
            AbstractCucumberJavaExtension.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    public Collection<? extends PsiFile> getStepDefinitionContainers(@NotNull GherkinFile featureFile) {
        Module module;
        if (featureFile == null) {
            AbstractCucumberJavaExtension.$$$reportNull$$$0(6);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)featureFile)) == null) {
            return Collections.emptySet();
        }
        List stepDefs = this.loadStepsFor((PsiFile)featureFile, module);
        HashSet<PsiFile> result = new HashSet<PsiFile>();
        for (AbstractStepDefinition stepDef : stepDefs) {
            PsiFile psiFile;
            PsiElement stepDefElement = stepDef.getElement();
            if (stepDefElement == null || !this.isWritableStepLikeFile((PsiElement)(psiFile = stepDefElement.getContainingFile()), (PsiElement)psiFile.getParent())) continue;
            result.add(psiFile);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/java/AbstractCucumberJavaExtension";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/java/AbstractCucumberJavaExtension";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isStepLikeFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isWritableStepLikeFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGlues";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStepDefinitionContainers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

