/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.indexer.impl.types;

import java.util.Collection;
import org.osgi.framework.Version;
import org.osgi.service.indexer.impl.types.ScalarType;

class Type {
    private final ScalarType type;
    private final boolean list;

    public static Type scalar(ScalarType type) {
        return new Type(type, false);
    }

    public static Type list(ScalarType type) {
        return new Type(type, true);
    }

    public static Type typeOf(Object value) throws IllegalArgumentException {
        Type result;
        if (value == null) {
            throw new NullPointerException("Null values not supported.");
        }
        if (value instanceof Version) {
            result = Type.scalar(ScalarType.Version);
        } else if (value instanceof Double || value instanceof Float) {
            result = Type.scalar(ScalarType.Double);
        } else if (value instanceof Number) {
            result = Type.scalar(ScalarType.Long);
        } else if (value instanceof String) {
            result = Type.scalar(ScalarType.String);
        } else if (value instanceof Boolean) {
            result = Type.scalar(ScalarType.String);
        } else if (value instanceof Collection) {
            Collection coll = (Collection)value;
            if (coll.isEmpty()) {
                throw new IllegalArgumentException("Cannot determine scalar type of empty collection.");
            }
            Type elemType = Type.typeOf(coll.iterator().next());
            result = Type.list(elemType.type);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass());
        }
        return result;
    }

    private Type(ScalarType type, boolean list) {
        this.type = type;
        this.list = list;
    }

    public ScalarType getType() {
        return this.type;
    }

    public boolean isList() {
        return this.list;
    }

    public String toString() {
        return this.list ? "List<" + this.type.name() + ">" : this.type.name();
    }

    public String convertToString(Object value) {
        String result;
        if (this.list) {
            Collection coll = (Collection)value;
            StringBuilder buf = new StringBuilder();
            int count = 0;
            for (Object obj : coll) {
                if (count++ > 0) {
                    buf.append(',');
                }
                buf.append(obj);
            }
            result = buf.toString();
        } else {
            result = value.toString();
        }
        return result;
    }
}

