/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.indexer.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.osgi.service.indexer.impl.URLResolver;

class GeneratorState {
    private final URI rootUrl;
    private final String urlTemplate;
    private List<URLResolver> resolver;

    public GeneratorState(URI rootUrl, String urlTemplate, List<URLResolver> resolver) throws URISyntaxException {
        this.rootUrl = rootUrl;
        this.urlTemplate = urlTemplate;
        this.resolver = resolver;
    }

    URI getRootUrl() {
        return this.rootUrl;
    }

    String getUrlTemplate() {
        return this.urlTemplate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rootUrl == null ? 0 : this.rootUrl.hashCode());
        result = 31 * result + (this.urlTemplate == null ? 0 : this.urlTemplate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneratorState other = (GeneratorState)obj;
        if (this.rootUrl == null ? other.rootUrl != null : !this.rootUrl.equals(other.rootUrl)) {
            return false;
        }
        return !(this.urlTemplate == null ? other.urlTemplate != null : !this.urlTemplate.equals(other.urlTemplate));
    }

    public String toString() {
        return "GeneratorState [rootUrl=" + this.rootUrl + ", urlTemplate=" + this.urlTemplate + "]";
    }

    public List<URLResolver> getResolvers() {
        return this.resolver;
    }
}

