/*
 * Decompiled with CFR 0.152.
 */
package aQute.struct;

import aQute.struct.Define;
import aQute.struct.InvalidException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;

public class struct
implements Cloneable {
    static final Pattern NEED_NO_ESCAPE = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*");
    static Field[] EMPTY = new Field[0];
    private static final WeakHashMap<Class, Cache> caches = new WeakHashMap();
    private final Cache cache = struct.getCache(this.getClass());
    private int hash;
    @Define(optional=true, description="Used for extra data found in decoding a stream")
    public Map<String, Object> __extra;

    public struct() {
        if (this.cache.fs.length == 0) {
            throw new IllegalStateException("A struct requires at least one field: " + this.getClass());
        }
    }

    static synchronized Cache getCache(Class clazz) {
        Cache c = caches.get(clazz);
        if (c == null) {
            Field f;
            HashSet<Field> ids = new HashSet<Field>();
            Field id = null;
            c = new Cache();
            ArrayList<Field> fs = new ArrayList<Field>();
            Field[] fieldArray = clazz.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                f = fieldArray[n2];
                if (!Modifier.isStatic(f.getModifiers())) {
                    Define define;
                    fs.add(f);
                    if (f.getName().equals("_id")) {
                        id = f;
                    }
                    if ((define = f.getAnnotation(Define.class)) != null && define.id()) {
                        ids.add(f);
                    }
                }
                ++n2;
            }
            c.fs = fs.toArray(new Field[0]);
            c.size = c.fs.length;
            fieldArray = c.fs;
            n = c.fs.length;
            n2 = 0;
            while (n2 < n) {
                f = fieldArray[n2];
                if (!f.getName().equals("__extra")) {
                    c.fields.put(f.getName(), f);
                }
                ++n2;
            }
            c.names = c.fields.keySet().toArray(new String[0]);
            if (ids.isEmpty()) {
                if (id != null) {
                    c.ids = new Field[]{id};
                }
            } else {
                c.ids = ids.toArray(new Field[ids.size()]);
            }
            Arrays.sort(c.names);
            caches.put(clazz, c);
        }
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter format = new Formatter(sb);
        struct.toString(this, format, false);
        return sb.toString();
    }

    public void toJson(Appendable appendable) {
        Formatter format = new Formatter(appendable);
        struct.toString(this, format, true);
    }

    public void toJson(OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, "UTF-8");
        try {
            this.toJson(w);
        }
        finally {
            ((Writer)w).close();
        }
    }

    private static void toString(Iterable<?> i, Formatter sb, boolean json) {
        sb.format("[", new Object[0]);
        String del = "";
        for (Object m : i) {
            sb.format(del, new Object[0]);
            struct.toString(m, sb, json);
            del = ",";
        }
        sb.format("]", new Object[0]);
    }

    private static void toString(Map<?, ?> map, Formatter sb, boolean json) {
        sb.format("{", new Object[0]);
        String del = "";
        for (Map.Entry<?, ?> e : map.entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            if (v == null) continue;
            String s = k == null ? "null" : k.toString();
            sb.format(del, new Object[0]);
            if (json || !NEED_NO_ESCAPE.matcher(s).matches()) {
                struct.toString(e.getKey().toString(), sb, json);
            } else {
                sb.format(s, new Object[0]);
            }
            sb.format(":", new Object[0]);
            struct.toString(e.getValue(), sb, json);
            del = ",";
        }
        sb.format("}", new Object[0]);
    }

    private static void toString(struct o, Formatter sb, boolean json) {
        try {
            sb.format("{", new Object[0]);
            String del = "";
            Field[] fieldArray = o.fields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                Object object = f.get(o);
                if (object != null) {
                    sb.format(del, new Object[0]);
                    String key = f.getName();
                    if (json) {
                        struct.toString(key, sb, json);
                    } else {
                        sb.format(f.getName(), new Object[0]);
                    }
                    sb.format(":", new Object[0]);
                    struct.toString(object, sb, json);
                    del = ",";
                }
                ++n2;
            }
            sb.format("}", new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static void toString(Object o, Formatter sb, boolean json) {
        if (o == null) {
            sb.format("null", new Object[0]);
            return;
        }
        if (o.getClass().isArray()) {
            struct.toStringArray(o, sb, json);
            return;
        }
        if (o instanceof Iterable) {
            struct.toString((Iterable)o, sb, json);
            return;
        }
        if (o instanceof Map) {
            struct.toString((Map)o, sb, json);
            return;
        }
        if (o instanceof struct) {
            struct.toString((struct)o, sb, json);
            return;
        }
        if (o instanceof Number || o instanceof Boolean) {
            sb.format("%s", o);
            return;
        }
        struct.toString(o.toString(), sb, json);
    }

    private static void toStringArray(Object a, Formatter sb, boolean json) {
        if (a instanceof byte[]) {
            byte[] array = (byte[])a;
            int skipBegin = 15;
            int skipEnd = array.length - 15;
            sb.format("\"", new Object[0]);
            int i = 0;
            while (i < array.length) {
                if (!json && i >= skipBegin && i < skipEnd) {
                    if (i == skipBegin) {
                        sb.format("...", new Object[0]);
                    }
                } else {
                    sb.format("%02X", array[i]);
                }
                ++i;
            }
            sb.format("\"", new Object[0]);
            return;
        }
        sb.format("[", new Object[0]);
        String del = "";
        int l = Array.getLength(a);
        int i = 0;
        while (i < l) {
            sb.format(del, new Object[0]);
            Object o = Array.get(a, i);
            struct.toString(o, sb, json);
            del = ",";
            ++i;
        }
        sb.format("]", new Object[0]);
    }

    private static void toString(String s, Formatter sb, boolean json) {
        sb.format("\"", new Object[0]);
        int skipBegin = 25;
        int skipEnd = s.length() - 25;
        int i = 0;
        while (i < s.length()) {
            if (!json && i >= skipBegin && i < skipEnd) {
                if (i == skipBegin) {
                    sb.format("...", new Object[0]);
                }
            } else {
                char c = s.charAt(i);
                switch (c) {
                    case '\t': {
                        sb.format("\\t", new Object[0]);
                        break;
                    }
                    case '\b': {
                        sb.format("\\b", new Object[0]);
                        break;
                    }
                    case '\f': {
                        sb.format("\\f", new Object[0]);
                        break;
                    }
                    case '\n': {
                        sb.format("\\n", new Object[0]);
                        break;
                    }
                    case '\r': {
                        sb.format("\\r", new Object[0]);
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        sb.format("\\%c", Character.valueOf(c));
                        break;
                    }
                    default: {
                        if (c > '\u007f' || c < ' ') {
                            sb.format("\\u%04x", c);
                            break;
                        }
                        sb.format("%c", Character.valueOf(c));
                    }
                }
            }
            ++i;
        }
        sb.format("\"", new Object[0]);
    }

    public Type getType(String key) {
        Field f = this.cache.fields.get(key);
        if (f == null) {
            return null;
        }
        return f.getGenericType();
    }

    public static Field[] fields(Class c) {
        return struct.getCache((Class)c).fs;
    }

    public static Field getField(Class c, String f) {
        return struct.getCache((Class)c).fields.get(f);
    }

    public Field getField(String f) {
        return this.cache.fields.get(f);
    }

    public Object $(String name) throws Exception {
        Field f = this.cache.fields.get(name);
        if (f == null) {
            return null;
        }
        return f.get(this);
    }

    public void $(String key, Object value) throws Exception {
        Field f = this.getField(key);
        f.set(this, value);
    }

    public Field[] fields() {
        return this.cache.fs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        if (this.cache.ids.length != 0) {
            try {
                Field[] fieldArray = this.cache.ids;
                int n = this.cache.ids.length;
                int n2 = 0;
                while (true) {
                    Object b;
                    if (n2 >= n) {
                        return true;
                    }
                    Field f = fieldArray[n2];
                    Object a = f.get(this);
                    if (a != (b = f.get(other))) {
                        if (a == null) {
                            return false;
                        }
                        if (!a.equals(b)) {
                            return false;
                        }
                        if (!a.getClass().isArray()) {
                            return false;
                        }
                        if (a instanceof byte[] && !Arrays.equals((byte[])a, (byte[])b)) {
                            return false;
                        }
                        Arrays.deepEquals((Object[])a, (Object[])b);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        if (this.cache.ids.length == 0) {
            return super.hashCode();
        }
        try {
            Object v = this.cache.ids[0].get(this);
            if (v != null) {
                this.hash = v.hashCode();
                return this.hash;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hash = -1;
        return -1;
    }

    public static <T> List<T> list() {
        return new ArrayList();
    }

    public static <T> Map<String, T> map() {
        return new LinkedHashMap();
    }

    public static <T> Set<T> set() {
        return new LinkedHashSet();
    }

    public Map<String, Object> asMap() {
        return new Map<String, Object>(){

            @Override
            public int size() {
                return ((struct)struct.this).cache.fs.length;
            }

            @Override
            public boolean isEmpty() {
                return this.size() == 0;
            }

            @Override
            public boolean containsKey(Object key) {
                return ((struct)struct.this).cache.fields.containsKey(key);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean containsValue(Object value) {
                try {
                    Field[] fieldArray = ((struct)struct.this).cache.fs;
                    int n = ((struct)struct.this).cache.fs.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        Field f = fieldArray[n2];
                        Object v = f.get(struct.this);
                        if (v == null) {
                            if (value != null) return true;
                            return true;
                        }
                        if (v.equals(value)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                return false;
            }

            @Override
            public Object get(Object key) {
                Field f;
                block3: {
                    try {
                        f = ((struct)struct.this).cache.fields.get(key);
                        if (f != null) break block3;
                        return null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        return null;
                    }
                }
                return f.get(struct.this);
            }

            @Override
            public Object put(String key, Object value) {
                try {
                    Field f = ((struct)struct.this).cache.fields.get(key);
                    if (f == null) {
                        if (struct.this.__extra == null) {
                            struct.this.__extra = new HashMap<String, Object>();
                        }
                        return struct.this.__extra.put(key, value);
                    }
                    Object old = f.get(this);
                    f.set(struct.this, value);
                    return old;
                }
                catch (IllegalAccessException illegalAccessException) {
                    return null;
                }
            }

            @Override
            public Object remove(Object key) {
                throw new UnsupportedOperationException("No such key possible for struct " + this.getClass() + "." + key);
            }

            @Override
            public void putAll(Map<? extends String, ? extends Object> m) {
                for (Map.Entry<? extends String, ? extends Object> e : m.entrySet()) {
                    this.put(e.getKey(), e.getValue());
                }
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("struct " + this.getClass() + " cannot be cleared");
            }

            @Override
            public Set<String> keySet() {
                return ((struct)struct.this).cache.keys;
            }

            @Override
            public Collection<Object> values() {
                ArrayList<Object> objects = new ArrayList<Object>();
                try {
                    Field[] fieldArray = ((struct)struct.this).cache.fs;
                    int n = ((struct)struct.this).cache.fs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field f = fieldArray[n2];
                        objects.add(f.get(struct.this));
                        ++n2;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                return objects;
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>();
                Field[] fieldArray = ((struct)struct.this).cache.fs;
                int n = ((struct)struct.this).cache.fs.length;
                int n2 = 0;
                while (n2 < n) {
                    final Field f = fieldArray[n2];
                    entries.add(new Map.Entry<String, Object>(){

                        @Override
                        public String getKey() {
                            return f.getName();
                        }

                        @Override
                        public Object getValue() {
                            try {
                                return f.get(struct.this);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                return null;
                            }
                        }

                        @Override
                        public Object setValue(Object value) {
                            try {
                                Object old = f.get(struct.this);
                                f.set(struct.this, value);
                                return old;
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                return null;
                            }
                        }
                    });
                    ++n2;
                }
                return entries;
            }
        };
    }

    public List<Error> validate() throws Exception {
        ArrayList<Error> result = new ArrayList<Error>();
        struct.validateStruct(null, this, result, "");
        return result;
    }

    private static void validateStruct(Define ourDefine, struct struct2, List<Error> result, String path) {
        if (struct2.cache.size == 1) {
            result.add(struct.getValidation(null, path, "No public fields are defined", null, ErrorCode.NO_FIELDS));
        }
        Field[] fieldArray = struct2.cache.fs;
        int n = struct2.cache.fs.length;
        int n2 = 0;
        while (n2 < n) {
            Object o;
            Field f = fieldArray[n2];
            try {
                o = f.get(struct2);
            }
            catch (IllegalAccessException e) {
                return;
            }
            Define define = f.getAnnotation(Define.class);
            if (!(o != null || define != null && define.optional())) {
                result.add(struct.getValidation(define, String.valueOf(path) + "." + f.getName(), "Required but is null", null, ErrorCode.REQUIRED));
            }
            if (o != null) {
                struct.validate(define, result, o, String.valueOf(path) + "." + f.getName());
            }
            ++n2;
        }
    }

    private static void validate(Define define, List<Error> result, Object o, String path) {
        if (o instanceof struct) {
            struct.validateStruct(define, (struct)o, result, path);
            return;
        }
        if (o instanceof Iterable) {
            struct.validateIterable(define, (Iterable)o, result, path);
            return;
        }
        if (o.getClass().isArray() && o.getClass() != byte[].class && o.getClass() != char[].class) {
            struct.validateArray(define, o, result, path);
            return;
        }
        if (o instanceof Map) {
            struct.validateMap(define, (Map)o, result, path);
            return;
        }
        if (define == null) {
            return;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            long l = n.longValue();
            if (l < define.min()) {
                result.add(struct.getValidation(define, path, "Value is too small, must be at least " + define.min(), o, ErrorCode.TOO_SMALL));
            }
            if (l > define.max()) {
                result.add(struct.getValidation(define, path, "Value is too large, must be at most " + define.max(), o, ErrorCode.TOO_LARGE));
            }
        }
        String s = o.toString();
        String pattern = define.pattern();
        if (!pattern.isEmpty() && !s.matches(pattern)) {
            result.add(struct.getValidation(define, path, "Could not match pattern " + pattern, o, ErrorCode.MISMATCH));
        }
    }

    private static Error getValidation(Define define, String path, String string, Object value, ErrorCode code) {
        Error v = new Error();
        v.code = code;
        v.description = define != null ? define.description() : "<>";
        v.path = path;
        if (v.path.startsWith(".")) {
            v.path = v.path.substring(1);
        }
        v.failure = string;
        v.value = value;
        return v;
    }

    private static void validateIterable(Define define, Iterable<?> it, List<Error> result, String path) {
        int n = 0;
        for (Object o : it) {
            struct.validate(define, result, o, String.valueOf(path) + "[" + n + "]");
            ++n;
        }
    }

    private static void validateMap(Define define, Map<?, ?> map, List<Error> result, String path) {
        for (Map.Entry<?, ?> e : map.entrySet()) {
            struct.validate(define, result, e.getValue(), String.valueOf(path) + "." + e.getKey());
        }
    }

    private static void validateArray(Define define, Object array, List<Error> result, String path) {
        int l = Array.getLength(array);
        int i = 0;
        while (i < l) {
            struct.validate(define, result, Array.get(array, i), String.valueOf(path) + "[" + i + "]");
            ++i;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void check(String why, String ... fields) throws Exception {
        List<Error> s = this.validate();
        if (!s.isEmpty()) {
            throw new InvalidException(why, s);
        }
    }

    public static void validate(Pattern pattern, String input) throws Exception {
        if (pattern.matcher(input).matches()) {
            return;
        }
        throw new IllegalArgumentException(String.valueOf(input) + " does not match pattern: " + pattern.pattern());
    }

    static class Cache {
        Map<String, Field> fields = new HashMap<String, Field>();
        Field[] fs;
        String[] names;
        Set<String> keys = Collections.unmodifiableSet(this.fields.keySet());
        int size;
        Field[] ids = EMPTY;

        Cache() {
        }
    }

    public static class Error
    extends struct {
        public ErrorCode code = ErrorCode.OTHER;
        public String path;
        public String description;
        public String failure;
        public Object value;
    }

    public static enum ErrorCode {
        MISMATCH,
        TOO_LARGE,
        TOO_SMALL,
        SCRIPT,
        REQUIRED,
        NO_FIELDS,
        OTHER;

    }
}

