/*
 * Decompiled with CFR 0.152.
 */
package aQute.service.library;

import aQute.service.library.Library;
import aQute.struct.struct;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Revisions
extends struct {
    public byte[] _id;
    public List<byte[]> content = Revisions.list();

    public static byte[] checksum(Revisions rs) throws NoSuchAlgorithmException {
        Collections.sort(rs.content, new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                int i = 0;
                while (i < o1.length) {
                    if (i >= o2.length) {
                        return 1;
                    }
                    byte a = o1[i];
                    byte b = o2[i];
                    if (a > b) {
                        return 1;
                    }
                    if (a < b) {
                        return -1;
                    }
                    ++i;
                }
                if (o1.length != o2.length) {
                    return -1;
                }
                return 0;
            }
        });
        if (rs.content.size() == 1) {
            return rs.content.get(0);
        }
        MessageDigest digester = MessageDigest.getInstance("SHA1");
        byte[] last = null;
        Iterator<byte[]> i = rs.content.iterator();
        while (i.hasNext()) {
            byte[] ba = i.next();
            if (ba != last) {
                digester.update(ba);
                last = ba;
                continue;
            }
            i.remove();
        }
        return digester.digest();
    }

    public static Revisions singleton(Library.Revision r) throws NoSuchAlgorithmException {
        Revisions revisions = new Revisions();
        revisions.content.add(r._id);
        revisions._id = r._id;
        return revisions;
    }

    public static Revisions from(Collection<? extends Library.Revision> responses) throws NoSuchAlgorithmException {
        Revisions revs = new Revisions();
        for (Library.Revision revision : responses) {
            revs.content.add(revision._id);
        }
        revs._id = Revisions.checksum(revs);
        return revs;
    }
}

