/*
 * Decompiled with CFR 0.152.
 */
package aQute.service.library;

import aQute.service.library.Callback;
import aQute.service.library.Coordinate;
import aQute.service.library.Revisions;
import aQute.service.library.SharedTypes;
import aQute.struct.Define;
import aQute.struct.struct;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public interface Library {
    public static final String LOWEST_VERSION = "<";
    public static final String HIGHEST_VERSION = ">";
    public static final String EQUAL_VERSION = "=";
    public static final String BASELINE_VERSION = "~";
    public static final String SIMPLE_NAME = "[-\\p{L}0-9_.]+";
    public static final Pattern SIMPLE_NAME_PATTERN = Pattern.compile("[-\\p{L}0-9_.]+");
    public static final Pattern COORDINATES_P = Pattern.compile("\\s*([a-z0-9-_.]+)(?:\\s*:\\s*([a-z0-9-_.]+)(?:\\s*:\\s*([a-z0-9-_.]*))?)?(?:\\s*@\\s*([<>=]?[a-z0-9-_.,\\[\\]\\(\\)]+))?\\s*", 2);
    public static final Pattern SHA_P = Pattern.compile("\\s*([a-f0-9]{40,40})\\s*", 2);
    public static final Pattern MASTER_QUALIFIER = Pattern.compile("|RELEASE|FINAL|GA|GM|GOLD", 2);
    public static final String VERSION = "1.0.0";
    public static final String OSGI_GROUP = "osgi";
    public static final String SHA_GROUP = "sha";
    public static final String SIMPLE_GROUP = "";
    public static final String WILDCARD_VERSION = "@*";

    public void update(Program var1) throws Exception;

    public void redo(String var1, String var2) throws Exception;

    public boolean master(String var1) throws Exception;

    public Revision delete(String var1);

    public Find<Program> findProgram() throws Exception;

    public Find<Revision> findRevision() throws Exception;

    public Info getInfo() throws Exception;

    public Revision scan(URI var1) throws Exception;

    public Revision stage(Revision var1) throws Exception;

    public Revision stage(URI var1) throws Exception;

    public Revision rescan(Coordinate var1) throws Exception;

    public Revision getRevision(byte[] var1) throws Exception;

    public Revision getRevision(String var1, String var2, String var3, String var4) throws Exception;

    public Revision getRevision(Coordinate var1) throws Exception;

    public List<? extends Revision> getRevisions(Coordinate var1) throws Exception;

    public Category getCategory(String var1) throws Exception;

    public Iterable<? extends Category> getCategories(String var1) throws Exception;

    public void update(Category var1) throws Exception;

    public Program getProgram(String var1, String var2) throws Exception;

    public Iterable<? extends Program> getPrograms(String var1) throws Exception;

    public void queueScan(ScanRequest var1) throws Exception;

    public Revision scan(ScanRequest var1) throws Exception;

    public boolean update(Program var1, String ... var2) throws Exception;

    public boolean update(Revision var1, String ... var2) throws Exception;

    public Revision stage(Revision var1, String var2) throws Exception;

    public Iterable<RevisionRef> getClosure(byte[] var1, boolean var2) throws Exception;

    public Revisions createRevisions(Revisions var1) throws Exception;

    public Revisions getRevisions(byte[] var1) throws Exception;

    public void setPhase(byte[] var1, Phase var2) throws Exception;

    public static class Capability
    extends Namespace {
    }

    public static class Category
    extends struct {
        public String _id;
        public String name;
        public String summary;
        public Wiki wiki;
        public URI icon;
    }

    public static interface DownloadListener {
        public void success(File var1) throws Exception;

        public void failed(File var1, String var2) throws Exception;

        public boolean progress(int var1) throws Exception;
    }

    public static interface Find<T>
    extends Iterable<T> {
        public Find<T> bsn(String var1) throws Exception;

        public Find<T> baseline(String var1) throws Exception;

        public Find<T> version(String var1) throws Exception;

        public Find<T> qualifier(String var1) throws Exception;

        public Find<T> from(long var1) throws Exception;

        public Find<T> until(long var1) throws Exception;

        public Find<T> skip(int var1) throws Exception;

        public Find<T> limit(int var1) throws Exception;

        public Find<T> ascending(String var1) throws Exception;

        public Find<T> descending(String var1) throws Exception;

        public Find<T> where(String var1, Object ... var2) throws Exception;

        public Find<T> template(Revision var1) throws Exception;

        public T one() throws Exception;

        public T first() throws Exception;

        public int count() throws Exception;

        public Find<T> query(String var1) throws Exception;

        public Find<T> capability(String var1, String var2, Object var3) throws Exception;

        public boolean callback(Callback<T> var1) throws Exception;
    }

    public static enum Group {
        SIMPLE,
        OSGI,
        SHA,
        MAVEN;

    }

    public static class Info
    extends struct {
        public String version = "1.0.0";
        @Define(description="Name of the library", pattern="[\\w_][-\\w\\d_.]*")
        public String name;
        public URI location;
        public String generation;
        public long masterUpdates;
        public long updates;
        public String message;
        public boolean approved;
        public long programs;
        public long revisions;
        public int fixup;
    }

    public static class Namespace
    extends struct {
        public String ns;
        public Map<String, Object> ps = new HashMap<String, Object>();
        public String name;
    }

    public static enum Phase {
        PENDING(false, false, false, "?"),
        STAGING(false, false, false, "\u25d1"),
        LOCKED(true, false, false, "\u2298"),
        MASTER(true, true, true, "\u2b24"),
        RETIRED(true, false, true, "\u25d0"),
        WITHDRAWN(true, false, true, "\u2297"),
        UNKNOWN(true, false, false, "?");

        final boolean locked;
        final boolean listable;
        final boolean permanent;
        final String symbol;
        final char identifier;

        private Phase(boolean locked, boolean listable, boolean permanent, String symbol) {
            this.locked = locked;
            this.listable = listable;
            this.permanent = permanent;
            this.identifier = Character.toUpperCase(this.toString().charAt(0));
            this.symbol = symbol;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public boolean isListable() {
            return this.listable;
        }

        public boolean isPermanent() {
            return this.permanent;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public char getIdentifier() {
            return this.identifier;
        }

        public boolean isStaging() {
            return this == STAGING || this == LOCKED;
        }
    }

    public static class Program
    extends struct {
        public byte[] _id;
        public String artifactId;
        public String groupId;
        public URI icon;
        public Wiki wiki;
        public int[] rating = new int[5];
        public long modified;
        public List<RevisionRef> revisions = new ArrayList<RevisionRef>();
        public Revision last;
        public Set<String> category = Program.set();
        public Set<String> keywords = Program.set();
        public Set<String> classifiers = Program.set();
        public Set<String> search = Program.set();
        public URI home;
        public int depth;
        public int vote;
        public float weight;
        public Set<String> inbound;
        public Set<String> classpath;
        public List<String> cycles;
        public Set<String> overlap;
        public int rank;
        public String depository;
        public String domain;
        public int fixup;
    }

    public static class Relocation
    extends struct {
        public String groupId;
        public String artifactId;
        public String version;
        public String message;
    }

    public static class Requirement
    extends Namespace {
    }

    public static class Response
    extends struct {
        public Revision revision;
        public List<String> errors = new ArrayList<String>();
        public List<String> warnings = new ArrayList<String>();
    }

    public static class Revision
    extends SharedTypes.RepoPom {
        public byte[] _id;
        public Set<URI> urls = Revision.set();
        public byte[] md5;
        public URI pomUrl;
        public byte[] pom;
        public String title;
        public String bsn;
        public String baseline;
        public String qualifier;
        public Phase phase = Phase.STAGING;
        public long size;
        public String receipt;
        public long created;
        public long modified;
        public String message;
        public String owner;
        public String releaseSummary;
        public List<String> signers;
        public Set<String> category = Revision.set();
        public Map<String, Object> metadata = new HashMap<String, Object>();
        public URI icon;
        public List<String> process = Revision.list();
        public List<Requirement> requirements = Revision.list();
        public List<Capability> capabilities = Revision.list();
        public Set<String> hashes = Revision.set();
        public List<String> errors = Revision.list();
        public List<String> warnings = Revision.list();
        public List<String> packages = Revision.list();
        public List<URI> repositories = Revision.list();
        public String mainClass;
        public String docUrl;
        public Set<String> keywords = Revision.set();
        public Relocation relocation;
        public Set<String> depos = Revision.set();
        public int fixup;
        public String readme;
        public long expire;
        @Deprecated
        public URI url;
        @Deprecated
        public Set<URI> alts = Revision.set();
    }

    public static class RevisionRef
    extends struct {
        public byte[] revision;
        public Set<URI> urls = RevisionRef.set();
        public byte[] md5;
        public String groupId;
        public String artifactId;
        public String version;
        public String classifier;
        public String packaging;
        public String bsn;
        public String title;
        public String name;
        public String description;
        public String baseline;
        public String qualifier;
        public String tag;
        public Phase phase;
        public String releaseSummary;
        public long created;
        public int errors;
        public long size;
        @Deprecated
        public URI url;

        public RevisionRef() {
        }

        public RevisionRef(Revision revision) {
            this.revision = revision._id;
            this.bsn = revision.bsn;
            this.urls.addAll(revision.urls);
            this.md5 = revision.md5;
            this.phase = revision.phase;
            this.version = revision.version;
            this.classifier = revision.classifier;
            this.baseline = revision.baseline;
            this.qualifier = revision.qualifier;
            this.releaseSummary = revision.releaseSummary;
            if (revision.scm != null) {
                this.tag = revision.scm.tag;
            }
            this.name = revision.name;
            this.title = revision.title;
            this.description = revision.description;
            this.created = revision.created;
            this.errors = revision.errors.size();
            this.groupId = revision.groupId;
            this.artifactId = revision.artifactId;
            this.size = revision.size;
        }
    }

    public static class ScanRequest
    extends struct {
        public URI url;
        public boolean unique = false;
        public byte[] sha = null;
        public URI repository;
        public String message;
        public byte[] user;
        public boolean osgi;
        public Phase phase;
        public boolean nostage;
        public long expire = Long.MAX_VALUE;
    }

    public static enum Strategy {
        HIGHEST,
        LOWEST,
        BASELINE,
        EQUAL;

    }

    public static class Wiki
    extends struct {
        public String text;
        public String author;
        public long modified;
    }
}

