/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.provider;

import aQute.bnd.version.MavenVersion;
import aQute.lib.io.IO;
import aQute.maven.api.Archive;
import aQute.maven.api.Revision;
import aQute.maven.provider.MavenBackingRepository;
import aQute.maven.provider.MavenRepository;
import aQute.maven.provider.MetadataParser;
import aQute.maven.provider.Releaser;
import java.io.File;
import java.util.Properties;

public class SnapshotReleaser
extends Releaser {
    private MavenVersion snapshotVersion;
    private long timestamp = System.currentTimeMillis();
    private String build = "1";
    private String dateStamp;

    public SnapshotReleaser(MavenRepository home, Revision revision, MavenBackingRepository snapshot, Properties context) throws Exception {
        super(home, revision, snapshot, context);
        this.force();
        assert (revision.isSnapshot());
        this.setBuild(this.timestamp, this.build);
    }

    @Override
    protected void check() {
    }

    @Override
    public void setBuild(long timestamp, String build) {
        this.timestamp = timestamp == 0L ? System.currentTimeMillis() : timestamp;
        this.build = build == null ? "1" : build;
        this.snapshotVersion = this.revision.version.toSnapshot(timestamp, build);
        this.dateStamp = MavenVersion.toDateStamp((long)timestamp);
    }

    @Override
    public void updateMetadata() throws Exception {
        MetadataParser.RevisionMetadata revisionMetadata = this.localOnly ? new MetadataParser.RevisionMetadata() : this.repo.getMetadata(this.revision);
        revisionMetadata.group = this.revision.group;
        revisionMetadata.artifact = this.revision.artifact;
        revisionMetadata.version = this.revision.version;
        revisionMetadata.lastUpdated = this.programMetadata.lastUpdated;
        revisionMetadata.snapshot.buildNumber = this.build;
        revisionMetadata.snapshot.timestamp = this.dateStamp;
        for (Archive archive : this.upload) {
            MetadataParser.SnapshotVersion snapshotVersion = new MetadataParser.SnapshotVersion();
            snapshotVersion.extension = archive.extension;
            snapshotVersion.classifier = archive.classifier.isEmpty() ? null : archive.classifier;
            snapshotVersion.updated = this.programMetadata.lastUpdated;
            snapshotVersion.value = this.snapshotVersion;
            revisionMetadata.snapshotVersions.add(snapshotVersion);
        }
        File metafile = this.home.toLocalFile(this.revision.metadata(this.repo.id));
        metafile.getParentFile().mkdirs();
        IO.store((Object)revisionMetadata.toString(), metafile);
        this.repo.store(metafile, this.revision.metadata());
        super.updateMetadata();
    }

    @Override
    protected Archive resolve(Archive archive) throws Exception {
        Archive resolved = archive.resolveSnapshot(this.snapshotVersion);
        return resolved;
    }

    @Override
    protected boolean isUpdateProgramMetadata() {
        return true;
    }

    @Override
    public void sign(Archive archive, File f) throws Exception {
    }
}

