/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.provider;

import aQute.bnd.version.MavenVersion;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.maven.api.Archive;
import aQute.maven.api.IPom;
import aQute.maven.api.MavenScope;
import aQute.maven.api.Program;
import aQute.maven.api.Revision;
import aQute.maven.provider.MavenRepository;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class POM
implements IPom {
    static Logger l = LoggerFactory.getLogger(POM.class);
    static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    static XPathFactory xpf = XPathFactory.newInstance();
    private Revision revision;
    private String packaging;
    private final Properties properties;
    private final POM parent;
    private Map<Program, IPom.Dependency> dependencies = new LinkedHashMap<Program, IPom.Dependency>();
    private Map<Program, IPom.Dependency> dependencyManagement = new LinkedHashMap<Program, IPom.Dependency>();
    private XPath xp;
    private MavenRepository repo;
    static final Pattern ENTITY_CLEAN_UP = Pattern.compile("&([-a-z0-9_]+);");
    static final Pattern MACRO_P = Pattern.compile("\\$\\{(?<env>env\\.)?(?<key>[.a-z0-9$_-]+)\\}", 2);

    public static POM parse(MavenRepository repo, File file) throws Exception {
        try {
            return new POM(repo, file);
        }
        catch (Exception e) {
            l.error("Failed to parse POM file {}", (Object)file);
            throw e;
        }
    }

    public POM() {
        this.properties = System.getProperties();
        this.parent = null;
    }

    public POM(MavenRepository repo, InputStream in) throws Exception {
        this(repo, POM.getDocBuilder().parse(POM.processEntities(in)));
    }

    private static DocumentBuilder getDocBuilder() throws ParserConfigurationException {
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db;
    }

    private static InputStream processEntities(InputStream in) throws IOException {
        byte[] read = IO.read(in);
        int l = read.length;
        block10: for (int i = 0; i < read.length; ++i) {
            if (read[i] != 38) continue;
            StringBuilder sb = new StringBuilder();
            for (int j = i + 1; j < read.length && read[j] != 59; ++j) {
                char c;
                if (j > i + 10 || ((c = (char)read[j]) < 'A' || c > 'Z') && (c < 'a' || c > 'z')) continue block10;
                sb.append(c);
            }
            switch (sb.toString()) {
                case "lt": 
                case "gt": 
                case "amp": 
                case "quote": 
                case "apos": {
                    continue block10;
                }
                default: {
                    read[i] = 63;
                }
            }
        }
        return new ByteArrayInputStream(read);
    }

    public POM(MavenRepository repo, File file) throws Exception {
        this(repo, new FileInputStream(file));
    }

    public POM(MavenRepository repo, Document doc) throws Exception {
        this.repo = repo;
        this.xp = xpf.newXPath();
        String parentGroup = Strings.trim(this.xp.evaluate("project/parent/groupId", doc));
        String parentArtifact = Strings.trim(this.xp.evaluate("project/parent/artifactId", doc));
        String parentVersion = Strings.trim(this.xp.evaluate("project/parent/version", doc));
        String relativePath = Strings.trim(this.xp.evaluate("project/parent/relativePath", doc));
        if (!(parentGroup.isEmpty() || parentArtifact.isEmpty() || parentVersion.isEmpty())) {
            File fp;
            Program program = Program.valueOf(parentGroup, parentArtifact);
            if (program == null) {
                throw new IllegalArgumentException("Invalid parent program " + parentGroup + ":" + parentArtifact);
            }
            MavenVersion v = MavenVersion.parseMavenString((String)parentVersion);
            if (v == null) {
                throw new IllegalArgumentException("Invalid version for parent pom " + program + ":" + v);
            }
            if (relativePath != null && !relativePath.isEmpty() && (fp = IO.getFile(relativePath)).isFile()) {
                this.parent = new POM(repo, fp);
            } else {
                Revision revision = program.version(v);
                POM pom = repo.getPom(revision);
                if (pom == null) {
                    throw new IllegalArgumentException("Parent not found" + revision.pomArchive());
                }
                this.parent = pom;
            }
        } else {
            this.parent = new POM();
        }
        this.properties = new Properties(this.parent.properties);
        Element project = doc.getDocumentElement();
        this.index(project, "project.", "modelVersion", "groupId", "artifactId", "version", "packaging");
        NodeList props = (NodeList)this.xp.evaluate("properties", project, XPathConstants.NODESET);
        for (int i = 0; i < props.getLength(); ++i) {
            this.index((Element)props.item(i), "", new String[0]);
        }
        String group = this.get("project.groupId", null);
        String artifact = this.getNoInheritance("project.artifactId", null);
        String version = this.get("project.version", null);
        this.packaging = this.getNoInheritance("project.packaging", "jar");
        Program program = Program.valueOf(group, artifact);
        if (program == null) {
            throw new IllegalArgumentException("Invalid program for pom " + group + ":" + artifact);
        }
        MavenVersion v = MavenVersion.parseMavenString((String)version);
        if (v == null) {
            throw new IllegalArgumentException("Invalid version for pom " + group + ":" + artifact + ":" + version);
        }
        this.revision = program.version(v);
        this.properties.put("pom.groupId", group);
        this.properties.put("pom.artifactId", artifact);
        this.properties.put("pom.version", version);
        if (this.parent.revision != null) {
            this.properties.put("parent.version", this.parent.getVersion().toString());
        } else {
            this.properties.put("parent.version", "parent version from " + this.revision + " but not parent?");
        }
        this.properties.put("version", version);
        this.properties.put("pom.currentVersion", version);
        this.properties.put("pom.packaging", this.packaging);
        NodeList dependencies = (NodeList)this.xp.evaluate("project/dependencies/dependency", doc, XPathConstants.NODESET);
        for (int i = 0; i < dependencies.getLength(); ++i) {
            Element dependency = (Element)dependencies.item(i);
            IPom.Dependency d = this.dependency(dependency);
            this.dependencies.put(d.program, d);
        }
        NodeList dependencyManagement = (NodeList)this.xp.evaluate("project/dependencyManagement/dependencies/dependency", doc, XPathConstants.NODESET);
        for (int i = 0; i < dependencyManagement.getLength(); ++i) {
            Element dependency = (Element)dependencyManagement.item(i);
            IPom.Dependency d = this.dependency(dependency);
            this.dependencyManagement.put(d.program, d);
        }
        this.xp = null;
    }

    private MavenVersion getVersion() {
        return this.revision.version;
    }

    private IPom.Dependency dependency(Element dependency) throws Exception {
        String groupId = this.get(dependency, "groupId", "<no group>");
        String artifactId = this.get(dependency, "artifactId", "<no artifact>");
        IPom.Dependency d = new IPom.Dependency();
        d.optional = this.isTrue(this.get(dependency, "optional", "true"));
        String version = this.get(dependency, "version", null);
        String extension = this.get(dependency, "type", "jar");
        String classifier = this.get(dependency, "classifier", null);
        String scope = this.get(dependency, "scope", "compile");
        Program program = Program.valueOf(groupId, artifactId);
        if (program == null) {
            throw new IllegalArgumentException("Invalid dependency in " + this.revision + " to " + groupId + ":" + artifactId);
        }
        d.program = program;
        d.version = version;
        d.scope = MavenScope.getScope(scope);
        return d;
    }

    private IPom.Dependency getDirectDependency(Program program) {
        IPom.Dependency dependency = this.dependencies.get(program);
        if (dependency != null) {
            return dependency;
        }
        dependency = this.dependencyManagement.get(program);
        if (dependency != null) {
            return dependency;
        }
        if (this.parent != null) {
            return this.parent.getDirectDependency(program);
        }
        return null;
    }

    private boolean isTrue(String other) {
        return "true".equalsIgnoreCase(other);
    }

    private String get(Element dependency, String name, String deflt) throws XPathExpressionException {
        String value = this.xp.evaluate(name, dependency);
        if (value == null || value.isEmpty()) {
            return Strings.trim(deflt);
        }
        return Strings.trim(this.replaceMacros(value));
    }

    private String get(String key, String deflt) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            value = deflt;
        }
        return this.replaceMacros(value);
    }

    private String getNoInheritance(String key, String deflt) {
        String value = (String)this.properties.get(key);
        if (value == null) {
            value = deflt;
        }
        return this.replaceMacros(value);
    }

    private String replaceMacros(String value) {
        Matcher m = MACRO_P.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String key = m.group("key");
            if (m.group("env") != null) {
                m.appendReplacement(sb, this.replaceMacros(System.getenv(key)));
                continue;
            }
            String property = this.properties.getProperty(key);
            if (property != null && property.indexOf(36) >= 0) {
                property = this.replaceMacros(property);
            }
            if (property == null) {
                System.out.println("?? prop: " + key);
                m.appendReplacement(sb, Matcher.quoteReplacement("${" + key + "}"));
                continue;
            }
            m.appendReplacement(sb, Matcher.quoteReplacement(property));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private void index(Element node, String prefix, String ... names) throws XPathExpressionException {
        String expr = "./*";
        if (names.length > 0) {
            StringBuilder sb = new StringBuilder("./*[");
            String del = "name()=";
            for (String name : names) {
                sb.append(del).append('\"').append(name).append('\"');
                del = " or name()=";
            }
            sb.append("]");
            expr = sb.toString();
        }
        NodeList childNodes = (NodeList)this.xp.evaluate(expr, node, XPathConstants.NODESET);
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            String key = child.getNodeName();
            String value = child.getTextContent().trim();
            this.properties.put(prefix + key, value);
        }
    }

    @Override
    public Revision getRevision() {
        return this.revision;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public Archive binaryArchive() {
        return this.revision.archive(this.packaging == null || this.packaging.isEmpty() || this.packaging.equals("bundle") || this.packaging.equals("pom") || this.packaging.equals("eclipse-plugin") ? "jar" : this.packaging, null);
    }

    @Override
    public Map<Program, IPom.Dependency> getDependencies(MavenScope scope, boolean transitive) throws Exception {
        return this.getDependencies(EnumSet.of(scope), transitive);
    }

    public Map<Program, IPom.Dependency> getDependencies(EnumSet<MavenScope> scope, boolean transitive) throws Exception {
        LinkedHashMap<Program, IPom.Dependency> deps = new LinkedHashMap<Program, IPom.Dependency>();
        HashSet<Program> visited = new HashSet<Program>();
        this.getDependencies(deps, scope, transitive, visited);
        return deps;
    }

    private void resolve(IPom.Dependency d) {
        if (d.version == null) {
            IPom.Dependency dependency = this.dependencyManagement.get(d.program);
            if (dependency != null && dependency.version != null) {
                d.version = dependency.version;
                return;
            }
            IPom.Dependency directDependency = this.parent.getDirectDependency(d.program);
            if (directDependency == null) {
                d.error = "Cannot resolve ...";
            } else {
                d.version = directDependency.version;
            }
        }
    }

    private void getDependencies(Map<Program, IPom.Dependency> deps, EnumSet<MavenScope> scope, boolean transitive, Set<Program> visited) throws Exception {
        if (this.revision == null) {
            return;
        }
        if (!visited.add(this.revision.program)) {
            return;
        }
        if (this.parent != null) {
            this.parent.getDependencies(deps, scope, transitive, visited);
        }
        ArrayList<IPom.Dependency> breadthFirst = new ArrayList<IPom.Dependency>();
        for (Map.Entry<Program, IPom.Dependency> e : this.dependencies.entrySet()) {
            IPom.Dependency d = e.getValue();
            this.resolve(d);
            if (deps.containsKey(d.program) || !scope.contains((Object)d.scope)) continue;
            deps.put(e.getKey(), d);
            if (!transitive || !d.scope.isTransitive()) continue;
            breadthFirst.add(d);
        }
        for (IPom.Dependency d : breadthFirst) {
            try {
                POM pom = this.repo.getPom(d.getRevision());
                if (pom == null) continue;
                pom.getDependencies(deps, scope, transitive, visited);
            }
            catch (Exception ee) {
                d.error = ee.toString();
            }
        }
    }

    @Override
    public IPom getParent() {
        return this.parent;
    }

    public String toString() {
        return "POM[" + this.revision + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        POM other = (POM)obj;
        return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
    }

    public boolean isPomOnly() {
        return "pom".equals(this.packaging);
    }
}

