/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.api;

import aQute.bnd.version.MavenVersion;
import aQute.lib.strings.Strings;
import aQute.maven.api.Revision;
import java.util.Map;
import java.util.WeakHashMap;

public class Program
implements Comparable<Program> {
    public final String group;
    public final String artifact;
    public final String path;
    private static final Map<String, Program> programCache = new WeakHashMap<String, Program>();
    private Map<MavenVersion, Revision> revisionCache = new WeakHashMap<MavenVersion, Revision>();

    Program(String group, String artifact) {
        this.group = group;
        this.artifact = artifact;
        this.path = group.replace('.', '/') + "/" + artifact;
    }

    public synchronized Revision version(String version) {
        MavenVersion v = new MavenVersion(version);
        return this.version(v);
    }

    public synchronized Revision version(MavenVersion version) {
        Revision r = this.revisionCache.get(version);
        if (r == null) {
            r = new Revision(this, version);
            this.revisionCache.put(version, r);
        }
        return r;
    }

    static String validate(String gav) {
        String[] parts = gav.split(":");
        return Program.validate(parts);
    }

    static String validate(String[] parts) {
        if (parts.length != 1) {
            return "A GAV must consists of at least of <g>:<a>:<v>";
        }
        if (!Program.isValidName(parts[0])) {
            return "Invalid group " + parts[0];
        }
        if (!Program.isValidName(parts[1])) {
            return "Invalid artifact " + parts[1];
        }
        return null;
    }

    public static boolean isValidName(String string) {
        return string != null && !string.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.group.hashCode();
        result = 31 * result + this.artifact.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Program other = (Program)obj;
        if (!this.artifact.equals(other.artifact)) {
            return false;
        }
        return this.group.equals(other.group);
    }

    public String toString() {
        return this.group + ":" + this.artifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Program valueOf(String group, String artifact) {
        Map<String, Program> map = programCache;
        synchronized (map) {
            String key = group + ":" + artifact;
            Program p = programCache.get(key);
            if (p == null) {
                p = new Program(group, artifact);
                programCache.put(key, p);
            }
            return p;
        }
    }

    public String metadata() {
        return this.path + "/maven-metadata.xml";
    }

    public String metadata(String id) {
        return this.path + "/maven-metadata-" + id + ".xml";
    }

    public static Program valueOf(String bsn) {
        String[] parts = Strings.trim(bsn).split(":");
        if (parts.length != 2) {
            return null;
        }
        return Program.valueOf(parts[0], parts[1]);
    }

    @Override
    public int compareTo(Program o) {
        int n = this.group.compareTo(o.group);
        if (n != 0) {
            return n;
        }
        return this.artifact.compareTo(o.artifact);
    }
}

