/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.api;

import aQute.bnd.version.MavenVersion;
import aQute.maven.api.Program;
import aQute.maven.api.Revision;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Archive
implements Comparable<Archive> {
    public static final Pattern ARCHIVE_P = Pattern.compile("\\s*(?<program>[^:]+:[^:]+)         # program\n(:(?<extension>[^:]+)         # optional extension\n    (:(?<classifier>[^:]+))?  # optional classifer (must be preceded by extension)\n)?                            # end of extension\n:(?<version>[^:]+)           # version is last\n\\s*", 4);
    public final Revision revision;
    public final String classifier;
    public final String extension;
    public final String localPath;
    public final String remotePath;
    public final MavenVersion snapshot;
    static final Pattern FILEPATH_P = Pattern.compile("(?<group>([^/]+)(/[^/]+)+)/(?<artifact>[^/]+)/(?<version>[^/]+)/(?<name>[^/]+)");

    public Archive(String s) {
        Archive v = Archive.valueOf(s);
        this.revision = v.revision;
        this.extension = v.extension;
        this.classifier = v.classifier;
        this.snapshot = v.snapshot;
        this.localPath = v.localPath;
        this.remotePath = v.remotePath;
    }

    Archive(Revision revision, MavenVersion snapshot, String extension, String classifier) {
        this.revision = revision;
        this.extension = extension == null || extension.isEmpty() ? "jar" : extension;
        this.classifier = classifier == null || classifier.isEmpty() ? "" : classifier;
        this.snapshot = snapshot;
        this.localPath = revision.path + "/" + this.getName();
        this.remotePath = revision.path + "/" + this.getName(snapshot);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.classifier.hashCode();
        result = 31 * result + this.extension.hashCode();
        result = 31 * result + this.revision.hashCode();
        result = 31 * result + (this.snapshot == null ? 0 : this.snapshot.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Archive other = (Archive)obj;
        if (!this.classifier.equals(other.classifier)) {
            return false;
        }
        if (!this.extension.equals(other.extension)) {
            return false;
        }
        if (!this.revision.equals(other.revision)) {
            return false;
        }
        return !(this.snapshot == null ? other.snapshot != null : !this.snapshot.equals((Object)other.snapshot));
    }

    public Revision getRevision() {
        return this.revision;
    }

    public String getName() {
        return this.getName(this.revision.version);
    }

    public boolean isSnapshot() {
        return this.revision.isSnapshot();
    }

    public String getName(MavenVersion version) {
        return this.revision.program.artifact + "-" + (version == null ? this.revision.version : version) + (this.classifier.isEmpty() ? "" : "-" + this.classifier) + "." + this.extension;
    }

    public String toString() {
        StringBuilder sb = this.prefix();
        sb.append(":").append(this.revision.version);
        return sb.toString();
    }

    public String getWithoutVersion() {
        return this.prefix().toString();
    }

    private StringBuilder prefix() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.revision.program.group);
        sb.append(":");
        sb.append(this.revision.program.artifact);
        if (!this.extension.isEmpty() && !this.extension.equals("jar")) {
            sb.append(":").append(this.extension);
            if (!this.classifier.isEmpty()) {
                sb.append(":").append(this.classifier);
            }
        } else if (!this.classifier.isEmpty()) {
            sb.append(":jar:").append(this.classifier);
        }
        return sb;
    }

    public boolean isResolved() {
        return !this.isSnapshot() || this.snapshot != null;
    }

    public Archive resolveSnapshot(MavenVersion version) {
        if (version.equals((Object)this.snapshot)) {
            return this;
        }
        return new Archive(this.revision, version, this.extension, this.classifier);
    }

    public boolean isPom() {
        return "pom".equals(this.extension);
    }

    public Archive getPomArchive() {
        return this.revision.getPomArchive();
    }

    public static boolean isValid(String archive) {
        return ARCHIVE_P.matcher(archive).matches();
    }

    public static Archive valueOf(String archive) {
        Matcher m = ARCHIVE_P.matcher(archive);
        if (!m.matches()) {
            return null;
        }
        Program p = Program.valueOf(m.group("program"));
        return p.version(m.group("version")).archive(m.group("extension"), m.group("classifier"));
    }

    @Override
    public int compareTo(Archive o) {
        int n = this.revision.compareTo(o.revision);
        if (n != 0) {
            return n;
        }
        n = this.extension.compareTo(o.extension);
        if (n != 0) {
            return n;
        }
        return this.classifier.compareTo(o.classifier);
    }

    public static Archive fromFilepath(String filePath) {
        String prefix;
        Matcher matcher = FILEPATH_P.matcher(filePath);
        if (!matcher.matches()) {
            return null;
        }
        String group = matcher.group("group").replace('/', '.');
        String artifact = matcher.group("artifact");
        Program program = Program.valueOf(group, artifact);
        String version = matcher.group("version");
        Revision revision = program.version(version);
        String name = matcher.group("name");
        if (!name.startsWith(prefix = artifact + "-" + version)) {
            return null;
        }
        int n = name.lastIndexOf(".");
        if (n < prefix.length()) {
            return null;
        }
        String extension = name.substring(n + 1);
        String classifier = null;
        if (prefix.length() < n) {
            classifier = name.substring(prefix.length() + 1, n);
        }
        return revision.archive(extension, classifier);
    }

    public static Archive valueOf(String group, String artifact, String version, String extension, String classifier) {
        return Program.valueOf(group, artifact).version(version).archive(extension, classifier);
    }

    public boolean hasClassifier() {
        return this.classifier != null && !this.classifier.isEmpty();
    }

    public boolean hasExtension() {
        return this.extension != null && !this.extension.isEmpty() && !this.extension.equals("jar");
    }
}

