/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repository.maven.provider;

import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.version.Version;
import aQute.lib.fileset.FileSet;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.tag.Tag;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.libg.command.Command;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;

public class Tool
extends Processor {
    private static final String OSGI_OPT_SRC = "OSGI-OPT/src/";
    private final File tmp = Files.createTempDirectory("tool", new FileAttribute[0]).toFile();
    private final File sources = new File(this.tmp, "sources");
    private final File javadoc = new File(this.tmp, "javadoc");
    private final File javadocOptions = new File(this.tmp, "javadoc.options");
    private final Domain manifest;

    public Tool(Processor parent, Jar jar) throws Exception {
        super(parent);
        this.manifest = Domain.domain((Manifest)jar.getManifest());
        for (Map.Entry e : jar.getResources().entrySet()) {
            if (!((String)e.getKey()).startsWith(OSGI_OPT_SRC)) continue;
            String path = ((String)e.getKey()).substring(OSGI_OPT_SRC.length());
            File out = IO.getFile(this.sources, path);
            out.getParentFile().mkdirs();
            IO.copy(((Resource)e.getValue()).openInputStream(), out);
        }
    }

    public boolean hasSources() {
        return this.sources.isDirectory();
    }

    public Jar doJavadoc(Map<String, String> options, boolean exportsOnly) throws Exception {
        String bundleDescription;
        String version;
        if (!this.hasSources()) {
            return new Jar("javadoc");
        }
        this.javadoc.mkdirs();
        ArrayList<String> args = new ArrayList<String>();
        args.add("-quiet");
        args.add("-protected");
        args.add(String.format("%s '%s'", "-d", this.fileName(this.javadoc)));
        args.add("-charset 'UTF-8'");
        args.add(String.format("%s '%s'", "-sourcepath", this.fileName(this.sources)));
        UTF8Properties pp = new UTF8Properties();
        pp.putAll(options);
        String name = this.manifest.getBundleName();
        if (name == null) {
            name = (String)this.manifest.getBundleSymbolicName().getKey();
        }
        if ((version = this.manifest.getBundleVersion()) == null) {
            version = Version.LOWEST.toString();
        }
        if ((bundleDescription = this.manifest.getBundleDescription()) != null && !Strings.trim(bundleDescription).isEmpty()) {
            this.printOverview(name, version, bundleDescription);
        }
        this.set(pp, "-doctitle", name);
        this.set(pp, "-windowtitle", name);
        this.set(pp, "-header", this.manifest.getBundleVendor());
        this.set(pp, "-bottom", this.manifest.getBundleCopyright());
        this.set(pp, "-footer", this.manifest.getBundleDocURL());
        args.add("-tag 'Immutable:t:\"Immutable\"'");
        args.add("-tag 'ThreadSafe:t:\"ThreadSafe\"'");
        args.add("-tag 'NotThreadSafe:t:\"NotThreadSafe\"'");
        args.add("-tag 'GuardedBy:mf:\"Guarded By:\"'");
        args.add("-tag 'security:m:\"Required Permissions\"'");
        args.add("-tag 'noimplement:t:\"Consumers of this API must not implement this interface\"'");
        Enumeration<?> e = pp.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = pp.getProperty(key);
            if (!key.startsWith("-")) continue;
            int n = key.lastIndexOf(46);
            if (n > 0) {
                key = key.substring(0, n);
            }
            args.add(String.format("%s '%s'", key, this.escape(value)));
        }
        FileSet set = new FileSet(this.sources, "**.java");
        for (File f : set.getFiles()) {
            args.add(String.format("'%s'", this.fileName(f)));
        }
        if (exportsOnly) {
            Parameters exports = this.manifest.getExportPackage();
            for (String packageName : exports.keySet()) {
                args.add(String.format("'%s'", packageName));
            }
        }
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(arg);
            sb.append('\n');
        }
        IO.store((Object)sb, this.javadocOptions);
        Command command = new Command();
        command.add(this.getProperty("javadoc", "javadoc"));
        command.add("@" + this.fileName(this.javadocOptions));
        StringBuilder out = new StringBuilder();
        StringBuilder err = new StringBuilder();
        int result = command.execute(out, err);
        if (result != 0) {
            this.warning("Error during execution of javadoc command: %s\n******************\n%s", new Object[]{out, err});
        }
        return new Jar(this.javadoc);
    }

    private String fileName(File f) {
        String result = f.getAbsolutePath();
        if (File.separatorChar != '/') {
            result = result.replace(File.separatorChar, '/');
        }
        return result;
    }

    private String escape(String input) {
        return input.replace("\\", "\\\\").replace(System.getProperty("line.separator"), "\\" + System.getProperty("line.separator"));
    }

    void printOverview(String name, String version, String bundleDescription) throws FileNotFoundException {
        Tag body = new Tag("body", new Object[0]);
        new Tag(body, "h1", name);
        new Tag(body, "p", "Version " + version);
        new Tag(body, "p", bundleDescription);
        Tag table = new Tag(body, "table", new Object[0]);
        for (String key : this.manifest) {
            if (key.equalsIgnoreCase("Bundle-Description") || key.equalsIgnoreCase("Bundle-Version")) continue;
            Tag tr = new Tag(table, "tr", new Object[0]);
            new Tag(tr, "td", key);
            new Tag(tr, "td", this.manifest.get(key));
        }
        File overview = new File(this.sources, "overview.html");
        try (PrintWriter pw = new PrintWriter(overview);){
            body.print(2, pw);
        }
    }

    private void set(Properties pp, String key, String value) {
        if (value == null) {
            return;
        }
        if (pp.containsKey(key)) {
            return;
        }
        pp.put(key, value);
    }

    public Jar doSource() throws IOException {
        if (!this.hasSources()) {
            return new Jar("sources");
        }
        return new Jar(this.sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            IO.delete(this.tmp);
        }
    }
}

