/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repository.maven.provider;

import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.Processor;
import aQute.lib.getopt.Arguments;
import aQute.lib.getopt.Options;
import aQute.lib.io.IO;
import aQute.maven.nexus.provider.Nexus;
import aQute.maven.nexus.provider.Signer;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;

public class NexusCommand
extends Processor {
    private NexusOptions options;
    private Nexus nexus;

    public NexusCommand(Processor parent, NexusOptions options) throws Exception {
        super(parent);
        this.options = options;
        if (this.options == null) {
            this.error("No -u/--url set", new Object[0]);
            return;
        }
        HttpClient client = new HttpClient();
        client.readSettings(parent);
        this.nexus = new Nexus(options.url(), client);
    }

    public void _sign(SignOptions options) throws Exception {
        String password = null;
        if (options.password() == null) {
            Console console = System.console();
            if (console == null) {
                this.error("No -p/--password set for PGP key and no console to ask", new Object[0]);
            } else {
                char[] pw = console.readPassword("Passsword: ", new Object[0]);
                if (pw == null || pw.length == 0) {
                    this.error("Password not entered", new Object[0]);
                }
                password = new String(pw);
            }
        } else {
            password = options.password();
        }
        Signer signer = new Signer(new String(password), options.command(this.getProperty("gpg", System.getenv("GPG"))));
        if (signer == null || password == null || !this.isOk()) {
            return;
        }
        List<String> args = options._arguments();
        if (args.isEmpty()) {
            List<URI> files = this.nexus.files();
            for (URI uri : files) {
                try {
                    this.trace("signing %s", new Object[]{this.relative(uri)});
                    File f = this.nexus.download(uri);
                    byte[] signature = signer.sign(f);
                    if (options.show()) {
                        this.show(signature);
                        continue;
                    }
                    this.nexus.upload(new URI(uri + ".asc"), signature);
                }
                catch (Exception e) {
                    this.exception(e, "could not download/sign/upload %s", new Object[]{this.relative(uri)});
                }
            }
        } else {
            for (String arg : args) {
                File f = this.getFile(arg);
                if (!f.isFile()) {
                    this.error("Can't find file %s", new Object[]{f});
                    continue;
                }
                byte[] signature = signer.sign(f);
                if (options.show()) {
                    this.show(signature);
                    continue;
                }
                File out = new File(f.getParentFile(), f.getName() + ".asc");
                IO.store((Object)signature, out);
            }
        }
    }

    private void show(byte[] signature) throws IOException {
        System.out.write(signature);
    }

    public URI relative(URI uri) {
        return this.options.url().relativize(uri);
    }

    public void _files(FilesOption options) throws Exception {
        URI base = this.options.url();
        for (URI uri : this.nexus.files()) {
            System.out.printf("%s%n", base.relativize(uri));
        }
    }

    @Arguments(arg={})
    static interface FilesOption
    extends Options {
    }

    @Arguments(arg={"path..."})
    static interface SignOptions
    extends Options {
        public String command(String var1);

        public boolean show();

        public String password();

        public String key();
    }

    public static interface NexusOptions
    extends Options {
        public URI url();
    }
}

