/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repository.maven.pom.provider;

import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.repository.XMLResourceGenerator;
import aQute.bnd.osgi.repository.XMLResourceParser;
import aQute.bnd.repository.maven.pom.provider.InnerRepository;
import aQute.bnd.repository.maven.pom.provider.Traverser;
import aQute.maven.api.Archive;
import aQute.maven.api.Revision;
import aQute.maven.provider.MavenRepository;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgi.resource.Resource;
import org.osgi.util.promise.Promise;

class PomRepository
extends InnerRepository {
    static final String BND_MAVEN = "bnd.maven";
    static final String BND_MAVEN_EXCEPTION_ATTRIBUTE = "exception";
    static final String BND_MAVEN_ARCHIVE_ATTRIBUTE = "archive";
    static final String BND_MAVEN_REVISION_ATTRIBUTE = "revision";
    final Revision revision;
    final URI revisionUrl;
    final HttpClient client;

    PomRepository(MavenRepository repo, HttpClient client, File location, Revision revision) throws Exception {
        super(repo, location);
        this.revision = revision;
        this.revisionUrl = null;
        this.client = client;
        this.read();
    }

    PomRepository(MavenRepository repo, HttpClient client, File location, URI revision) throws Exception {
        super(repo, location);
        this.revisionUrl = revision;
        this.revision = null;
        this.client = client;
        this.read();
    }

    @Override
    void refresh() throws Exception {
        if (this.revisionUrl != null) {
            this.read(this.revisionUrl);
        } else {
            this.read(this.revision);
        }
    }

    void read(URI revision) throws Exception {
        Traverser traverser = new Traverser(this.getMavenRepository(), revision, this.client, Processor.getExecutor());
        Promise<Map<Archive, Resource>> p = traverser.getResources();
        Collection resources = ((Map)p.getValue()).values();
        this.set(resources);
        this.save(revision.toString(), resources, this.getLocation());
    }

    void read(Revision revision) throws Exception {
        Traverser traverser = new Traverser(this.getMavenRepository(), revision, this.client, Processor.getExecutor());
        Promise<Map<Archive, Resource>> p = traverser.getResources();
        Collection resources = ((Map)p.getValue()).values();
        this.set(resources);
        this.save(revision.toString(), resources, this.getLocation());
    }

    void save(String revision, Collection<? extends Resource> resources, File location) throws Exception, IOException {
        XMLResourceGenerator generator = new XMLResourceGenerator();
        generator.resources(resources);
        generator.name(revision);
        generator.save(location);
    }

    void read() throws Exception {
        if (this.isStale()) {
            this.refresh();
        } else {
            try (XMLResourceParser parser = new XMLResourceParser(this.getLocation());){
                List resources = parser.parse();
                this.addAll(resources);
            }
        }
    }

    private boolean isStale() {
        if (!this.getLocation().isFile()) {
            return true;
        }
        if (this.revisionUrl != null) {
            File file;
            if ("file".equalsIgnoreCase(this.revisionUrl.getScheme()) && (file = new File(this.revisionUrl)).isFile() && file.lastModified() > this.getLocation().lastModified()) {
                return true;
            }
        } else {
            try {
                File file = (File)this.getMavenRepository().get(this.revision.getPomArchive()).getValue();
                if (file.isFile() && file.lastModified() > this.getLocation().lastModified()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

