/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.jpm;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.http.HttpClient;
import aQute.bnd.jpm.Crawler;
import aQute.bnd.jpm.Index;
import aQute.bnd.jpm.ResourceDescriptorImpl;
import aQute.bnd.jpm.StoredRevisionCache;
import aQute.bnd.jpm.util.JSONRPCProxy;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.osgi.resource.FilterParser;
import aQute.bnd.service.Actionable;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.RepositoryListenerPlugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.Strategy;
import aQute.bnd.service.repository.InfoRepository;
import aQute.bnd.service.repository.SearchableRepository;
import aQute.bnd.version.Version;
import aQute.jpm.facade.repo.JpmRepo;
import aQute.lib.collections.MultiMap;
import aQute.lib.collections.SortedList;
import aQute.lib.converter.Converter;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.lib.justif.Justif;
import aQute.lib.settings.Settings;
import aQute.libg.cryptography.MD5;
import aQute.libg.cryptography.SHA1;
import aQute.libg.cryptography.SHA256;
import aQute.libg.glob.Glob;
import aQute.libg.reporter.ReporterAdapter;
import aQute.service.library.Coordinate;
import aQute.service.library.Library;
import aQute.service.library.Revisions;
import aQute.service.reporter.Reporter;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Semaphore;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.osgi.resource.Requirement;
import org.w3c.dom.Document;

public class Repository
implements Plugin,
RepositoryPlugin,
Closeable,
Refreshable,
Actionable,
RegistryPlugin,
SearchableRepository,
InfoRepository {
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private static final XPathFactory xpf = XPathFactory.newInstance();
    public static final String REPO_DEFAULT_URI = "http://repo.jpm4j.org";
    private static final RepositoryPlugin.PutOptions DEFAULT_OPTIONS = new RepositoryPlugin.PutOptions();
    private static final String SEARCH_PREFIX = "/#!/search?q=";
    private static final String UTF_8 = "UTF-8";
    private final String DOWN_ARROW = " \u21e9";
    protected final RepositoryPlugin.DownloadListener[] EMPTY_LISTENER = new RepositoryPlugin.DownloadListener[0];
    private Pattern SHA = Pattern.compile("([A-F0-9][a-fA-F0-9]){20,20}", 2);
    private final Justif j = new Justif(80, 20, 28, 36, 44);
    private Settings settings = new Settings();
    private boolean canwrite;
    final MultiMap<File, RepositoryPlugin.DownloadListener> queues = new MultiMap();
    private final Pattern JPM_REVISION_URL_PATTERN = Pattern.compile("https?://.+#!?/p/([^/]+)/([^/]+)/([^/]*)/([^/]+)");
    private Options options;
    Reporter reporter = new ReporterAdapter(System.out);
    private File indexFile;
    private boolean indexRecurse;
    Index index;
    boolean offline;
    private Registry registry;
    StoredRevisionCache cachex;
    Set<File> notfound = new HashSet<File>();
    private Set<String> notfoundref = new HashSet<String>();
    final Semaphore limitDownloads = new Semaphore(12);
    private JpmRepo libraryx;
    private String depositoryGroup;
    private String depositoryName;
    private String location;
    private URI depository;
    private String email;
    private String name;
    private URI url;
    private HttpClient httpClient = new HttpClient();
    Pattern COMMAND_P = Pattern.compile("^([^/]*)/(!?[lmsprw])([^/]*)$");
    private File cacheDir;
    static Pattern JAR_FILE_P = Pattern.compile("(https?:.+)(\\.jar)");
    String[] sizes = new String[]{"bytes", "Kb", "Mb", "Gb", "Tb", "Pb", "Showing off?"};
    private Crawler crawler;
    private boolean crawl;

    public File get(String bsn, Version version, Map<String, String> attrs, RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        this.init();
        Library.RevisionRef resource = this.index.getRevisionRef(bsn, version);
        if (resource == null) {
            return null;
        }
        return this.getLocal(resource, attrs, listeners);
    }

    private File getLocal(Library.RevisionRef resource, Map<String, String> attrs, RepositoryPlugin.DownloadListener ... downloadListeners) throws Exception {
        File sources = this.getCache().getPath(resource.bsn, Index.toVersion(resource).toString(), resource.revision, true);
        if (sources.isFile()) {
            for (RepositoryPlugin.DownloadListener dl : downloadListeners) {
                dl.success(sources);
            }
            return sources;
        }
        File file = this.getCache().getPath(resource.bsn, Index.toVersion(resource).toString(), resource.revision);
        this.scheduleDownload(file, resource.revision, resource.size, resource.urls, downloadListeners);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleDownload(final File file, final byte[] sha, long size, final Set<URI> urls, RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        Object object = this.notfound;
        synchronized (object) {
            if (this.notfound.contains(file)) {
                this.failure(listeners, file, "Not found");
                return;
            }
        }
        if (file.isFile()) {
            if (file.length() == size) {
                this.success(listeners, file);
                this.reporter.trace("was in cache", new Object[0]);
                return;
            }
            this.reporter.error("found file but of different length %s, will refetch", new Object[]{file});
        } else {
            this.reporter.trace("not in cache %s %s", new Object[]{file, this.queues});
        }
        if (!this.isConnected()) {
            this.failure(listeners, file, "Not online");
        }
        if (listeners.length == 0) {
            this.reporter.trace("in cache, no listeners", new Object[0]);
            this.getCache().download(file, urls, sha);
            return;
        }
        object = this.queues;
        synchronized (object) {
            List list = (List)this.queues.get(file);
            boolean first = list == null || list.isEmpty();
            for (RepositoryPlugin.DownloadListener l : listeners) {
                this.queues.add(file, l);
            }
            if (!first) {
                this.reporter.trace("someone else is downloading our file %s", new Object[]{this.queues.get(file)});
                return;
            }
        }
        try {
            this.reporter.trace("starting thread for %s", new Object[]{file});
            this.limitDownloads.acquire();
            Thread t = new Thread("Downloading " + file){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void run() {
                    MultiMap<File, RepositoryPlugin.DownloadListener> multiMap;
                    try {
                        Repository.this.reporter.trace("downloading in background %s", new Object[]{file});
                        Repository.this.getCache().download(file, urls, sha);
                        Repository.this.success(((List)Repository.this.queues.get(file)).toArray(Repository.this.EMPTY_LISTENER), file);
                        multiMap = Repository.this.queues;
                    }
                    catch (FileNotFoundException e2222222222) {
                        Object object2 = Repository.this.notfound;
                        synchronized (object2) {
                            Repository.this.reporter.error("Not found %s", new Object[]{e2222222222, file});
                            Repository.this.notfound.add(file);
                        }
                        object2 = Repository.this.queues;
                        synchronized (object2) {
                            Repository.this.failure(((List)Repository.this.queues.get(file)).toArray(Repository.this.EMPTY_LISTENER), file, e2222222222.toString());
                        }
                        MultiMap<File, RepositoryPlugin.DownloadListener> e2222222222 = Repository.this.queues;
                        synchronized (e2222222222) {
                            Repository.this.queues.remove(file);
                        }
                        Repository.this.reporter.trace("downloaded %s", new Object[]{file});
                        Repository.this.limitDownloads.release();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        Repository.this.reporter.error("failed to download %s: %s", new Object[]{e, file});
                        MultiMap<File, RepositoryPlugin.DownloadListener> multiMap2 = Repository.this.queues;
                        synchronized (multiMap2) {
                            Repository.this.failure(((List)Repository.this.queues.get(file)).toArray(Repository.this.EMPTY_LISTENER), file, e.toString());
                        }
                        MultiMap<File, RepositoryPlugin.DownloadListener> multiMap3 = Repository.this.queues;
                        {
                            catch (Throwable throwable) {
                                MultiMap<File, RepositoryPlugin.DownloadListener> multiMap4 = Repository.this.queues;
                                synchronized (multiMap4) {
                                    Repository.this.queues.remove(file);
                                }
                                Repository.this.reporter.trace("downloaded %s", new Object[]{file});
                                Repository.this.limitDownloads.release();
                                throw throwable;
                            }
                        }
                        synchronized (multiMap3) {
                            Repository.this.queues.remove(file);
                        }
                        Repository.this.reporter.trace("downloaded %s", new Object[]{file});
                        Repository.this.limitDownloads.release();
                    }
                    synchronized (multiMap) {
                        Repository.this.queues.remove(file);
                    }
                    Repository.this.reporter.trace("downloaded %s", new Object[]{file});
                    Repository.this.limitDownloads.release();
                }
            };
            t.start();
        }
        catch (Exception e) {
            this.reporter.error("Starting a download for %s failed %s", new Object[]{file, e});
            MultiMap<File, RepositoryPlugin.DownloadListener> multiMap = this.queues;
            synchronized (multiMap) {
                this.failure(((List)this.queues.get(file)).toArray(this.EMPTY_LISTENER), file, e.toString());
                this.queues.remove(file);
            }
        }
    }

    public boolean canWrite() {
        return this.canwrite;
    }

    public RepositoryPlugin.PutResult put(InputStream in, RepositoryPlugin.PutOptions options) throws Exception {
        if (!this.canwrite) {
            throw new UnsupportedOperationException("This is not a writeable repo, set depository.group, depository.name and properties and ensure the email property is in your global settings");
        }
        assert (in != null);
        assert (this.depositoryGroup != null);
        assert (this.depositoryName != null);
        this.init();
        if (options == null) {
            options = DEFAULT_OPTIONS;
        }
        this.reporter.trace("syncing", new Object[0]);
        this.sync();
        File file = File.createTempFile("put", ".jar");
        file.deleteOnExit();
        try {
            this.reporter.trace("creating tmp copy", new Object[0]);
            IO.copy(in, file);
            if (this.depository == null) {
                this.reporter.trace("send to url %s", new Object[]{this.url});
                this.depository = this.getLibrary().depository(this.depositoryGroup, this.depositoryName);
                this.reporter.trace("credentials %s", new Object[]{this.depository});
            }
            byte[] digest = options.digest == null ? SHA1.digest(file).digest() : options.digest;
            String path = Hex.toHexString(digest);
            this.reporter.trace("putting %s", new Object[]{path});
            URI uri = this.getDepository(path);
            Library.RevisionRef d = (Library.RevisionRef)this.httpClient.build().verb("PUT").upload((Object)file).get(Library.RevisionRef.class).go(uri.toURL());
            if (d == null) {
                this.reporter.error("Cant deposit %s", new Object[]{file});
                RepositoryPlugin.PutResult putResult = null;
                return putResult;
            }
            if (!Arrays.equals(digest, d.revision)) {
                throw new Exception("Invalid digest");
            }
            this.getCache().add(d, file);
            this.index.addRevision(d);
            this.index.save();
            RepositoryPlugin.PutResult putr = new RepositoryPlugin.PutResult();
            putr.artifact = uri;
            putr.digest = digest;
            RepositoryPlugin.PutResult putResult = putr;
            return putResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            file.delete();
        }
    }

    private URI getDepository(String path) throws Exception {
        if (this.depository == null) {
            this.depository = this.getLibrary().depository(this.depositoryGroup, this.depositoryName);
        }
        return new URI(this.depository + "/" + path);
    }

    public List<String> list(String query) throws Exception {
        this.init();
        HashSet<String> bsns = new HashSet<String>();
        query = query == null || query.trim().isEmpty() ? "*" : query.trim();
        Library.Phase phase = null;
        boolean negated = false;
        Matcher m = this.COMMAND_P.matcher(query);
        if (m.matches()) {
            query = m.group(1) + m.group(3);
            String cmd = m.group(2);
            if (cmd.startsWith("!")) {
                negated = true;
                cmd = cmd.substring(1);
            }
            char c = Character.toLowerCase(cmd.charAt(0));
            switch (c) {
                case 'l': {
                    phase = Library.Phase.LOCKED;
                    break;
                }
                case 'p': {
                    phase = Library.Phase.PENDING;
                    break;
                }
                case 's': {
                    phase = Library.Phase.STAGING;
                    break;
                }
                case 'm': {
                    phase = Library.Phase.MASTER;
                    break;
                }
                case 'r': {
                    phase = Library.Phase.RETIRED;
                    break;
                }
                case 'w': {
                    phase = Library.Phase.WITHDRAWN;
                }
            }
            this.reporter.trace("Phase is %s %s", new Object[]{Character.valueOf(c), phase});
        }
        Glob glob = null;
        try {
            glob = new Glob(query);
        }
        catch (Exception e) {
            glob = new Glob("*");
        }
        for (String bsn : this.index.getBsns()) {
            if (!glob.matcher(bsn).matches()) continue;
            if (phase != null) {
                boolean hasPhase = false;
                for (Version version : this.index.getVersions(bsn)) {
                    Library.RevisionRef ref = this.index.getRevisionRef(bsn, version);
                    if (ref.phase != phase) continue;
                    hasPhase = true;
                    break;
                }
                if (hasPhase == negated) continue;
            }
            bsns.add(bsn);
        }
        ArrayList<String> result = new ArrayList<String>(bsns);
        Collections.sort(result);
        return result;
    }

    public SortedSet<Version> versions(String bsn) throws Exception {
        this.init();
        SortedSet<Version> versions = this.index.getVersions(bsn);
        if (!versions.isEmpty() || !this.index.isLearning()) {
            return versions;
        }
        return versions;
    }

    static Version toVersion(String baseline, String qualifier) {
        if (qualifier == null || qualifier.isEmpty()) {
            return new Version(baseline);
        }
        return new Version(baseline + "." + qualifier);
    }

    private boolean isSha(String bsn) {
        return this.SHA.matcher(bsn).matches();
    }

    public String getName() {
        return this.name == null ? "jpm4j" : this.name;
    }

    public void setProperties(Map<String, String> map) {
        try {
            this.options = Converter.cnv(Options.class, map);
            this.setOptions(this.options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setOptions(Options options) {
        try {
            this.location = options.location();
            if (this.location == null) {
                this.location = "~/.bnd/shacache";
            }
            this.name = options.name();
            if (options.settings() != null) {
                this.settings = new Settings(options.settings());
            }
            this.email = options.email();
            if (this.email == null) {
                this.email = this.settings.getEmail();
            }
            this.url = options.url();
            if (this.url == null) {
                this.url = new URI(REPO_DEFAULT_URI);
            }
            this.cacheDir = IO.getFile(IO.home, this.location);
            this.cacheDir.mkdirs();
            if (!this.cacheDir.isDirectory()) {
                throw new IllegalArgumentException("Not able to create cache directory " + this.cacheDir);
            }
            String indexPath = options.index();
            if (indexPath == null) {
                throw new IllegalArgumentException("Index file not set (index) ");
            }
            this.indexFile = IO.getFile(indexPath);
            if (this.indexFile.isDirectory()) {
                throw new IllegalArgumentException("Index file is a directory instead of a file " + this.indexFile.getAbsolutePath());
            }
            this.indexRecurse = options.recurse();
            if (options.index() == null) {
                throw new IllegalArgumentException("Index file not set");
            }
            this.canwrite = false;
            if (options.depository_group() != null) {
                this.depositoryGroup = options.depository_group();
                this.depositoryName = options.depository_name();
                if (this.depositoryName == null) {
                    this.depositoryName = "home";
                }
                this.canwrite = this.email != null;
            }
            this.crawl = options.crawl();
        }
        catch (Exception e) {
            if (this.reporter != null) {
                this.reporter.exception((Throwable)e, "Creating options", new Object[0]);
            }
            throw new RuntimeException(e);
        }
    }

    public void setReporter(Reporter processor) {
        this.reporter = processor;
        if (this.index != null) {
            this.index.setReporter(this.reporter);
        }
    }

    public boolean refresh() throws Exception {
        this.index = new Index(this.indexFile);
        this.index.setRecurse(this.indexRecurse);
        this.getCache().refresh();
        this.notfound.clear();
        this.notfoundref.clear();
        if (this.crawler != null) {
            this.crawler.refresh();
        }
        return true;
    }

    public Map<String, Runnable> actions(Object ... target) throws Exception {
        this.init();
        boolean connected = this.isConnected();
        if (target == null) {
            return null;
        }
        if (target.length == 0) {
            return this.getRepositoryActions();
        }
        String bsn = (String)target[0];
        Library.Program careful = null;
        if (connected) {
            try {
                careful = this.getProgram(bsn, true);
            }
            catch (Exception e) {
                this.reporter.error("Offline? %s", new Object[]{e});
            }
        }
        Library.Program p = careful;
        if (target.length == 1) {
            return this.getProgramActions(bsn, p);
        }
        if (target.length >= 2) {
            Version version = (Version)target[1];
            return this.getRevisionActions(p, bsn, version);
        }
        return null;
    }

    private Map<String, Runnable> getRevisionActions(Library.Program program, final String bsn, final Version version) throws Exception {
        final Library.RevisionRef resource = this.index.getRevisionRef(bsn, version);
        LinkedHashMap<String, Runnable> map = new LinkedHashMap<String, Runnable>();
        map.put("Inspect Revision", new Runnable(){

            @Override
            public void run() {
                Repository.this.open(Repository.this.url + "#!/p/sha/" + Hex.toHexString(resource.revision) + "//0.0.0");
            }
        });
        map.put("Copy reference", new Runnable(){

            @Override
            public void run() {
                Repository.this.toClipboard(bsn, version);
            }
        });
        Runnable doUpdate = this.getUpdateAction(program, resource);
        if (doUpdate != null) {
            map.put("Update to " + doUpdate, doUpdate);
        } else {
            map.put("-Update", null);
        }
        map.put("Delete", new Runnable(){

            @Override
            public void run() {
                try {
                    Repository.this.delete(bsn, version, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        if (this.isConnected()) {
            File sourceFile = this.getCache().getPath(bsn, version.toString(), resource.revision, true);
            Runnable run = null;
            if (!sourceFile.isFile()) {
                URL sourceURI = null;
                for (URI uri : resource.urls) {
                    try {
                        Matcher m = JAR_FILE_P.matcher(uri.toString());
                        if (!m.matches()) continue;
                        String stem = m.group(1);
                        URL src = new URL(stem + "-sources.jar");
                        HttpURLConnection conn = (HttpURLConnection)src.openConnection();
                        conn.setRequestMethod("HEAD");
                        if (conn.getResponseCode() != 200) continue;
                        sourceURI = src;
                    }
                    catch (Exception e) {}
                }
                if (sourceURI != null) {
                    run = this.createAddSourceAction(bsn, version, resource, sourceFile, sourceURI);
                }
            } else {
                this.reporter.trace("sources in %s", new Object[]{sourceFile});
            }
            if (run != null) {
                map.put("Add Sources", run);
            } else {
                map.put("-Add Sources", null);
            }
        }
        if (this.getCache().hasSources(bsn, version.toString(), resource.revision)) {
            map.put("Remove Sources", new Runnable(){

                @Override
                public void run() {
                    try {
                        Repository.this.getCache().removeSources(bsn, version.toString(), resource.revision);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return map;
    }

    protected Runnable createAddSourceAction(final String bsn, final Version version, final Library.RevisionRef resource, final File withSources, final URL src) {
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Repository.this.get(bsn, version, null, new RepositoryPlugin.DownloadListener[0]);
                    File file = Repository.this.getCache().getPath(bsn, version.toString(), resource.revision);
                    try (Jar binary = new Jar(file);){
                        binary.setDoNotTouchManifest();
                        try (Jar sources = new Jar(src.getFile(), src.openStream());){
                            binary.addAll(sources, null, "OSGI-OPT/src");
                            binary.write(withSources);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return run;
    }

    protected Runnable createRemoveSourceAction(final String bsn, final Version version, final Library.RevisionRef resource, final File withSources, final URL src) {
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Repository.this.get(bsn, version, null, new RepositoryPlugin.DownloadListener[0]);
                    File file = Repository.this.getCache().getPath(bsn, version.toString(), resource.revision);
                    try (Jar binary = new Jar(file);
                         Jar sources = new Jar(src.getFile(), src.openStream());){
                        binary.addAll(sources, null, "OSGI-OPT/src");
                        binary.write(withSources);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return run;
    }

    private Map<String, Runnable> getProgramActions(final String bsn, Library.Program p) throws Exception {
        LinkedHashMap<String, Runnable> map = new LinkedHashMap<String, Runnable>();
        if (p != null) {
            map.put("Inspect Program", new Runnable(){

                @Override
                public void run() {
                    Repository.this.open(Repository.this.url + "#!/p/osgi/" + bsn);
                }
            });
            final SortedSet<Version> versions = this.index.getVersions(bsn);
            if (versions.isEmpty()) {
                map.put("-Copy reference", null);
            } else {
                map.put("Copy reference", new Runnable(){

                    @Override
                    public void run() {
                        Repository.this.toClipboard(bsn, (Version)versions.first());
                    }
                });
            }
            Library.RevisionRef ref = p.revisions.get(0);
            Version latest = Repository.toVersion(ref.baseline, ref.qualifier);
            for (Version v : this.index.getVersions(bsn)) {
                if (!v.equals((Object)latest)) continue;
                latest = null;
                break;
            }
            final Version l = latest;
            String title = "Get Latest";
            title = latest == null ? "-" + title : title + " " + l + (Object)((Object)ref.phase);
            map.put(title, new Runnable(){

                @Override
                public void run() {
                    try {
                        Repository.this.add(bsn, l);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            Runnable updateAction = this.getUpdateAction(p, bsn);
            if (updateAction != null) {
                map.put("Update " + updateAction, updateAction);
            } else {
                map.put("-Update", null);
            }
        } else {
            map.put("-Update (offline)", null);
        }
        map.put("Delete", new Runnable(){

            @Override
            public void run() {
                try {
                    Repository.this.delete(bsn);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return map;
    }

    private Map<String, Runnable> getRepositoryActions() throws Exception {
        LinkedHashMap<String, Runnable> map = new LinkedHashMap<String, Runnable>();
        if (this.offline) {
            if (this.isConnected()) {
                map.put("Try Online", new Runnable(){

                    @Override
                    public void run() {
                        Repository.this.offline = false;
                    }
                });
            }
        } else {
            map.put("Go Offline", new Runnable(){

                @Override
                public void run() {
                    Repository.this.offline = true;
                }
            });
        }
        map.put("Inspect", new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] revisions = Repository.this.sync();
                    Repository.this.open(Repository.this.url + "#!/revisions/" + Hex.toHexString(revisions));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        map.put("Delete Cache", new Runnable(){

            @Override
            public void run() {
                try {
                    Repository.this.getCache().deleteAll();
                }
                catch (Exception e) {
                    Repository.this.reporter.error("Deleting cache %s", new Object[]{e});
                }
            }
        });
        map.put("Refresh", new Runnable(){

            @Override
            public void run() {
                try {
                    Repository.this.refresh();
                }
                catch (Exception e) {
                    Repository.this.reporter.error("Refreshing %s", new Object[]{e});
                }
            }
        });
        map.put("Update All", new Runnable(){

            @Override
            public void run() {
                try {
                    Repository.this.updateAll();
                }
                catch (Exception e) {
                    Repository.this.reporter.error("Update all %s", new Object[]{e});
                }
            }
        });
        map.put("Download All", new Runnable(){

            @Override
            public void run() {
                try {
                    RepositoryPlugin.DownloadListener dl = new RepositoryPlugin.DownloadListener(){

                        public void success(File file) throws Exception {
                            Repository.this.reporter.trace("downloaded %s", new Object[]{file});
                        }

                        public void failure(File file, String reason) throws Exception {
                            Repository.this.reporter.trace("failed to download %s becasue %s", new Object[]{file, reason});
                        }

                        public boolean progress(File file, int percentage) throws Exception {
                            Repository.this.reporter.progress((float)percentage / 100.0f, "downloading %s", new Object[]{file});
                            return true;
                        }
                    };
                    for (String bsn : Repository.this.list(null)) {
                        for (Version v : Repository.this.versions(bsn)) {
                            Repository.this.get(bsn, v, null, dl);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        map.put("Remove unused/Add missing", new Runnable(){

            @Override
            public void run() {
                try {
                    Repository.this.cleanUp();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        String title = "Learning{Unknown resources are an error, select to learn}";
        if (this.index.isLearning()) {
            title = "!Learning{Will attempt to fetch unknown resources, select to make this an error}";
        }
        map.put(title, new Runnable(){

            @Override
            public void run() {
                try {
                    Repository.this.index.setLearning(!Repository.this.index.isLearning());
                    Repository.this.index.save();
                }
                catch (Exception e) {
                    Repository.this.reporter.error("Learning %s", new Object[]{e});
                }
            }
        });
        title = "Recurse{Do not fetch dependencies automatically}";
        if (this.index.isRecurse()) {
            title = "!Recurse{Fetch dependencies automatically}";
        }
        map.put(title, new Runnable(){

            @Override
            public void run() {
                try {
                    Repository.this.index.setRecurse(!Repository.this.index.isRecurse());
                    Repository.this.index.save();
                }
                catch (Exception e) {
                    Repository.this.reporter.error("Learning %s", new Object[]{e});
                }
            }
        });
        return map;
    }

    public String tooltip(Object ... target) throws Exception {
        this.init();
        if (target == null || target.length == 0) {
            return this.repositoryTooltip();
        }
        if (target.length == 1) {
            return this.programTooltip((String)target[0]);
        }
        if (target.length == 2) {
            return this.revisionTooltip((String)target[0], (Version)target[1]);
        }
        return "Hmm, have no idea on what object you want a tooltip ...";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String repositoryTooltip() throws Exception {
        try (Formatter f = new Formatter();){
            f.format("%s\n", this);
            if (this.depositoryGroup != null && this.depositoryName != null) {
                f.format("\n[Depository]\n", new Object[0]);
                f.format("Group: %s\n", this.depositoryGroup);
                f.format("Depository: %s\n", this.depositoryName);
                f.format("Email: %s\n", this.email);
                f.format("Writable: %s %s\n", this.canwrite, this.email == null ? "(no email set, see 'bnd settings email=...')" : "");
                f.format("Public key: %s\u2026\n", Hex.toHexString(this.settings.getPublicKey()).substring(0, 16));
            }
            f.format("\n[Files]\nCache location %s\n", this.options.location());
            f.format("Index file     %s\n", this.options.index());
            f.format("Number of bsns %s\n", this.index.getBsns().size());
            f.format("Number of revs %s\n", this.index.getRevisionRefs().size());
            f.format("Dirty          %s\n", this.index.isDirty());
            String string = f.toString().trim();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String programTooltip(String bsn) throws Exception {
        Library.Program p = this.getProgram(bsn, false);
        if (p != null) {
            try (Formatter sb = new Formatter();){
                if (p.wiki != null && p.wiki.text != null) {
                    sb.format("%s\n", p.wiki.text.replaceAll("#\\s?", ""));
                } else if (p.last.description != null) {
                    sb.format("%s\n", p.last.description);
                } else {
                    sb.format("No description\n", new Object[0]);
                }
                if (bsn.indexOf("__") >= 0) {
                    sb.format("\nThis artifact has no OSGi metadata. Its coordinates are %s:%s\n", p.groupId, p.artifactId);
                }
                this.j.wrap((StringBuilder)sb.out());
                String string = sb.toString().trim();
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String revisionTooltip(String bsn, Version version) throws Exception {
        Library.RevisionRef r = this.getRevisionRef(bsn, version);
        if (r == null) {
            return null;
        }
        try (Formatter sb = new Formatter();){
            File sources;
            Runnable update;
            Library.Program p;
            sb.format("[%s:%s", r.groupId, r.artifactId);
            if (r.classifier != null) {
                sb.format(":%s", r.classifier);
            }
            sb.format("@%s] %s\n\n", new Object[]{r.version, r.phase});
            if (r.releaseSummary != null) {
                sb.format("%s\n\n", r.releaseSummary);
            }
            if (r.description != null) {
                sb.format("%s\n\n", r.description.replaceAll("#\\s*", ""));
            }
            sb.format("Size: %s\n", this.size(r.size, 0));
            sb.format("SHA-1: %s\n", Hex.toHexString(r.revision));
            sb.format("Age: %s\n", this.age(r.created));
            sb.format("URL: %s\n", r.urls);
            File f = this.getCache().getPath(bsn, version.toString(), r.revision);
            if (f.isFile() && f.length() == r.size) {
                sb.format("Cached %s\n", f);
            } else {
                sb.format("Not downloaded\n", new Object[0]);
            }
            if (bsn.indexOf("__") >= 0) {
                sb.format("\nThis artifact has no OSGi metadata. Its coordinates are %s:%s@%s\n", r.groupId, r.artifactId, r.version);
            }
            if ((p = this.getProgram(bsn, false)) != null && (update = this.getUpdateAction(p, r)) != null) {
                sb.format("%c This version can be updated to %s\n", " \u21e9", update);
            }
            if ((sources = this.getCache().getPath(bsn, version.toString(), r.revision, true)).isFile()) {
                sb.format("Has sources: %s\n", sources.getAbsolutePath());
            } else {
                sb.format("No sources\n", new Object[0]);
            }
            this.j.wrap((StringBuilder)sb.out());
            String string = sb.toString().trim();
            return string;
        }
    }

    private List<Library.RevisionRef> getRevisionRefs(String bsn) throws Exception {
        Library.Program program;
        String classifier = null;
        String[] parts = bsn.split("__");
        if (parts.length == 3) {
            bsn = parts[0] + "__" + parts[1];
            classifier = parts[2];
        }
        if ((program = this.getProgram(bsn, false)) != null) {
            ArrayList<Library.RevisionRef> refs = new ArrayList<Library.RevisionRef>();
            for (Library.RevisionRef r : program.revisions) {
                if (!this.eq(classifier, r.classifier)) continue;
                refs.add(r);
            }
            return refs;
        }
        return Collections.emptyList();
    }

    private Library.RevisionRef getRevisionRef(String bsn, Version version) throws Exception {
        String id = bsn + "-" + version;
        if (this.notfoundref.contains(id)) {
            return null;
        }
        if (this.isSha(bsn) && version.equals((Object)Version.LOWEST)) {
            Library.Revision r = this.getRevision(new Coordinate(bsn));
            if (r == null) {
                return null;
            }
            return new Library.RevisionRef(r);
        }
        this.reporter.trace("Looking for %s-%s", new Object[]{bsn, version});
        for (Library.RevisionRef r : this.getRevisionRefs(bsn)) {
            Version v = Repository.toVersion(r.baseline, r.qualifier);
            if (!v.equals((Object)version)) continue;
            return r;
        }
        this.notfoundref.add(id);
        return null;
    }

    private boolean eq(String a, String b) {
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        return a.equals(b);
    }

    private String age(long created) {
        if (created == 0L) {
            return "unknown";
        }
        long diff = (System.currentTimeMillis() - created) / 3600000L;
        if (diff < 48L) {
            return diff + " hours";
        }
        if ((diff /= 24L) < 14L) {
            return diff + " days";
        }
        if ((diff /= 7L) < 8L) {
            return diff + " weeks";
        }
        if ((diff /= 4L) < 24L) {
            return diff + " months";
        }
        return (diff /= 12L) + " years";
    }

    private String size(long size, int power) {
        if (power >= this.sizes.length) {
            return size + " Pb";
        }
        if (size < 1000L) {
            return size + this.sizes[power];
        }
        return this.size(size / 1000L, power + 1);
    }

    void updateAll() throws Exception {
        for (String bsn : new ArrayList<String>(this.index.getBsns())) {
            this.update(bsn);
        }
    }

    void update(String bsn) throws Exception {
        Library.Program program = this.getProgram(bsn, false);
        Runnable updateAction = this.getUpdateAction(program, bsn);
        if (updateAction == null) {
            return;
        }
        this.reporter.trace("update bsn %s", new Object[]{updateAction});
        updateAction.run();
    }

    Runnable getUpdateAction(Library.Program program, String bsn) throws Exception {
        final ArrayList<Runnable> update = new ArrayList<Runnable>();
        for (Version v : this.index.getVersions(bsn)) {
            Library.RevisionRef resource = this.index.getRevisionRef(bsn, v);
            Runnable updateAction = this.getUpdateAction(program, resource);
            if (updateAction == null) continue;
            update.add(updateAction);
        }
        if (update.isEmpty()) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                for (Runnable r : update) {
                    r.run();
                }
            }

            public String toString() {
                return update.toString();
            }
        };
    }

    private Runnable getUpdateAction(Library.Program program, final Library.RevisionRef current) throws Exception {
        Library.RevisionRef candidateRef = null;
        Version candidate = Repository.toVersion(current.baseline, current.qualifier);
        for (Library.RevisionRef r : program.revisions) {
            Version refVersion = Repository.toVersion(r.baseline, r.qualifier);
            if (!this.eq(r.classifier, current.classifier) || refVersion.compareTo(candidate) < 0) continue;
            candidate = refVersion;
            candidateRef = r;
        }
        if (candidateRef == null) {
            return new Runnable(){

                @Override
                public void run() {
                    try {
                        Repository.this.index.delete(current.bsn, Repository.toVersion(current.baseline, current.qualifier));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public String toString() {
                    return "[delete]";
                }
            };
        }
        if (!candidateRef.version.equals(current.version)) {
            final Library.RevisionRef toAdd = candidateRef;
            return new Runnable(){

                @Override
                public void run() {
                    try {
                        Repository.this.index.delete(current.bsn, Repository.toVersion(current.baseline, current.qualifier));
                        Repository.this.index.addRevision(toAdd);
                        Repository.this.index.save();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public String toString() {
                    return toAdd.version;
                }
            };
        }
        if (candidateRef.phase != current.phase) {
            final Library.RevisionRef toChange = candidateRef;
            return new Runnable(){

                @Override
                public void run() {
                    try {
                        Repository.this.index.delete(current.bsn, Repository.toVersion(current.baseline, current.qualifier));
                        Repository.this.index.addRevision(toChange);
                        Repository.this.index.save();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public String toString() {
                    return "-> " + (Object)((Object)toChange.phase);
                }
            };
        }
        return null;
    }

    public void setIndex(File index) {
        this.indexFile = index;
    }

    void success(RepositoryPlugin.DownloadListener[] downloadListeners, File f) {
        for (RepositoryPlugin.DownloadListener l : downloadListeners) {
            try {
                l.success(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void failure(RepositoryPlugin.DownloadListener[] listeners, File f, String reason) {
        for (RepositoryPlugin.DownloadListener l : listeners) {
            try {
                l.failure(f, reason);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String title(Object ... target) throws Exception {
        this.init();
        if (target == null || target.length == 0) {
            return this.getName();
        }
        if (target.length == 1 && target[0] instanceof String) {
            String bsn;
            String title = bsn = (String)target[0];
            if (bsn.indexOf("__") > 0) {
                title = title + " [!]";
            }
            return title;
        }
        if (target.length == 2 && target[0] instanceof String && target[1] instanceof Version) {
            String bsn = (String)target[0];
            Version version = (Version)target[1];
            Library.RevisionRef resource = this.index.getRevisionRef(bsn, version);
            if (resource == null) {
                return "[deleted " + version + "]";
            }
            String title = this.getPhase(resource.phase.toString()) + " " + version.toString();
            File path = this.getCache().getPath(bsn, version.toString(), resource.revision);
            if (path.isFile() && path.length() == resource.size) {
                title = title + " \u21e9";
            }
            if (this.getCache().getPath(bsn, version.toString(), resource.revision, true).isFile()) {
                title = title + "+";
            }
            return title;
        }
        return null;
    }

    private String getPhase(String phase) {
        try {
            return Phase.valueOf(phase).getSymbol();
        }
        catch (Exception e) {
            return "?";
        }
    }

    public File getRoot() throws Exception {
        return this.getCache().getRoot();
    }

    @Override
    public void close() throws IOException {
        if (this.crawler != null) {
            this.crawler.close();
        }
    }

    public String getLocation() {
        return this.options.location();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void fireBundleAdded(File file) throws IOException {
        if (this.registry == null) {
            return;
        }
        List listeners = this.registry.getPlugins(RepositoryListenerPlugin.class);
        if (listeners.isEmpty()) {
            return;
        }
        try (Jar jar = new Jar(file);){
            for (RepositoryListenerPlugin listener : listeners) {
                try {
                    try {
                        listener.bundleAdded((RepositoryPlugin)this, jar, file);
                    }
                    catch (Exception e) {
                        this.reporter.error("Repository listener threw an unexpected exception: %s", new Object[]{e, e});
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                    return;
                }
            }
        }
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
        this.httpClient = (HttpClient)registry.getPlugin(HttpClient.class);
    }

    private void init() throws Exception {
        if (this.index == null) {
            this.reporter.trace("init %s", new Object[]{this.indexFile});
            this.index = new Index(this.indexFile);
            this.index.setRecurse(this.indexRecurse);
            this.index.setReporter(this.reporter);
            if (this.crawl) {
                this.crawler = new Crawler(this);
                this.crawler.start();
            }
        }
    }

    public void add(String bsn, Version version) throws Exception {
        this.reporter.trace("Add %s %s", new Object[]{bsn, version});
        Library.RevisionRef ref = this.getRevisionRef(bsn, version);
        this.add(ref);
    }

    void add(Library.RevisionRef ref) throws Exception {
        Version newVersion = Repository.toVersion(ref.baseline, ref.qualifier);
        this.reporter.trace("New version %s %s", new Object[]{ref.bsn, newVersion});
        Version newMask = Repository.mask(newVersion);
        ArrayList<Version> toBeDeleted = new ArrayList<Version>();
        for (Version existingVersion : this.index.getVersions(ref.bsn)) {
            Version existingMask = Repository.mask(existingVersion);
            if (!newMask.equals((Object)existingMask)) continue;
            this.reporter.trace("delete %s-%s", new Object[]{ref.bsn, existingVersion});
            toBeDeleted.add(existingVersion);
        }
        for (Version v : toBeDeleted) {
            this.index.delete(ref.bsn, v);
        }
        this.reporter.trace("add %s-%s", new Object[]{ref.bsn, newVersion});
        this.index.addRevision(ref);
        this.getLocal(ref, null, new LocalDownloadListener());
        if (this.index.isRecurse()) {
            Iterable<Library.RevisionRef> refs = this.getClosure(ref);
            for (Library.RevisionRef r : refs) {
                this.index.addRevision(r);
                this.getLocal(ref, null, new LocalDownloadListener());
            }
        }
        this.index.save();
    }

    private Iterable<Library.RevisionRef> getClosure(Library.RevisionRef ref) throws Exception {
        return this.getLibrary().getClosure(ref.revision, false);
    }

    public void delete(String bsn, Version version, boolean immediate) throws Exception {
        this.reporter.trace("Delete %s %s", new Object[]{bsn, version});
        Library.RevisionRef resource = this.index.getRevisionRef(bsn, version);
        if (resource != null) {
            boolean removed = this.index.delete(bsn, version);
            this.reporter.trace("Was present %s", new Object[]{removed});
            this.index.save();
        } else {
            this.reporter.trace("No such resource", new Object[0]);
        }
    }

    public void delete(String bsn) throws Exception {
        this.reporter.trace("Delete %s", new Object[]{bsn});
        HashSet<Version> set = new HashSet<Version>(this.index.getVersions(bsn));
        this.reporter.trace("Versions %s", new Object[]{set});
        for (Version version : set) {
            this.delete(bsn, version, true);
        }
    }

    public boolean dropTarget(URI uri) throws Exception {
        try {
            Library.RevisionRef ref;
            this.init();
            String t = uri.toString().trim();
            int n = t.indexOf(10);
            if (n > 0) {
                uri = new URI(t.substring(0, n));
                this.reporter.trace("dropTarget cleaned up from %s to %s", new Object[]{t, uri});
            }
            this.reporter.trace("dropTarget %s", new Object[]{uri});
            String uriString = uri.toString();
            Matcher m = this.JPM_REVISION_URL_PATTERN.matcher(uriString);
            if (!m.matches()) {
                if (this.depositoryGroup != null || this.depositoryName != null) {
                    return false;
                }
                if (!Boolean.getBoolean("jpm4j.in.test") && uri.getScheme().equalsIgnoreCase("file")) {
                    return false;
                }
                StoredRevisionCache.Download d = this.getCache().doDownload(uri);
                if (d == null) {
                    return false;
                }
                ref = this.analyze(d.tmp, uri);
                if (ref == null) {
                    this.reporter.trace("not a proper url to drop %s", new Object[]{uri});
                    d.tmp.delete();
                    return false;
                }
                this.getCache().makePermanent(ref, d);
            } else {
                Library.Revision revision = this.getRevision(new Coordinate(m.group(1), m.group(2), m.group(3), m.group(4)));
                if (revision == null) {
                    this.reporter.error("no revision found for %s", new Object[]{uri});
                    return false;
                }
                ref = new Library.RevisionRef(revision);
            }
            Library.RevisionRef resource = this.index.getRevisionRef(ref.revision);
            if (resource != null) {
                resource.urls.add(uri);
                this.index.save(true);
                this.reporter.trace("resource already loaded %s", new Object[]{uri});
                return true;
            }
            this.reporter.trace("adding revision %s", new Object[]{ref});
            this.add(ref);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private Library.RevisionRef analyze(File file, URI uri) throws IllegalArgumentException, IOException {
        try {
            Map map;
            Library.RevisionRef ref;
            Jar jar;
            block22: {
                block21: {
                    Manifest manifest;
                    block20: {
                        jar = new Jar(file);
                        manifest = jar.getManifest();
                        if (manifest != null) break block20;
                        this.reporter.trace("Jar %s has no manifest", new Object[]{uri});
                        Library.RevisionRef revisionRef = null;
                        jar.close();
                        return revisionRef;
                    }
                    Domain domain = Domain.domain((Manifest)manifest);
                    ref = new Library.RevisionRef();
                    ref.created = System.currentTimeMillis();
                    ref.md5 = MD5.digest(file).digest();
                    ref.revision = SHA1.digest(file).digest();
                    ref.phase = Library.Phase.MASTER;
                    ref.size = file.length();
                    ref.urls.add(uri);
                    Map.Entry bsn = domain.getBundleSymbolicName();
                    if (bsn != null) {
                        ref.bsn = (String)bsn.getKey();
                        ref.name = domain.get("Bundle-SymbolicName");
                        ref.version = domain.getBundleVersion();
                        ref.description = domain.get("Bundle-Description");
                        ref.groupId = "osgi";
                        ref.artifactId = ref.bsn;
                    }
                    map = (Map)jar.getDirectories().get("META-INF/maven");
                    if (map.size() == 1) break block21;
                    Library.RevisionRef revisionRef = ref;
                    jar.close();
                    return revisionRef;
                }
                ref.groupId = (String)map.keySet().iterator().next();
                map = (Map)jar.getDirectories().get("META-INF/maven/" + ref.groupId);
                if (map.size() == 1) break block22;
                Library.RevisionRef revisionRef = ref;
                jar.close();
                return revisionRef;
            }
            try {
                Resource r;
                ref.artifactId = (String)map.keySet().iterator().next();
                if (ref.bsn == null) {
                    ref.bsn = ref.groupId + "__" + ref.artifactId;
                }
                if ((r = jar.getResource("META-INF/maven/" + ref.groupId + "/" + ref.artifactId + "/pom.xml")) != null) {
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.parse(r.openInputStream());
                    XPath xp = xpf.newXPath();
                    if (ref.description == null) {
                        ref.description = xp.evaluate("//description", doc);
                    }
                    if (ref.version == null) {
                        ref.version = xp.evaluate("//version", doc);
                    }
                    if (ref.name == null) {
                        ref.name = xp.evaluate("//name", doc);
                    }
                    ref.packaging = xp.evaluate("//packaging", doc);
                    ref.classifier = xp.evaluate("//classifier", doc);
                }
                {
                    catch (Exception e) {
                        this.reporter.trace("parsing maven failed for %s: %s", new Object[]{uri, e});
                    }
                }
                if (ref.version == null) {
                    ref.version = "0";
                }
                if (Verifier.isVersion((String)ref.version)) {
                    Version version = new Version(ref.version);
                    ref.baseline = version.getWithoutQualifier().toString();
                    ref.qualifier = version.getQualifier();
                }
                if (ref.bsn == null) {
                    Pattern JAR_URI_P = Pattern.compile(".*/([^/]+)(?:\\.jar)?", 2);
                    Matcher m = JAR_URI_P.matcher(uri.toString());
                    ref.bsn = m.matches() ? m.group(1) : "unknown";
                }
                Library.RevisionRef revisionRef = ref;
                return revisionRef;
            }
            finally {
                jar.close();
            }
        }
        catch (Exception e) {
            this.reporter.trace("Could not parse JAR %s: %s", new Object[]{uri, e});
            return null;
        }
    }

    void open(String url) {
        try {
            try {
                Desktop desktop = Desktop.getDesktop();
                desktop.browse(new URI(url));
                return;
            }
            catch (Throwable e) {
                String os = System.getProperty("os.name").toLowerCase();
                Runtime rt = Runtime.getRuntime();
                if (os.indexOf("mac") >= 0 || os.indexOf("darwin") >= 0) {
                    rt.exec("open " + url);
                } else if (os.indexOf("win") >= 0) {
                    rt.exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
                    String[] browsers = new String[]{"epiphany", "firefox", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};
                    StringBuffer cmd = new StringBuffer();
                    for (int i = 0; i < browsers.length; ++i) {
                        cmd.append((i == 0 ? "" : " || ") + browsers[i] + " \"" + url + "\" ");
                    }
                    rt.exec(new String[]{"sh", "-c", cmd.toString()});
                } else {
                    this.reporter.trace("Open %s", new Object[]{url});
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Set<SearchableRepository.ResourceDescriptor> getResources(URI url, boolean includeDependencies) throws Exception {
        Matcher m = this.JPM_REVISION_URL_PATTERN.matcher(url.toString());
        if (!m.matches()) {
            return null;
        }
        HashSet<SearchableRepository.ResourceDescriptor> resources = new HashSet<SearchableRepository.ResourceDescriptor>();
        Library.Revision revision = this.getRevision(new Coordinate(m.group(1), m.group(2), m.group(3), m.group(4)));
        if (revision != null) {
            SearchableRepository.ResourceDescriptor rd = this.createResourceDescriptor(new Library.RevisionRef(revision));
            resources.add(rd);
            if (includeDependencies) {
                for (Library.RevisionRef dependency : this.getLibrary().getClosure(revision._id, false)) {
                    SearchableRepository.ResourceDescriptor dep = this.createResourceDescriptor(dependency);
                    dep.dependency = true;
                    resources.add(dep);
                }
            }
        }
        return resources;
    }

    private SearchableRepository.ResourceDescriptor createResourceDescriptor(Library.RevisionRef ref) throws Exception {
        ResourceDescriptorImpl rd = new ResourceDescriptorImpl(ref);
        rd.bsn = ref.bsn;
        rd.version = Repository.toVersion(ref.baseline, ref.qualifier);
        rd.description = ref.description;
        rd.id = ref.revision;
        rd.included = this.getIndex().getRevisionRef(rd.id) != null;
        rd.phase = this.toPhase(ref.phase);
        rd.url = ref.urls.isEmpty() ? null : ref.urls.iterator().next();
        File f = this.get(rd.bsn, rd.version, null, new RepositoryPlugin.DownloadListener[0]);
        rd.sha256 = f != null ? SHA256.digest(f).digest() : SHA256.digest(new byte[0]).digest();
        return rd;
    }

    private Index getIndex() throws Exception {
        this.init();
        return this.index;
    }

    private aQute.bnd.service.repository.Phase toPhase(Library.Phase phase) {
        switch (phase) {
            case STAGING: {
                return aQute.bnd.service.repository.Phase.STAGING;
            }
            case LOCKED: {
                return aQute.bnd.service.repository.Phase.LOCKED;
            }
            case MASTER: {
                return aQute.bnd.service.repository.Phase.MASTER;
            }
            case RETIRED: {
                return aQute.bnd.service.repository.Phase.RETIRED;
            }
            case WITHDRAWN: {
                return aQute.bnd.service.repository.Phase.WITHDRAWN;
            }
        }
        return null;
    }

    public Set<SearchableRepository.ResourceDescriptor> query(String query) throws Exception {
        HashSet<SearchableRepository.ResourceDescriptor> resources = new HashSet<SearchableRepository.ResourceDescriptor>();
        Library.RevisionRef master = null;
        Library.RevisionRef staging = null;
        for (Library.Program p : this.getLibrary().getQueryPrograms(query, 0, 100)) {
            for (Library.RevisionRef ref : p.revisions) {
                if (master == null && ref.phase == Library.Phase.MASTER) {
                    master = ref;
                    continue;
                }
                if (staging == null || ref.phase != Library.Phase.STAGING) continue;
                staging = ref;
            }
            if (master != null) {
                resources.add(this.createResourceDescriptor(master));
            }
            if (staging == null) continue;
            resources.add(this.createResourceDescriptor(staging));
        }
        return resources;
    }

    public boolean addResource(SearchableRepository.ResourceDescriptor resource) throws Exception {
        Library.RevisionRef ref;
        if (resource instanceof ResourceDescriptorImpl && this.index.addRevision(ref = ((ResourceDescriptorImpl)resource).revision)) {
            this.index.save();
            return true;
        }
        return false;
    }

    public Set<SearchableRepository.ResourceDescriptor> findResources(Requirement requirement, boolean includeDependencies) throws Exception {
        FilterParser fp = new FilterParser();
        FilterParser.Expression expression = fp.parse(requirement.getDirectives().get("filter"));
        String query = expression.query();
        if (query == null) {
            return Collections.emptySet();
        }
        return this.query(query);
    }

    public URI browse(String searchString) throws Exception {
        if (searchString == null) {
            return this.url;
        }
        return this.url.resolve(SEARCH_PREFIX + URLEncoder.encode(searchString, UTF_8));
    }

    private boolean isConnected() throws SocketException {
        if (this.offline) {
            return false;
        }
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface interf = e.nextElement();
                if (interf.isLoopback() || !interf.isUp()) continue;
                return true;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return false;
    }

    private Library.Program getProgram(String bsn, boolean force) throws Exception {
        Library.Program p = this.getCache().getProgram(bsn);
        if ((p == null || force) && (p = this.getLibrary().getProgram("osgi", bsn)) != null) {
            this.getCache().putProgram(bsn, p);
        }
        return p;
    }

    private Library.Revision getRevision(Coordinate c) throws Exception {
        return this.getLibrary().getRevisionByCoordinate(c);
    }

    public byte[] getDigest() throws Exception {
        this.init();
        return this.index.getRevisions()._id;
    }

    byte[] sync() throws Exception {
        Revisions revisions = this.index.getRevisions();
        if (!this.index.isSynced()) {
            this.reporter.trace("Syncing repo indexes", new Object[0]);
            this.getLibrary().createRevisions(revisions);
            this.index.setSynced(revisions._id);
        }
        return revisions._id;
    }

    public SortedSet<Version> update(SortedSet<Version> input, Library.Program p) throws Exception {
        Version mask;
        HashMap<Version, Version> mapped = new HashMap<Version, Version>();
        for (Library.RevisionRef ref : p.revisions) {
            Version a = Repository.toVersion(ref.baseline, ref.qualifier);
            mask = Repository.mask(a);
            Version highest = (Version)mapped.get(mask);
            if (highest != null && a.compareTo(highest) <= 0 && ref.phase != Library.Phase.MASTER) continue;
            mapped.put(mask, a);
        }
        HashSet<Version> output = new HashSet<Version>();
        for (Version i : input) {
            mask = Repository.mask(i);
            Version found = (Version)mapped.get(mask);
            if (found != null) {
                output.add(found);
                continue;
            }
            this.reporter.error("[update] Missing version %s for bsn %s", new Object[]{mask, p.last.bsn});
        }
        return new SortedList<Version>((Collection<Comparable<?>>)output);
    }

    private static Version mask(Version in) {
        return new Version(in.getMajor(), in.getMinor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUp() throws Exception {
        Workspace workspace = (Workspace)this.registry.getPlugin(Workspace.class);
        HashSet set = new HashSet();
        for (Project project : workspace.getAllProjects()) {
            set.addAll(project.getBuildpath());
            set.addAll(project.getRunbundles());
            set.addAll(project.getRunpath());
            set.addAll(project.getTestpath());
            set.addAll(project.getBootclasspath());
            set.addAll(project.getClasspath());
            String s = project.getProperty("-runfw");
            List bundles = project.getBundles(Strategy.HIGHEST, s, "-runfw");
            set.addAll(bundles);
            File base = project.getBase();
            for (File sub : base.listFiles()) {
                if (!sub.getName().endsWith(".bndrun")) continue;
                try (Project bndrun = new Project(workspace, base, sub);){
                    set.addAll(bndrun.getRunbundles());
                    set.addAll(bndrun.getRunpath());
                    set.addAll(bndrun.getTestpath());
                    set.addAll(bndrun.getBootclasspath());
                    set.addAll(bndrun.getClasspath());
                }
            }
        }
        HashSet<Library.RevisionRef> refs = new HashSet<Library.RevisionRef>(this.index.getRevisionRefs());
        HashSet<Library.RevisionRef> keep = new HashSet<Library.RevisionRef>();
        for (Container libOrRev : set) {
            for (Container c : libOrRev.getMembers()) {
                this.reporter.trace("Dependency %s", new Object[]{c});
                if (!Verifier.isVersion((String)c.getVersion())) continue;
                Library.RevisionRef ref = this.index.getRevisionRef(c.getBundleSymbolicName(), new Version(c.getVersion()));
                if (ref != null) {
                    refs.remove(ref);
                } else {
                    this.reporter.trace("Missing %s", new Object[]{c.getBundleSymbolicName()});
                    Coordinate coord = new Coordinate(c.getBundleSymbolicName());
                    Library.Revision rev = this.getLibrary().getRevisionByCoordinate(coord);
                    if (rev != null) {
                        this.index.addRevision(new Library.RevisionRef(rev));
                    } else {
                        System.out.printf("not found %s\n", c);
                    }
                }
                keep.add(ref);
            }
        }
        for (Library.RevisionRef ref : refs) {
            this.index.delete(ref.bsn, Index.toVersion(ref));
        }
        this.index.save();
    }

    public SearchableRepository.ResourceDescriptor getDescriptor(String bsn, Version version) throws Exception {
        this.init();
        Library.RevisionRef revisionRef = this.index.getRevisionRef(bsn, version);
        if (revisionRef == null) {
            return null;
        }
        return this.createResourceDescriptor(revisionRef);
    }

    void toClipboard(String bsn, Version base) {
        Version nextMajor = new Version(base.getMajor() + 1, 0, 0);
        this.toClipboard(bsn + ";version='[" + base.getWithoutQualifier() + "," + nextMajor + ")'");
    }

    void toClipboard(String s) {
        if (s == null) {
            return;
        }
        StringSelection stringSelection = new StringSelection(s);
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        clpbrd.setContents(stringSelection, null);
    }

    public String toString() {
        byte[] digest;
        try {
            digest = this.getDigest();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "JpmRepository [writable=" + this.canWrite() + ", " + (this.getName() != null ? "name=" + this.getName() + ", " : "") + (this.getLocation() != null ? "location=" + this.getLocation() + ", " : "") + (digest != null ? "digest=" + Hex.toHexString(digest) : "") + "]";
    }

    public JpmRepo getLibrary() throws URISyntaxException, Exception {
        if (this.libraryx == null) {
            this.libraryx = JSONRPCProxy.createRPC(JpmRepo.class, this.httpClient, new URI(this.url.toString() + "/" + "jsonrpc/2.0/" + "jpm"));
        }
        return this.libraryx;
    }

    private StoredRevisionCache getCache() throws Exception {
        if (this.cachex == null) {
            this.cachex = new StoredRevisionCache(this.cacheDir, this.settings, this.httpClient);
        }
        return this.cachex;
    }

    static enum Phase {
        STAGING(false, false, false, "[s]"),
        LOCKED(true, false, false, "[l]"),
        MASTER(true, true, true, "[m]"),
        RETIRED(true, false, true, "[r]"),
        WITHDRAWN(true, false, true, "[x]"),
        UNKNOWN(true, false, false, "[?]");

        boolean locked;
        boolean listable;
        boolean permanent;
        final String symbol;

        private Phase(boolean locked, boolean listable, boolean permanent, String symbol) {
            this.locked = locked;
            this.listable = listable;
            this.permanent = permanent;
            this.symbol = symbol;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public boolean isListable() {
            return this.listable;
        }

        public boolean isPermanent() {
            return this.permanent;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }

    static interface Options {
        public URI url();

        public String depository_group();

        public String depository_name();

        public String email();

        public String index();

        public String location();

        public String settings();

        public String name();

        public boolean recurse();

        public boolean trace();

        public boolean crawl();
    }

    class LocalDownloadListener
    implements RepositoryPlugin.DownloadListener {
        LocalDownloadListener() {
        }

        public void success(File file) throws Exception {
            Repository.this.reporter.trace("downloaded %s", new Object[]{file});
        }

        public void failure(File file, String reason) throws Exception {
            Repository.this.reporter.trace("failed to downloaded %s", new Object[]{file});
        }

        public boolean progress(File file, int percentage) throws Exception {
            Repository.this.reporter.trace("Downloading %s %s%%", new Object[]{file, percentage});
            return true;
        }
    }
}

