/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.jpm;

import aQute.bnd.version.Version;
import aQute.lib.converter.TypeReference;
import aQute.lib.io.IO;
import aQute.lib.json.Decoder;
import aQute.lib.json.JSONCodec;
import aQute.libg.reporter.ReporterAdapter;
import aQute.service.library.Library;
import aQute.service.library.Revisions;
import aQute.service.reporter.Reporter;
import aQute.struct.struct;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Index {
    Reporter reporter = new ReporterAdapter(System.out);
    private static final SortedSet<Version> EMPTY_VERSIONS = Collections.unmodifiableSortedSet(new TreeSet());
    private File indexFile;
    private Map<String, TreeMap<Version, Library.RevisionRef>> cache;
    private Repo repo;
    static final JSONCodec codec = new JSONCodec();
    private boolean dirty;

    public Index(File file) {
        this.indexFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws Exception {
        if (this.repo == null) {
            this.cache = new TreeMap<String, TreeMap<Version, Library.RevisionRef>>();
            if (this.indexFile.isFile() && this.indexFile.length() > 100L) {
                try (Decoder dec = codec.dec();){
                    this.repo = dec.from(this.indexFile).get(new TypeReference<Repo>(){});
                    for (Library.RevisionRef r : this.repo.revisionRefs) {
                        TreeMap<Object, Library.RevisionRef> map = this.cache.get(r.bsn);
                        if (map == null) {
                            map = new TreeMap(Collections.reverseOrder());
                            this.cache.put(r.bsn, map);
                        }
                        Version v = Index.toVersion(r.baseline, r.qualifier);
                        map.put(v, r);
                    }
                }
            } else {
                this.repo = new Repo();
            }
        }
    }

    public Set<String> getBsns() throws Exception {
        this.init();
        return this.cache.keySet();
    }

    public SortedSet<Version> getVersions(String bsn) throws Exception {
        this.init();
        TreeMap<Version, Library.RevisionRef> map = this.cache.get(bsn);
        if (map == null) {
            return EMPTY_VERSIONS;
        }
        return map.navigableKeySet();
    }

    public boolean addRevision(Library.RevisionRef ref) throws Exception {
        this.init();
        Version v = Index.toVersion(ref.baseline, ref.qualifier);
        TreeMap<Object, Library.RevisionRef> map = this.cache.get(ref.bsn);
        if (map == null) {
            map = new TreeMap();
            this.cache.put(ref.bsn, map);
        }
        map.put(v, ref);
        this.dirty = true;
        this.repo.revisionRefs.add(ref);
        return true;
    }

    public Library.RevisionRef getRevisionRef(String bsn, Version version) throws Exception {
        this.init();
        Map map = this.cache.get(bsn);
        if (map == null) {
            return null;
        }
        boolean save = false;
        Library.RevisionRef ref = (Library.RevisionRef)map.get(version);
        if (ref == null) {
            return null;
        }
        if (ref.urls.isEmpty() && ref.url != null) {
            ref.urls.add(ref.url);
            ref.url = null;
            save = true;
        }
        if (!Boolean.getBoolean("jpm4j.in.test")) {
            Iterator<URI> i = ref.urls.iterator();
            while (i.hasNext()) {
                URI uri = i.next();
                if (!uri.getScheme().equalsIgnoreCase("file")) continue;
                i.remove();
                save = true;
            }
        }
        if (save) {
            this.save();
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String bsn, Version v) throws Exception {
        this.init();
        Map map = this.cache.get(bsn);
        if (map != null) {
            try {
                Library.RevisionRef removed = (Library.RevisionRef)map.remove(v);
                if (removed != null) {
                    Iterator<Library.RevisionRef> i = this.repo.revisionRefs.iterator();
                    while (i.hasNext()) {
                        Library.RevisionRef other = i.next();
                        if (!Arrays.equals(other.revision, removed.revision)) continue;
                        i.remove();
                    }
                    this.repo.revisionRefs.remove(removed);
                    this.dirty = true;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (map.isEmpty()) {
                    this.cache.remove(bsn);
                }
            }
        }
        return false;
    }

    public void save(Writer out) throws Exception {
        this.init();
        this.repo.revisionRefs = this.getRevisionRefs();
        Formatter f = new Formatter(out);
        this.repo.write(f);
    }

    public void save(OutputStream out) throws Exception {
        this.save(new OutputStreamWriter(out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File out) throws Exception {
        File tmp = IO.createTempFile(out.getParentFile(), out.getName(), ".tmp");
        try (FileWriter fout = new FileWriter(tmp);){
            this.save(fout);
        }
        IO.rename(tmp, out);
    }

    public void save() throws Exception {
        this.save(false);
    }

    void save(boolean force) throws Exception {
        if (this.dirty || force) {
            this.save(this.indexFile);
        }
        this.dirty = false;
    }

    static Version toVersion(String baseline, String qualifier) {
        if (qualifier == null || qualifier.isEmpty()) {
            return new Version(baseline);
        }
        return new Version(baseline + "." + qualifier);
    }

    public static Version toVersion(Library.RevisionRef ref) {
        return Index.toVersion(ref.baseline, ref.qualifier);
    }

    public Library.RevisionRef getRevisionRef(byte[] sha) throws Exception {
        this.init();
        for (SortedMap sortedMap : this.cache.values()) {
            for (Library.RevisionRef r : sortedMap.values()) {
                if (!Arrays.equals(sha, r.revision)) continue;
                return r;
            }
        }
        return null;
    }

    public List<Library.RevisionRef> getRevisionRefs() throws Exception {
        this.init();
        ArrayList<Library.RevisionRef> refs = new ArrayList<Library.RevisionRef>();
        for (SortedMap sortedMap : this.cache.values()) {
            refs.addAll(sortedMap.values());
        }
        return refs;
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public boolean isLearning() throws Exception {
        this.init();
        return this.repo.learning;
    }

    public void setLearning(boolean learning) {
        this.dirty |= this.repo.learning != learning;
        this.repo.learning = learning;
    }

    public boolean isRecurse() {
        return this.repo.recurse;
    }

    public void setRecurse(boolean recurse) throws Exception {
        this.init();
        this.dirty |= this.repo.recurse != recurse;
        this.repo.recurse = recurse;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public Revisions getRevisions() throws Exception {
        this.init();
        Revisions revisions = new Revisions();
        for (Library.RevisionRef ref : this.repo.revisionRefs) {
            revisions.content.add(ref.revision);
        }
        revisions._id = Revisions.checksum(revisions);
        return revisions;
    }

    public boolean isSynced() throws Exception {
        this.init();
        return this.repo.synced != null && Arrays.equals(this.repo.synced, this.getRevisions()._id);
    }

    public byte[] getSynced() {
        return this.repo.synced;
    }

    public void setSynced(byte[] revisions) throws Exception {
        this.repo.synced = revisions;
        this.save();
    }

    public static class Repo
    extends struct {
        public List<Library.RevisionRef> revisionRefs = Repo.list();
        public boolean learning = true;
        public boolean recurse = false;
        byte[] synced;

        void write(Formatter format) throws Exception {
            codec.enc().indent(" ").to(format.out()).put(this);
            format.flush();
        }
    }
}

