/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.deployer.repository;

import aQute.bnd.deployer.http.DefaultURLConnector;
import aQute.bnd.deployer.repository.CachingUriResourceHandle;
import aQute.bnd.deployer.repository.CapabilityIndex;
import aQute.bnd.deployer.repository.NullLogService;
import aQute.bnd.deployer.repository.RepoResourceUtils;
import aQute.bnd.deployer.repository.ReporterLogService;
import aQute.bnd.deployer.repository.VersionedResourceIndex;
import aQute.bnd.deployer.repository.api.IRepositoryContentProvider;
import aQute.bnd.deployer.repository.api.IRepositoryIndexProcessor;
import aQute.bnd.deployer.repository.api.Referral;
import aQute.bnd.deployer.repository.providers.ObrContentProvider;
import aQute.bnd.deployer.repository.providers.R5RepoContentProvider;
import aQute.bnd.osgi.repository.BaseRepository;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.service.IndexProvider;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.RemoteRepositoryPlugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.ResolutionPhase;
import aQute.bnd.service.ResourceHandle;
import aQute.bnd.service.Strategy;
import aQute.bnd.service.url.URLConnector;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.lib.filter.Filter;
import aQute.lib.strings.Strings;
import aQute.libg.glob.Glob;
import aQute.libg.gzip.GZipUtils;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.osgi.impl.bundle.bindex.BundleIndexerImpl;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.bindex.BundleIndexer;
import org.osgi.service.log.LogService;
import org.osgi.service.repository.Repository;

public abstract class AbstractIndexedRepo
extends BaseRepository
implements RegistryPlugin,
Plugin,
RemoteRepositoryPlugin,
IndexProvider,
Repository,
Refreshable {
    private static final String SHA_256 = "SHA-256";
    public static final String PROP_NAME = "name";
    public static final String PROP_REPO_TYPE = "type";
    public static final String PROP_RESOLUTION_PHASE = "phase";
    public static final String PROP_RESOLUTION_PHASE_ANY = "any";
    public static final String REPO_TYPE_R5 = "R5";
    public static final String REPO_TYPE_OBR = "OBR";
    public static final String REPO_INDEX_SHA_EXTENSION = ".sha";
    public static final String PROP_CACHE_TIMEOUT = "timeout";
    public static final String PROP_ONLINE = "online";
    public static final String PROP_VERSION_KEY = "version";
    public static final String PROP_VERSION_HASH = "hash";
    public static final String PROP_CHECK_BSN = "bsn";
    private static final int DEFAULT_CACHE_TIMEOUT = 5;
    private final BundleIndexer obrIndexer = new BundleIndexerImpl();
    protected final Map<String, IRepositoryContentProvider> allContentProviders = new TreeMap<String, IRepositoryContentProvider>();
    protected final List<IRepositoryContentProvider> generatingProviders = new LinkedList<IRepositoryContentProvider>();
    protected Registry registry;
    protected Reporter reporter;
    protected LogService logService = new NullLogService();
    protected String name = ((Object)((Object)this)).getClass().getName();
    protected Set<ResolutionPhase> supportedPhases = EnumSet.allOf(ResolutionPhase.class);
    private List<URI> indexLocations;
    private String requestedContentProviderList = null;
    private boolean initialised = false;
    private final CapabilityIndex capabilityIndex = new CapabilityIndex();
    private final VersionedResourceIndex identityMap = new VersionedResourceIndex();
    private int cacheTimeoutSeconds = 5;
    private boolean online = true;

    protected AbstractIndexedRepo() {
        this.allContentProviders.put(REPO_TYPE_R5, new R5RepoContentProvider());
        this.allContentProviders.put(REPO_TYPE_OBR, new ObrContentProvider(this.obrIndexer));
        this.generatingProviders.add(this.allContentProviders.get(REPO_TYPE_R5));
    }

    public synchronized void reset() {
        this.initialised = false;
    }

    private synchronized void clear() {
        this.identityMap.clear();
        this.capabilityIndex.clear();
    }

    protected abstract List<URI> loadIndexes() throws Exception;

    protected synchronized void loadAllContentProviders() {
        if (this.registry == null) {
            return;
        }
        List extraProviders = this.registry.getPlugins(IRepositoryContentProvider.class);
        for (IRepositoryContentProvider provider : extraProviders) {
            String providerName = provider.getName();
            if (this.allContentProviders.containsKey(providerName)) {
                this.warning("Repository content provider with name \"%s\" is already registered.", providerName);
                continue;
            }
            this.allContentProviders.put(providerName, provider);
        }
    }

    protected final void init() throws Exception {
        this.init(false);
    }

    protected final synchronized void init(boolean ignoreCachedFile) throws Exception {
        if (!this.initialised) {
            this.clear();
            this.loadAllContentProviders();
            if (this.requestedContentProviderList != null && this.requestedContentProviderList.length() > 0) {
                this.generatingProviders.clear();
                StringTokenizer tokenizer = new StringTokenizer(this.requestedContentProviderList, "|");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken().trim();
                    IRepositoryContentProvider provider = this.allContentProviders.get(token);
                    if (provider == null) {
                        this.warning("Unknown repository content provider \"%s\".", token);
                        continue;
                    }
                    this.generatingProviders.add(provider);
                }
                if (this.generatingProviders.isEmpty()) {
                    this.warning("No valid repository index generators were found, requested list was: [%s]", this.requestedContentProviderList);
                }
            }
            this.indexLocations = this.loadIndexes();
            final URLConnector connector = this.getConnector();
            IRepositoryIndexProcessor processor = new IRepositoryIndexProcessor(){

                @Override
                public void processResource(Resource resource) {
                    AbstractIndexedRepo.this.identityMap.put(resource);
                    AbstractIndexedRepo.this.capabilityIndex.addResource(resource);
                }

                @Override
                public void processReferral(URI parentUri, Referral referral, int maxDepth, int currentDepth) {
                    try {
                        URI indexLocation = new URI(referral.getUrl());
                        try {
                            CachingUriResourceHandle indexHandle = new CachingUriResourceHandle(indexLocation, AbstractIndexedRepo.this.getCacheDirectory(), connector, null);
                            indexHandle.setReporter(AbstractIndexedRepo.this.reporter);
                            InputStream indexStream = GZipUtils.detectCompression(new FileInputStream(indexHandle.request()));
                            RepoResourceUtils.readIndex(indexLocation.getPath(), indexLocation, indexStream, AbstractIndexedRepo.this.allContentProviders.values(), this, AbstractIndexedRepo.this.logService);
                        }
                        catch (Exception e) {
                            AbstractIndexedRepo.this.warning("Unable to read referral index at URL '%s' from parent index '%s': %s", new Object[]{indexLocation, parentUri, e});
                        }
                    }
                    catch (URISyntaxException e) {
                        AbstractIndexedRepo.this.warning("Invalid referral URL '%s' from parent index '%s': %s", new Object[]{referral.getUrl(), parentUri, e});
                    }
                }
            };
            for (URI indexLocation : this.indexLocations) {
                try {
                    CachingUriResourceHandle indexHandle = new CachingUriResourceHandle(indexLocation, this.getCacheDirectory(), connector, null);
                    if (!(indexHandle.cachedFile == null || ignoreCachedFile || System.currentTimeMillis() - indexHandle.cachedFile.lastModified() >= (long)(this.cacheTimeoutSeconds * 1000) && this.online)) {
                        indexHandle.sha = indexHandle.getCachedSHA();
                        if (indexHandle.sha != null && !this.online) {
                            System.out.println(String.format("Offline. Using cached %s.", indexLocation));
                        }
                    }
                    indexHandle.setReporter(this.reporter);
                    File indexFile = indexHandle.request();
                    InputStream indexStream = GZipUtils.detectCompression(new FileInputStream(indexFile));
                    RepoResourceUtils.readIndex(indexFile.getName(), indexLocation, indexStream, this.allContentProviders.values(), processor, this.logService);
                }
                catch (Exception e) {
                    this.error("Unable to read index at URL '%s': %s", indexLocation, e);
                }
            }
            this.initialised = true;
        }
    }

    public final List<URI> getIndexLocations() throws Exception {
        this.init();
        return Collections.unmodifiableList(this.indexLocations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLConnector getConnector() {
        URLConnector connector;
        AbstractIndexedRepo abstractIndexedRepo = this;
        synchronized (abstractIndexedRepo) {
            connector = this.registry != null ? (URLConnector)this.registry.getPlugin(URLConnector.class) : null;
        }
        if (connector == null) {
            DefaultURLConnector defaultConnector = new DefaultURLConnector();
            defaultConnector.setRegistry(this.registry);
            connector = defaultConnector;
        }
        return connector;
    }

    public final synchronized void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public synchronized void setProperties(Map<String, String> map) {
        if (map.containsKey(PROP_NAME)) {
            this.name = map.get(PROP_NAME);
        }
        if (map.containsKey(PROP_RESOLUTION_PHASE)) {
            this.supportedPhases = EnumSet.noneOf(ResolutionPhase.class);
            StringTokenizer tokenizer = new StringTokenizer(map.get(PROP_RESOLUTION_PHASE), ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (PROP_RESOLUTION_PHASE_ANY.equalsIgnoreCase(token)) {
                    this.supportedPhases = EnumSet.allOf(ResolutionPhase.class);
                    continue;
                }
                try {
                    this.supportedPhases.add(ResolutionPhase.valueOf((String)token));
                }
                catch (Exception e) {
                    this.error("Unknown OBR resolution mode: " + token, new Object[0]);
                }
            }
        }
        if (map.containsKey(PROP_CACHE_TIMEOUT)) {
            try {
                this.cacheTimeoutSeconds = Integer.parseInt(map.get(PROP_CACHE_TIMEOUT));
            }
            catch (NumberFormatException e) {
                this.error("Bad timeout setting. Must be integer number of milliseconds.", new Object[0]);
            }
        }
        if (map.containsKey(PROP_ONLINE)) {
            this.online = Boolean.parseBoolean(map.get(PROP_ONLINE));
        }
        this.requestedContentProviderList = map.get(PROP_REPO_TYPE);
    }

    public File[] get(String bsn, String range) throws Exception {
        ResourceHandle[] handles = this.getHandles(bsn, range);
        return AbstractIndexedRepo.requestAll(handles);
    }

    protected static File[] requestAll(ResourceHandle[] handles) throws Exception {
        File[] result;
        if (handles == null) {
            result = new File[]{};
        } else {
            result = new File[handles.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = handles[i].request();
            }
        }
        return result;
    }

    protected ResourceHandle[] getHandles(String bsn, String rangeStr) throws Exception {
        this.init();
        if ("project".equals(rangeStr)) {
            return null;
        }
        List<Resource> resources = this.identityMap.getRange(bsn, rangeStr);
        List<ResourceHandle> handles = this.mapResourcesToHandles(resources);
        return handles.toArray(new ResourceHandle[0]);
    }

    public synchronized void setReporter(Reporter reporter) {
        this.reporter = reporter;
        this.logService = new ReporterLogService(reporter);
    }

    public File get(String bsn, String range, Strategy strategy, Map<String, String> properties) throws Exception {
        ResourceHandle handle = this.getHandle(bsn, range, strategy, properties);
        return handle != null ? handle.request() : null;
    }

    public ResourceHandle getHandle(String bsn, String range, Strategy strategy, Map<String, String> properties) throws Exception {
        this.init();
        if (bsn == null) {
            throw new IllegalArgumentException("Cannot resolve bundle: bundle symbolic name not specified.");
        }
        ResourceHandle result = this.resolveBundle(bsn, range, strategy, properties);
        return result;
    }

    public boolean canWrite() {
        return false;
    }

    public RepositoryPlugin.PutResult put(InputStream stream, RepositoryPlugin.PutOptions options) throws Exception {
        throw new UnsupportedOperationException("Read-only repository.");
    }

    public List<String> list(String pattern) throws Exception {
        this.init();
        Glob glob = pattern != null ? new Glob(pattern) : null;
        LinkedList<String> result = new LinkedList<String>();
        for (String bsn : this.identityMap.getIdentities()) {
            if (glob != null && !glob.matcher(bsn).matches()) continue;
            result.add(bsn);
        }
        return result;
    }

    public SortedSet<Version> versions(String bsn) throws Exception {
        this.init();
        return this.identityMap.getVersions(bsn);
    }

    public synchronized String getName() {
        return this.name;
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
        for (Requirement requirement : requirements) {
            LinkedList matches = new LinkedList();
            result.put(requirement, matches);
            this.capabilityIndex.appendMatchingCapabilities(requirement, matches);
        }
        return result;
    }

    static List<Resource> narrowVersionsByFilter(String pkgName, SortedMap<Version, Resource> versionMap, Filter filter) throws Exception {
        ArrayList<Resource> result = new ArrayList<Resource>(versionMap.size());
        Hashtable<String, String> dict = new Hashtable<String, String>();
        ((Dictionary)dict).put("package", pkgName);
        for (Map.Entry<Version, Resource> entry : versionMap.entrySet()) {
            ((Dictionary)dict).put(PROP_VERSION_KEY, entry.getKey().toString());
            if (!filter.match(dict)) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    List<ResourceHandle> mapResourcesToHandles(Collection<Resource> resources) throws Exception {
        ArrayList<ResourceHandle> result = new ArrayList<ResourceHandle>(resources.size());
        for (Resource resource : resources) {
            ResourceHandle handle = this.mapResourceToHandle(resource);
            if (handle == null) continue;
            result.add(handle);
        }
        return result;
    }

    ResourceHandle mapResourceToHandle(Resource resource) throws Exception {
        CachingUriResourceHandle handle;
        CachingUriResourceHandle result = null;
        try {
            String contentSha = RepoResourceUtils.getContentSha(resource);
            handle = new CachingUriResourceHandle(RepoResourceUtils.getContentUrl(resource), this.getCacheDirectory(), this.getConnector(), contentSha);
            if (contentSha == null) {
                handle.sha = handle.getCachedSHA();
            }
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("Broken link in repository index: " + e);
        }
        if (handle.getLocation() == ResourceHandle.Location.local || this.getCacheDirectory() != null) {
            result = handle;
        }
        return result;
    }

    ResourceHandle resolveBundle(String bsn, String rangeStr, Strategy strategy, Map<String, String> properties) throws Exception {
        ResourceHandle selected;
        if (rangeStr == null) {
            rangeStr = "0.0.0";
        }
        if (PROP_VERSION_HASH.equals(rangeStr)) {
            return this.findByHash(bsn, properties);
        }
        if (strategy == Strategy.EXACT) {
            return this.findExactMatch(bsn, rangeStr);
        }
        ResourceHandle[] handles = this.getHandles(bsn, rangeStr);
        if (handles == null || handles.length == 0) {
            selected = null;
        } else {
            switch (strategy) {
                case LOWEST: {
                    selected = handles[0];
                    break;
                }
                default: {
                    selected = handles[handles.length - 1];
                }
            }
        }
        return selected;
    }

    static String listToString(List<?> list) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (Object item : list) {
            if (count++ > 0) {
                builder.append(',');
            }
            builder.append(item);
        }
        return builder.toString();
    }

    ResourceHandle findExactMatch(String identity, String version) throws Exception {
        VersionRange range = new VersionRange(version);
        if (range.isRange()) {
            return null;
        }
        Resource resource = this.identityMap.getExact(identity, range.getLow());
        if (resource == null) {
            return null;
        }
        return this.mapResourceToHandle(resource);
    }

    ResourceHandle findByHash(String bsn, Map<String, String> properties) throws Exception {
        if (bsn == null) {
            throw new IllegalArgumentException("Bundle symbolic name must be specified");
        }
        String hashStr = properties.get(PROP_VERSION_HASH);
        if (hashStr == null) {
            throw new IllegalArgumentException("Content hash must be provided (using hash=<algo>:<hash>) when version=hash is specified");
        }
        String algo = SHA_256;
        int colonIndex = hashStr.indexOf(58);
        if (colonIndex > -1) {
            algo = hashStr.substring(0, colonIndex);
            int afterColon = colonIndex + 1;
            String string = hashStr = colonIndex < hashStr.length() ? hashStr.substring(afterColon) : "";
        }
        if (!SHA_256.equalsIgnoreCase(algo)) {
            return null;
        }
        String contentFilter = String.format("(%s=%s)", "osgi.content", hashStr);
        Requirement contentReq = new CapReqBuilder("osgi.content").filter(contentFilter).buildSyntheticRequirement();
        LinkedList caps = new LinkedList();
        this.capabilityIndex.appendMatchingCapabilities(contentReq, caps);
        if (caps.isEmpty()) {
            return null;
        }
        Resource resource = ((Capability)caps.get(0)).getResource();
        Capability identityCap = RepoResourceUtils.getIdentityCapability(resource);
        Object id = identityCap.getAttributes().get("osgi.identity");
        if (!bsn.equals(id)) {
            throw new IllegalArgumentException(String.format("Resource with requested hash does not match ID '%s' [hash: %s]", bsn, hashStr));
        }
        return this.mapResourceToHandle(resource);
    }

    protected static List<URI> parseLocations(String locationsStr) throws MalformedURLException, URISyntaxException {
        StringTokenizer tok = new StringTokenizer(locationsStr, ",");
        ArrayList<URI> urls = new ArrayList<URI>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            String urlStr = tok.nextToken().trim();
            urls.add(new URL(urlStr).toURI());
        }
        return urls;
    }

    public Set<ResolutionPhase> getSupportedPhases() {
        return this.supportedPhases;
    }

    public String toString() {
        return this.getName();
    }

    public File get(String bsn, Version version, Map<String, String> properties, RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        this.init();
        String versionStr = version != null ? version.toString() : properties.get(PROP_VERSION_KEY);
        ResourceHandle handle = this.resolveBundle(bsn, versionStr, Strategy.EXACT, properties);
        if (handle == null) {
            return null;
        }
        File f = handle.request();
        if (f == null) {
            return null;
        }
        for (RepositoryPlugin.DownloadListener l : listeners) {
            try {
                l.success(f);
            }
            catch (Exception e) {
                this.error("Download listener for %s: %s", f, e);
            }
        }
        return f;
    }

    private void error(String format, Object ... args) {
        if (this.reporter != null) {
            this.reporter.error(format, args);
        } else {
            System.err.println(Strings.format(format, args));
        }
    }

    private void warning(String format, Object ... args) {
        if (this.reporter != null) {
            this.reporter.warning(format, args);
        } else {
            System.err.println(Strings.format(format, args));
        }
    }

    public boolean refresh() throws Exception {
        this.initialised = false;
        this.init(true);
        return true;
    }
}

