/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.deployer.obr;

import aQute.bnd.deployer.repository.AbstractIndexedRepo;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.version.Version;
import aQute.lib.base64.Base64;
import aQute.lib.io.IO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class NexusOBR
extends AbstractIndexedRepo {
    static final int BUFFER_SIZE = 8192;
    private static final String DEFAULT_PASSWORD = "deployment123";
    private static final String DEFAULT_USERNAME = "deployment";
    private static final String EMPTY_REPOSITORY_URL = "";
    private static final String DEFAULT_CACHE_DIR = ".bnd" + File.separator + "cache";
    public static final String PROP_CACHE = "cache";
    public static final String PROP_REPOSITORY_URL = "repositoryUrl";
    public static final String PROP_READONLY = "readonly";
    public static final String PROP_USERNAME = "username";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_PUTURL = "puturl";
    protected File cacheDir = new File(System.getProperty("user.home") + File.separator + DEFAULT_CACHE_DIR);
    private String nexusRepositoryUrl;
    private boolean readOnly;
    private String username = "deployment";
    private String password = "deployment123";
    private String puturl = null;

    @Override
    public synchronized void setProperties(Map<String, String> map) {
        String cachePath;
        super.setProperties(map);
        this.readOnly = Boolean.parseBoolean(map.get(PROP_READONLY));
        if (map.containsKey(PROP_USERNAME)) {
            this.username = map.get(PROP_USERNAME);
        }
        if (map.containsKey(PROP_PASSWORD)) {
            this.password = map.get(PROP_PASSWORD);
        }
        this.nexusRepositoryUrl = map.get(PROP_REPOSITORY_URL);
        if (this.nexusRepositoryUrl != null && !this.nexusRepositoryUrl.endsWith("/")) {
            this.nexusRepositoryUrl = this.nexusRepositoryUrl + '/';
        }
        if (map.containsKey(PROP_PUTURL)) {
            this.puturl = map.get(PROP_PUTURL);
        }
        if (this.puturl != null && !this.puturl.endsWith("/")) {
            this.puturl = this.puturl + '/';
        }
        if ((cachePath = map.get(PROP_CACHE)) != null) {
            this.cacheDir = new File(cachePath);
            if (!this.cacheDir.isDirectory()) {
                try {
                    throw new IllegalArgumentException(String.format("Cache path '%s' does not exist, or is not a directory.", this.cacheDir.getCanonicalPath()));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not get cacheDir canonical path", e);
                }
            }
        }
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    public File getCacheDirectory() {
        return this.cacheDir;
    }

    public String getLocation() {
        if (this.nexusRepositoryUrl == null) {
            return EMPTY_REPOSITORY_URL;
        }
        return this.nexusRepositoryUrl;
    }

    @Override
    protected List<URI> loadIndexes() throws Exception {
        List<URI> result;
        if (this.nexusRepositoryUrl != null) {
            result = new ArrayList();
            result.add(new URL(this.nexusRepositoryUrl + ".meta/obr.xml").toURI());
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    public void setCacheDirectory(File cacheDir) {
        if (cacheDir == null) {
            throw new IllegalArgumentException("null cache directory not permitted");
        }
        this.cacheDir = cacheDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized RepositoryPlugin.PutResult put(InputStream stream, RepositoryPlugin.PutOptions options) throws Exception {
        if (this.readOnly) {
            throw new IOException("Repository is read-only");
        }
        if (options == null) {
            options = DEFAULTOPTIONS;
        }
        if (stream == null) {
            throw new IllegalArgumentException("No stream and/or options specified");
        }
        DigestInputStream dis = new DigestInputStream(stream, MessageDigest.getInstance("SHA-1"));
        File tmpFile = null;
        try {
            tmpFile = IO.createTempFile(null, "put", ".bnd");
            IO.copy((InputStream)dis, tmpFile);
            byte[] disDigest = dis.getMessageDigest().digest();
            if (options.digest != null && !Arrays.equals(options.digest, disDigest)) {
                throw new IOException("Retrieved artifact digest doesn't match specified digest");
            }
            URL url = this.putArtifact(tmpFile);
            RepositoryPlugin.PutResult result = new RepositoryPlugin.PutResult();
            if (url != null) {
                result.digest = disDigest;
                result.artifact = url.toURI();
            }
            RepositoryPlugin.PutResult putResult = result;
            return putResult;
        }
        finally {
            if (tmpFile != null && tmpFile.exists()) {
                IO.delete(tmpFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL putArtifact(File tmpFile) throws Exception {
        Version version;
        String bsn;
        assert (tmpFile != null);
        assert (tmpFile.isFile());
        this.init();
        try (Jar jar = new Jar(tmpFile);){
            bsn = jar.getBsn();
            if (bsn == null || !Verifier.isBsn((String)bsn)) {
                throw new IllegalArgumentException("Jar does not have a Bundle-SymbolicName manifest header");
            }
            String versionString = jar.getVersion();
            if (versionString == null) {
                versionString = "0";
            } else if (!Verifier.isVersion((String)versionString)) {
                throw new IllegalArgumentException("Invalid version " + versionString + " in file " + tmpFile);
            }
            version = Version.parseVersion((String)versionString);
        }
        URL url = this.put(tmpFile, bsn, version);
        this.reset();
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL put(File file, String bsn, Version version) throws IOException {
        URL url = this.getTargetURL(bsn, version);
        HttpURLConnection httpUrlConnection = null;
        FileInputStream is = null;
        OutputStream out = null;
        try {
            int length;
            is = new FileInputStream(file);
            httpUrlConnection = (HttpURLConnection)url.openConnection();
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setFixedLengthStreamingMode((int)file.length());
            httpUrlConnection.setRequestMethod("PUT");
            if (this.username != null && this.password != null) {
                String userPassword = this.username + ":" + this.password;
                httpUrlConnection.setRequestProperty("Authorization", "Basic " + Base64.encodeBase64(userPassword.getBytes("UTF-8")));
            }
            out = httpUrlConnection.getOutputStream();
            byte[] buffer = new byte[8192];
            while ((length = is.read(buffer)) >= 0) {
                out.write(buffer, 0, length);
            }
            int respondeCode = httpUrlConnection.getResponseCode();
            if (respondeCode < 200 || respondeCode > 300) {
                throw new IOException(httpUrlConnection.getResponseMessage());
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (out != null) {
                out.close();
            }
            if (httpUrlConnection != null) {
                httpUrlConnection.disconnect();
            }
        }
        return url;
    }

    @Override
    public synchronized String getName() {
        if (this.name != null && !this.name.equals(((Object)((Object)this)).getClass().getName())) {
            return this.name;
        }
        return this.nexusRepositoryUrl;
    }

    private URL getTargetURL(String bsn, Version version) throws MalformedURLException {
        String url = this.puturl != null ? this.puturl : this.nexusRepositoryUrl;
        return new URL(url + bsn + "/" + bsn + "-" + version + ".jar");
    }

    public File getRoot() {
        return this.cacheDir;
    }
}

