/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry16;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNProperties13;
import org.tmatesoft.svn.core.internal.wc.admin.SVNProperties14;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminArea14
extends SVNAdminArea {
    public static final int WC_FORMAT = 8;
    public static final String[] ourCachableProperties = new String[]{"svn:special", "svn:externals", "svn:needs-lock"};
    protected static final String ATTRIBUTE_COPIED = "copied";
    protected static final String ATTRIBUTE_DELETED = "deleted";
    protected static final String ATTRIBUTE_ABSENT = "absent";
    protected static final String ATTRIBUTE_INCOMPLETE = "incomplete";
    protected static final String ATTRIBUTE_HAS_PROPS = "has-props";
    protected static final String ATTRIBUTE_HAS_PROP_MODS = "has-prop-mods";
    protected static final String KILL_ADM_ONLY = "adm-only";
    protected static final String THIS_DIR = "";
    private static final Set INAPPLICABLE_PROPERTIES = new SVNHashSet();
    private File myLockFile = new File(this.getAdminDirectory(), "lock");
    private File myEntriesFile = new File(this.getAdminDirectory(), "entries");
    private static boolean ourIsOptimizedWritingEnabled;

    public SVNAdminArea14(File dir) {
        super(dir);
    }

    public static void setOptimizedWritingEnabled(boolean enabled) {
        ourIsOptimizedWritingEnabled = enabled;
    }

    public static String[] getCachableProperties() {
        return ourCachableProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveWCProperties(boolean close) throws SVNException {
        Map wcPropsCache = this.getWCPropertiesStorage(false);
        if (wcPropsCache == null) {
            return;
        }
        boolean hasAnyProps = false;
        File dstFile = this.getAdminFile("all-wcprops");
        File tmpFile = this.getAdminFile("tmp/all-wcprops");
        for (String name : wcPropsCache.keySet()) {
            SVNVersionedProperties props = (SVNVersionedProperties)wcPropsCache.get(name);
            if (props.isEmpty()) continue;
            hasAnyProps = true;
            break;
        }
        if (hasAnyProps) {
            OutputStream target = null;
            try {
                target = SVNFileUtil.openFileForWriting(tmpFile);
                SVNVersionedProperties props = (SVNVersionedProperties)wcPropsCache.get(this.getThisDirName());
                if (props != null && !props.isEmpty()) {
                    SVNWCProperties.setProperties(props.asMap(), target, "END");
                } else {
                    SVNWCProperties.setProperties(new SVNProperties(), target, "END");
                }
                for (String name : wcPropsCache.keySet()) {
                    if (this.getThisDirName().equals(name) || (props = (SVNVersionedProperties)wcPropsCache.get(name)).isEmpty()) continue;
                    target.write(name.getBytes("UTF-8"));
                    target.write(10);
                    SVNWCProperties.setProperties(props.asMap(), target, "END");
                }
            }
            catch (IOException ioe) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                SVNErrorManager.error(err, ioe, SVNLogType.WC);
            }
            finally {
                SVNFileUtil.closeFile(target);
            }
            SVNFileUtil.rename(tmpFile, dstFile);
            SVNFileUtil.setReadonly(dstFile, true);
        } else {
            SVNFileUtil.deleteFile(dstFile);
        }
        if (close) {
            this.closeWCProperties();
        }
    }

    @Override
    public SVNVersionedProperties getBaseProperties(String name) throws SVNException {
        Map basePropsCache = this.getBasePropertiesStorage(true);
        SVNVersionedProperties props = (SVNVersionedProperties)basePropsCache.get(name);
        if (props != null) {
            return props;
        }
        SVNProperties baseProps = null;
        try {
            baseProps = this.readBaseProperties(name);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Failed to load properties from disk");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        props = new SVNProperties13(baseProps);
        basePropsCache.put(name, props);
        return props;
    }

    @Override
    public SVNVersionedProperties getRevertProperties(String name) throws SVNException {
        Map revertPropsCache = this.getRevertPropertiesStorage(true);
        SVNVersionedProperties props = (SVNVersionedProperties)revertPropsCache.get(name);
        if (props != null) {
            return props;
        }
        SVNProperties revertProps = null;
        try {
            revertProps = this.readRevertProperties(name);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Failed to load properties from disk");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        props = new SVNProperties13(revertProps);
        revertPropsCache.put(name, props);
        return props;
    }

    @Override
    public SVNVersionedProperties getProperties(String name) throws SVNException {
        Map propsCache = this.getPropertiesStorage(true);
        SVNVersionedProperties props = (SVNVersionedProperties)propsCache.get(name);
        if (props != null) {
            return props;
        }
        final String entryName = name;
        props = new SVNProperties14(null, this, name){

            @Override
            protected SVNProperties loadProperties() throws SVNException {
                SVNProperties props = this.getProperties();
                if (props == null) {
                    try {
                        props = SVNAdminArea14.this.readProperties(entryName);
                    }
                    catch (SVNException svne) {
                        SVNErrorMessage err = svne.getErrorMessage().wrap("Failed to load properties from disk");
                        SVNErrorManager.error(err, SVNLogType.DEFAULT);
                    }
                    props = props != null ? props : new SVNProperties();
                    this.setPropertiesMap(props);
                }
                return props;
            }
        };
        propsCache.put(name, props);
        return props;
    }

    @Override
    public SVNVersionedProperties getWCProperties(String entryName) throws SVNException {
        SVNEntry entry = this.getEntry(entryName, false);
        if (entry == null) {
            return null;
        }
        Map wcPropsCache = this.getWCPropertiesStorage(true);
        SVNVersionedProperties props = (SVNVersionedProperties)wcPropsCache.get(entryName);
        if (props != null) {
            return props;
        }
        if (wcPropsCache.isEmpty()) {
            wcPropsCache = this.readAllWCProperties();
        }
        if ((props = (SVNVersionedProperties)wcPropsCache.get(entryName)) == null) {
            props = new SVNProperties13(new SVNProperties());
            wcPropsCache.put(entryName, props);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map readAllWCProperties() throws SVNException {
        Map wcPropsCache = this.getWCPropertiesStorage(true);
        wcPropsCache.clear();
        File propertiesFile = this.getAdminFile("all-wcprops");
        if (!propertiesFile.exists()) {
            return wcPropsCache;
        }
        FSFile wcpropsFile = null;
        try {
            wcpropsFile = new FSFile(propertiesFile);
            SVNProperties wcProps = wcpropsFile.readProperties(false, true);
            SVNProperties13 entryWCProps = new SVNProperties13(wcProps);
            wcPropsCache.put(this.getThisDirName(), entryWCProps);
            String name = null;
            StringBuffer buffer = new StringBuffer();
            while (true) {
                try {
                    name = wcpropsFile.readLine(buffer);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.STREAM_UNEXPECTED_EOF && buffer.length() > 0) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Missing end of line in wcprops file for ''{0}''", (Object)this.getRoot());
                        SVNErrorManager.error(err, e, SVNLogType.WC);
                    }
                    break;
                }
                wcProps = wcpropsFile.readProperties(false, true);
                entryWCProps = new SVNProperties13(wcProps);
                wcPropsCache.put(name, entryWCProps);
                buffer.delete(0, buffer.length());
            }
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Failed to load properties from disk");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        finally {
            wcpropsFile.close();
        }
        return wcPropsCache;
    }

    protected SVNProperties readBaseProperties(String name) throws SVNException {
        File propertiesFile = this.getBasePropertiesFile(name, false);
        SVNWCProperties props = new SVNWCProperties(propertiesFile, null);
        return props.asMap();
    }

    protected SVNProperties readRevertProperties(String name) throws SVNException {
        File propertiesFile = this.getRevertPropertiesFile(name, false);
        SVNWCProperties props = new SVNWCProperties(propertiesFile, null);
        return props.asMap();
    }

    protected SVNProperties readProperties(String name) throws SVNException {
        SVNVersionedProperties baseProps;
        if (this.hasPropModifications(name)) {
            File propertiesFile = this.getPropertiesFile(name, false);
            SVNWCProperties props = new SVNWCProperties(propertiesFile, null);
            return props.asMap();
        }
        Map basePropsCache = this.getBasePropertiesStorage(true);
        if (basePropsCache != null && (baseProps = (SVNVersionedProperties)basePropsCache.get(name)) != null) {
            return baseProps.asMap();
        }
        if (this.hasProperties(name)) {
            return this.readBaseProperties(name);
        }
        return new SVNProperties();
    }

    @Override
    public void saveVersionedProperties(SVNLog log, boolean close) throws SVNException {
        Map basePropsCache;
        SVNVersionedProperties baseProps;
        SVNProperties command = new SVNProperties();
        SVNHashSet processedEntries = new SVNHashSet();
        Map propsCache = this.getPropertiesStorage(false);
        if (propsCache != null && !propsCache.isEmpty()) {
            for (String name : propsCache.keySet()) {
                SVNVersionedProperties props = (SVNVersionedProperties)propsCache.get(name);
                if (!props.isModified()) continue;
                baseProps = this.getBaseProperties(name);
                SVNVersionedProperties propsDiff = baseProps.compareTo(props);
                String[] cachableProps = SVNAdminArea14.getCachableProperties();
                command.put(SVNProperty.shortPropertyName("svn:entry:cachable-props"), SVNAdminArea14.asString(cachableProps, " "));
                SVNProperties propsMap = props.loadProperties();
                LinkedList<String> presentProps = new LinkedList<String>();
                for (int i = 0; i < cachableProps.length; ++i) {
                    if (!propsMap.containsName(cachableProps[i])) continue;
                    presentProps.addLast(cachableProps[i]);
                }
                if (presentProps.size() > 0) {
                    String presentPropsString = SVNAdminArea14.asString(presentProps.toArray(new String[presentProps.size()]), " ");
                    command.put(SVNProperty.shortPropertyName("svn:entry:present-props"), presentPropsString);
                } else {
                    command.put(SVNProperty.shortPropertyName("svn:entry:present-props"), THIS_DIR);
                }
                command.put(SVNProperty.shortPropertyName("svn:entry:has-props"), SVNProperty.toString(!props.isEmpty()));
                boolean hasPropModifications = !propsDiff.isEmpty();
                command.put(SVNProperty.shortPropertyName("svn:entry:has-prop-mods"), SVNProperty.toString(hasPropModifications));
                command.put("name", name);
                log.addCommand("modify-entry", command, false);
                processedEntries.add(name);
                command.clear();
                String dstPath = this.getThisDirName().equals(name) ? "dir-props" : "props/" + name + ".svn-work";
                dstPath = this.getAdminDirectory().getName() + "/" + dstPath;
                if (hasPropModifications) {
                    String tmpPath = "tmp/";
                    tmpPath = tmpPath + (this.getThisDirName().equals(name) ? "dir-props" : "props/" + name + ".svn-work");
                    File tmpFile = this.getAdminFile(tmpPath);
                    String srcPath = this.getAdminDirectory().getName() + "/" + tmpPath;
                    SVNWCProperties tmpProps = new SVNWCProperties(tmpFile, srcPath);
                    if (!props.isEmpty()) {
                        tmpProps.setProperties(props.asMap());
                    } else {
                        SVNFileUtil.createEmptyFile(tmpFile);
                    }
                    command.put("name", srcPath);
                    command.put("dest", dstPath);
                    log.addCommand("mv", command, false);
                    command.clear();
                    command.put("name", dstPath);
                    log.addCommand("readonly", command, false);
                } else {
                    command.put("name", dstPath);
                    log.addCommand("rm", command, false);
                }
                command.clear();
                props.setModified(false);
            }
        }
        if ((basePropsCache = this.getBasePropertiesStorage(false)) != null && !basePropsCache.isEmpty()) {
            for (String name : basePropsCache.keySet()) {
                baseProps = (SVNVersionedProperties)basePropsCache.get(name);
                if (!baseProps.isModified()) continue;
                String dstPath = this.getThisDirName().equals(name) ? "dir-prop-base" : "prop-base/" + name + ".svn-base";
                dstPath = this.getAdminDirectory().getName() + "/" + dstPath;
                boolean isEntryProcessed = processedEntries.contains(name);
                if (!isEntryProcessed) {
                    SVNVersionedProperties props = this.getProperties(name);
                    String[] cachableProps = SVNAdminArea14.getCachableProperties();
                    command.put(SVNProperty.shortPropertyName("svn:entry:cachable-props"), SVNAdminArea14.asString(cachableProps, " "));
                    SVNProperties propsMap = props.loadProperties();
                    LinkedList<String> presentProps = new LinkedList<String>();
                    for (int i = 0; i < cachableProps.length; ++i) {
                        if (!propsMap.containsName(cachableProps[i])) continue;
                        presentProps.addLast(cachableProps[i]);
                    }
                    if (presentProps.size() > 0) {
                        String presentPropsString = SVNAdminArea14.asString(presentProps.toArray(new String[presentProps.size()]), " ");
                        command.put(SVNProperty.shortPropertyName("svn:entry:present-props"), presentPropsString);
                    } else {
                        command.put(SVNProperty.shortPropertyName("svn:entry:present-props"), THIS_DIR);
                    }
                    command.put(SVNProperty.shortPropertyName("svn:entry:has-props"), SVNProperty.toString(!props.isEmpty()));
                    SVNVersionedProperties propsDiff = baseProps.compareTo(props);
                    boolean hasPropModifications = !propsDiff.isEmpty();
                    command.put(SVNProperty.shortPropertyName("svn:entry:has-prop-mods"), SVNProperty.toString(hasPropModifications));
                    command.put("name", name);
                    log.addCommand("modify-entry", command, false);
                    command.clear();
                    if (!hasPropModifications) {
                        String workingPropsPath = this.getThisDirName().equals(name) ? "dir-props" : "props/" + name + ".svn-work";
                        workingPropsPath = this.getAdminDirectory().getName() + "/" + workingPropsPath;
                        command.put("name", workingPropsPath);
                        log.addCommand("rm", command, false);
                        command.clear();
                    }
                }
                if (baseProps.isEmpty()) {
                    command.put("name", dstPath);
                    log.addCommand("rm", command, false);
                } else {
                    String tmpPath = "tmp/";
                    tmpPath = tmpPath + (this.getThisDirName().equals(name) ? "dir-prop-base" : "prop-base/" + name + ".svn-base");
                    File tmpFile = this.getAdminFile(tmpPath);
                    String srcPath = this.getAdminDirectory().getName() + "/" + tmpPath;
                    SVNWCProperties tmpProps = new SVNWCProperties(tmpFile, srcPath);
                    tmpProps.setProperties(baseProps.asMap());
                    command.put("name", srcPath);
                    command.put("dest", dstPath);
                    log.addCommand("mv", command, false);
                    command.clear();
                    command.put("name", dstPath);
                    log.addCommand("readonly", command, false);
                }
                baseProps.setModified(false);
            }
        }
        if (close) {
            this.closeVersionedProperties();
        }
    }

    @Override
    public void installProperties(String name, SVNProperties baseProps, SVNProperties workingProps, SVNLog log, boolean writeBaseProps, boolean close) throws SVNException {
        SVNProperties command = new SVNProperties();
        SVNNodeKind kind = name.equals(this.getThisDirName()) ? SVNNodeKind.DIR : SVNNodeKind.FILE;
        SVNProperties propDiff = baseProps.compareTo(workingProps);
        boolean hasPropMods = !propDiff.isEmpty();
        command.put(SVNProperty.shortPropertyName("svn:entry:has-prop-mods"), SVNProperty.toString(hasPropMods));
        command.put(SVNProperty.shortPropertyName("svn:entry:has-props"), SVNProperty.toString(!workingProps.isEmpty()));
        String[] cachableProps = SVNAdminArea14.getCachableProperties();
        command.put(SVNProperty.shortPropertyName("svn:entry:cachable-props"), SVNAdminArea14.asString(cachableProps, " "));
        LinkedList<String> presentProps = new LinkedList<String>();
        for (int i = 0; i < cachableProps.length; ++i) {
            if (!workingProps.containsName(cachableProps[i])) continue;
            presentProps.addLast(cachableProps[i]);
        }
        if (presentProps.size() > 0) {
            String presentPropsString = SVNAdminArea14.asString(presentProps.toArray(new String[presentProps.size()]), " ");
            command.put(SVNProperty.shortPropertyName("svn:entry:present-props"), presentPropsString);
        } else {
            command.put(SVNProperty.shortPropertyName("svn:entry:present-props"), THIS_DIR);
        }
        command.put("name", name);
        log.addCommand("modify-entry", command, false);
        command.clear();
        String dstPath = SVNAdminUtil.getPropPath(name, kind, false);
        if (hasPropMods) {
            String tmpPath = SVNAdminUtil.getPropPath(name, kind, true);
            File tmpFile = this.getFile(tmpPath);
            SVNWCProperties tmpProps = new SVNWCProperties(tmpFile, tmpPath);
            if (!workingProps.isEmpty()) {
                tmpProps.setProperties(workingProps);
            } else {
                SVNFileUtil.createEmptyFile(tmpFile);
            }
            command.put("name", tmpPath);
            command.put("dest", dstPath);
            log.addCommand("mv", command, false);
            command.clear();
            command.put("name", dstPath);
            log.addCommand("readonly", command, false);
        } else if (this.hasPropModifications(name)) {
            command.put("name", dstPath);
            log.addCommand("rm", command, false);
        }
        command.clear();
        if (writeBaseProps) {
            String basePath = SVNAdminUtil.getPropBasePath(name, kind, false);
            if (!baseProps.isEmpty()) {
                String tmpPath = SVNAdminUtil.getPropBasePath(name, kind, true);
                File tmpFile = this.getFile(tmpPath);
                SVNWCProperties tmpProps = new SVNWCProperties(tmpFile, tmpPath);
                tmpProps.setProperties(baseProps);
                command.put("name", tmpPath);
                command.put("dest", basePath);
                log.addCommand("mv", command, false);
                command.clear();
                command.put("name", basePath);
                log.addCommand("readonly", command, false);
            } else if (this.hasProperties(name)) {
                command.put("name", basePath);
                log.addCommand("rm", command, false);
            }
        }
        if (close) {
            this.closeVersionedProperties();
        }
    }

    @Override
    public void handleKillMe() throws SVNException {
        boolean killMe = this.isKillMe();
        if (killMe) {
            boolean isWCRoot;
            SVNWCAccess access;
            File dir;
            long dirRevision;
            block5: {
                String contents = SVNFileUtil.readFile(this.getAdminFile("KILLME"));
                boolean killAdmOnly = KILL_ADM_ONLY.equals(contents);
                SVNEntry entry = this.getEntry(this.getThisDirName(), false);
                dirRevision = entry != null ? entry.getRevision() : -1L;
                dir = this.getRoot();
                access = this.getWCAccess();
                isWCRoot = access.isWCRoot(this.getRoot());
                try {
                    this.removeFromRevisionControl(this.getThisDirName(), !killAdmOnly, false);
                }
                catch (SVNException svne) {
                    if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) break block5;
                    throw svne;
                }
            }
            if (isWCRoot) {
                return;
            }
            SVNAdminArea parentArea = access.retrieve(dir.getParentFile());
            SVNEntry parentEntry = parentArea.getEntry(parentArea.getThisDirName(), false);
            if (dirRevision > parentEntry.getRevision()) {
                SVNEntry entryInParent = parentArea.addEntry(dir.getName());
                SVNHashMap attributes = new SVNHashMap();
                attributes.put("svn:entry:deleted", Boolean.TRUE.toString());
                attributes.put("svn:entry:kind", "dir");
                attributes.put("svn:entry:revision", Long.toString(dirRevision));
                parentArea.modifyEntry(entryInParent.getName(), attributes, true, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveEntries(boolean close) throws SVNException {
        block14: {
            block17: {
                File tmpFile;
                block15: {
                    SVNEntry rootEntry;
                    if (this.myEntries == null) break block14;
                    if (!this.isLocked()) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "No write-lock in ''{0}''", (Object)this.getRoot());
                        SVNErrorManager.error(err, SVNLogType.DEFAULT);
                    }
                    if ((rootEntry = (SVNEntry)this.myEntries.get(this.getThisDirName())) == null) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "No default entry in directory ''{0}''", (Object)this.getRoot());
                        SVNErrorManager.error(err, SVNLogType.DEFAULT);
                    }
                    String reposURL = rootEntry.getRepositoryRoot();
                    String url = rootEntry.getURL();
                    if (reposURL != null && !SVNPathUtil.isAncestor(reposURL, url)) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Entry ''{0}'' has inconsistent repository root and url", (Object)this.getThisDirName());
                        SVNErrorManager.error(err, SVNLogType.DEFAULT);
                    }
                    if (!ourIsOptimizedWritingEnabled) break block15;
                    tmpFile = new File(this.getAdminDirectory(), "tmp/entries");
                    boolean renamed = this.myEntriesFile.renameTo(tmpFile);
                    if (!renamed) {
                        this.myEntriesFile.delete();
                        tmpFile = null;
                    }
                    OutputStreamWriter os = null;
                    try {
                        os = new OutputStreamWriter(SVNFileUtil.openFileForWriting(this.myEntriesFile), "UTF-8");
                        this.writeEntries(os);
                    }
                    catch (IOException e) {
                        try {
                            SVNFileUtil.closeFile(os);
                            if (tmpFile != null) {
                                SVNFileUtil.rename(tmpFile, this.myEntriesFile);
                            }
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write entries file ''{0}'': {1}", this.myEntriesFile, e.getLocalizedMessage());
                            SVNErrorManager.error(err, e, SVNLogType.WC);
                        }
                        catch (Throwable throwable) {
                            SVNFileUtil.closeFile(os);
                            SVNFileUtil.deleteFile(tmpFile);
                            throw throwable;
                        }
                        SVNFileUtil.closeFile(os);
                        SVNFileUtil.deleteFile(tmpFile);
                    }
                    SVNFileUtil.closeFile(os);
                    SVNFileUtil.deleteFile(tmpFile);
                    SVNFileUtil.setReadonly(this.myEntriesFile, true);
                    break block17;
                }
                tmpFile = new File(this.getAdminDirectory(), "tmp/entries");
                OutputStreamWriter os = null;
                try {
                    os = new OutputStreamWriter(SVNFileUtil.openFileForWriting(tmpFile), "UTF-8");
                    this.writeEntries(os);
                }
                catch (IOException e) {
                    try {
                        SVNFileUtil.closeFile(os);
                        SVNFileUtil.deleteFile(tmpFile);
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write entries file ''{0}'': {1}", this.myEntriesFile, e.getMessage());
                        SVNErrorManager.error(err, e, SVNLogType.WC);
                    }
                    catch (Throwable throwable) {
                        SVNFileUtil.closeFile(os);
                        throw throwable;
                    }
                    SVNFileUtil.closeFile(os);
                }
                SVNFileUtil.closeFile(os);
                SVNFileUtil.setReadonly(tmpFile, true);
                SVNFileUtil.rename(tmpFile, this.myEntriesFile);
            }
            if (close) {
                this.closeEntries();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map fetchEntries() throws SVNException {
        SVNErrorMessage err;
        if (!this.myEntriesFile.exists()) {
            return null;
        }
        SVNHashMap entries = new SVNHashMap();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(this.myEntriesFile, SVNLogType.WC), "UTF-8"));
            reader.readLine();
            int entryNumber = 1;
            while (true) {
                try {
                    SVNEntry entry = this.readEntry(reader, entryNumber);
                    if (entry == null) break;
                    entries.put(entry.getName(), entry);
                }
                catch (SVNException svne) {
                    SVNErrorMessage err2 = svne.getErrorMessage().wrap("Error at entry {0} in entries file for ''{1}'':", new Object[]{new Integer(entryNumber), this.getRoot()});
                    SVNErrorManager.error(err2, svne, SVNLogType.WC);
                }
                ++entryNumber;
            }
        }
        catch (IOException e) {
            try {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read entries file ''{0}'': {1}", this.myEntriesFile, e.getMessage());
                SVNErrorManager.error(err, e, SVNLogType.WC);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(reader);
                throw throwable;
            }
            SVNFileUtil.closeFile(reader);
        }
        SVNFileUtil.closeFile(reader);
        SVNEntry defaultEntry = (SVNEntry)entries.get(this.getThisDirName());
        if (defaultEntry == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Missing default entry");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (defaultEntry.getRevision() < 0L) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_REVISION, "Default entry has no revision number");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (defaultEntry.getURL() == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Default entry is missing URL");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        for (String name : entries.keySet()) {
            SVNNodeKind kind;
            SVNEntry entry = (SVNEntry)entries.get(name);
            if (this.getThisDirName().equals(name) || (kind = entry.getKind()) != SVNNodeKind.FILE) continue;
            if (entry.getRevision() < 0L) {
                entry.setRevision(defaultEntry.getRevision());
            }
            if (entry.getURL() == null) {
                entry.setParentURL(defaultEntry.getURL());
            }
            if (entry.getRepositoryRoot() == null) {
                entry.setRepositoryRoot(defaultEntry.getRepositoryRoot());
            }
            if (entry.getUUID() == null && !entry.isScheduledForAddition() && !entry.isScheduledForReplacement()) {
                entry.setUUID(defaultEntry.getUUID());
            }
            if (entry.getCachableProperties() != null) continue;
            entry.setCachableProperties(defaultEntry.getCachableProperties());
        }
        return entries;
    }

    protected SVNEntry readEntry(BufferedReader reader, int entryNumber) throws IOException, SVNException {
        String line = reader.readLine();
        if (line == null && entryNumber > 1) {
            return null;
        }
        String name = this.parseString(line);
        name = name != null ? name : this.getThisDirName();
        name = (String)this.getObjectsPool().getObject(name);
        SVNEntry16 entry = new SVNEntry16(this, name);
        entry.setDepth(SVNDepth.INFINITY);
        line = reader.readLine();
        String kind = this.parseValue(line);
        if (kind != null) {
            SVNNodeKind parsedKind = SVNNodeKind.parseKind(kind);
            if (parsedKind != SVNNodeKind.UNKNOWN && parsedKind != SVNNodeKind.NONE) {
                entry.setKind(parsedKind);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Entry ''{0}'' has invalid node kind", (Object)name);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        } else {
            entry.setKind(SVNNodeKind.NONE);
        }
        line = reader.readLine();
        if (this.isEntryFinished(line)) {
            return entry;
        }
        String revision = this.parseValue(line);
        if (revision != null) {
            try {
                long rev = Long.parseLong(revision);
                entry.setRevision(rev);
            }
            catch (NumberFormatException nfe) {
                entry.setRevision(-1L);
            }
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String url = this.parseString(line);
        if (url != null) {
            entry.setURL(url);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String reposRoot = this.parseString(line);
        if (reposRoot != null && url != null && !SVNPathUtil.isAncestor(reposRoot, url)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Entry for ''{0}'' has invalid repository root", (Object)name);
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (reposRoot != null) {
            reposRoot = (String)this.getObjectsPool().getObject(reposRoot);
            entry.setRepositoryRoot(reposRoot);
        }
        line = reader.readLine();
        if (this.isEntryFinished(line)) {
            return entry;
        }
        String schedule = this.parseValue(line);
        if (schedule != null) {
            if ("add".equals(schedule) || "delete".equals(schedule) || "replace".equals(schedule)) {
                entry.setSchedule(schedule);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_ATTRIBUTE_INVALID, "Entry ''{0}'' has invalid ''{1}'' value", name, "svn:entry:schedule");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String timestamp = this.parseValue(line);
        if (timestamp != null) {
            entry.setTextTime(timestamp);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String checksum = this.parseString(line);
        if (checksum != null) {
            entry.setChecksum(checksum);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String committedDate = this.parseValue(line);
        if (committedDate != null) {
            entry.setCommittedDate(committedDate);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String committedRevision = this.parseValue(line);
        if (committedRevision != null) {
            try {
                long rev = Long.parseLong(committedRevision);
                entry.setCommittedRevision(rev);
            }
            catch (NumberFormatException nfe) {
                entry.setCommittedRevision(-1L);
            }
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String committedAuthor = this.parseString(line);
        if (committedAuthor != null) {
            committedAuthor = (String)this.getObjectsPool().getObject(committedAuthor);
            entry.setAuthor(committedAuthor);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        boolean hasProps = this.parseBoolean(line, ATTRIBUTE_HAS_PROPS);
        if (hasProps && entry instanceof SVNEntry16) {
            entry.setHasProperties(hasProps);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        boolean hasPropMods = this.parseBoolean(line, ATTRIBUTE_HAS_PROP_MODS);
        if (hasPropMods && entry instanceof SVNEntry16) {
            entry.setHasPropertiesModifications(hasPropMods);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String cachablePropsStr = this.parseValue(line);
        if (cachablePropsStr != null) {
            Object[] cachableProps = SVNAdminArea14.fromString(cachablePropsStr, " ");
            if (Arrays.equals(cachableProps, SVNAdminArea14.getCachableProperties())) {
                cachableProps = SVNAdminArea14.getCachableProperties();
            }
            entry.setCachableProperties((String[])cachableProps);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String presentPropsStr = this.parseValue(line);
        if (presentPropsStr != null && entry instanceof SVNEntry16) {
            String[] presentProps = SVNAdminArea14.fromString(presentPropsStr, " ");
            entry.setPresentProperties(presentProps);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String prejFile = this.parseString(line);
        if (prejFile != null) {
            entry.setPropRejectFile(prejFile);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String conflictOldFile = this.parseString(line);
        if (conflictOldFile != null) {
            entry.setConflictOld(conflictOldFile);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String conflictNewFile = this.parseString(line);
        if (conflictNewFile != null) {
            entry.setConflictNew(conflictNewFile);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String conflictWorkFile = this.parseString(line);
        if (conflictWorkFile != null) {
            entry.setConflictWorking(conflictWorkFile);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        boolean isCopied = this.parseBoolean(line, ATTRIBUTE_COPIED);
        if (isCopied) {
            entry.setCopied(isCopied);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String copyfromURL = this.parseString(line);
        if (copyfromURL != null) {
            entry.setCopyFromURL(copyfromURL);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String copyfromRevision = this.parseValue(line);
        if (copyfromRevision != null) {
            try {
                long rev = Long.parseLong(copyfromRevision);
                entry.setCopyFromRevision(rev);
            }
            catch (NumberFormatException nfe) {
                entry.setCopyFromRevision(-1L);
            }
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        boolean isDeleted = this.parseBoolean(line, ATTRIBUTE_DELETED);
        if (isDeleted) {
            entry.setDeleted(isDeleted);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        boolean isAbsent = this.parseBoolean(line, ATTRIBUTE_ABSENT);
        if (isAbsent) {
            entry.setAbsent(isAbsent);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        boolean isIncomplete = this.parseBoolean(line, ATTRIBUTE_INCOMPLETE);
        if (isIncomplete) {
            entry.setIncomplete(isIncomplete);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String uuid = this.parseString(line);
        if (uuid != null) {
            uuid = (String)this.getObjectsPool().getObject(uuid);
            entry.setUUID(uuid);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String lockToken = this.parseString(line);
        if (lockToken != null) {
            entry.setLockToken(lockToken);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String lockOwner = this.parseString(line);
        if (lockOwner != null) {
            lockOwner = (String)this.getObjectsPool().getObject(lockOwner);
            entry.setLockOwner(lockOwner);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String lockComment = this.parseString(line);
        if (lockComment != null) {
            entry.setLockComment(lockComment);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return entry;
        }
        String lockCreationDate = this.parseValue(line);
        if (lockCreationDate != null) {
            entry.setLockCreationDate(lockCreationDate);
        }
        if (this.readExtraOptions(reader, entry)) {
            return entry;
        }
        do {
            if ((line = reader.readLine()) == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Missing entry terminator");
                SVNErrorManager.error(err, SVNLogType.WC);
                continue;
            }
            if (line.length() == 1 && line.charAt(0) == '\f') break;
        } while (line != null);
        return entry;
    }

    protected boolean isEntryFinished(String line) {
        return line != null && line.length() > 0 && line.charAt(0) == '\f';
    }

    protected boolean parseBoolean(String line, String field) throws SVNException {
        if ((line = this.parseValue(line)) != null) {
            if (!line.equals(field)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Invalid value for field ''{0}''", (Object)field);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            return true;
        }
        return false;
    }

    protected String parseString(String line) throws SVNException {
        if (line == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Unexpected end of entry");
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (THIS_DIR.equals(line)) {
            return null;
        }
        int fromIndex = 0;
        int ind = -1;
        StringBuffer buffer = null;
        String escapedString = null;
        while ((ind = line.indexOf(92, fromIndex)) != -1) {
            if (line.length() < ind + 4 || line.charAt(ind + 1) != 'x' || !SVNEncodingUtil.isHexDigit(line.charAt(ind + 2)) || !SVNEncodingUtil.isHexDigit(line.charAt(ind + 3))) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Invalid escape sequence");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (buffer == null) {
                buffer = new StringBuffer();
            }
            escapedString = line.substring(ind + 2, ind + 4);
            int escapedByte = Integer.parseInt(escapedString, 16);
            if (ind > fromIndex) {
                buffer.append(line.substring(fromIndex, ind));
                buffer.append((char)(escapedByte & 0xFF));
            } else {
                buffer.append((char)(escapedByte & 0xFF));
            }
            fromIndex = ind + 4;
        }
        if (buffer != null) {
            if (fromIndex < line.length()) {
                buffer.append(line.substring(fromIndex));
            }
            return buffer.toString();
        }
        return line;
    }

    protected String parseValue(String line) throws SVNException {
        if (line == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Unexpected end of entry");
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (THIS_DIR.equals(line)) {
            return null;
        }
        return line;
    }

    @Override
    public String getThisDirName() {
        return THIS_DIR;
    }

    @Override
    protected boolean readExtraOptions(BufferedReader reader, SVNEntry entry) throws SVNException, IOException {
        return false;
    }

    @Override
    protected void writeEntries(Writer writer) throws IOException, SVNException {
        SVNEntry rootEntry = (SVNEntry)this.myEntries.get(this.getThisDirName());
        writer.write(this.getFormatVersion() + "\n");
        this.writeEntry(writer, this.getThisDirName(), rootEntry, null);
        ArrayList names = new ArrayList(this.myEntries.keySet());
        Collections.sort(names);
        for (String name : names) {
            SVNEntry entry = (SVNEntry)this.myEntries.get(name);
            if (this.getThisDirName().equals(name)) continue;
            SVNNodeKind kind = entry.getKind();
            if (kind == SVNNodeKind.FILE) {
                if (entry.getRevision() < 0L) {
                    entry.setRevision(rootEntry.getRevision());
                }
                if (entry.getURL() == null) {
                    entry.setParentURL(rootEntry.getURL());
                }
                if (entry.getRepositoryRoot() == null) {
                    entry.setRepositoryRoot(rootEntry.getRepositoryRoot());
                }
                if (entry.getUUID() == null && !entry.isScheduledForAddition() && !entry.isScheduledForReplacement()) {
                    entry.setUUID(rootEntry.getUUID());
                }
                if (entry.getCachableProperties() == null) {
                    entry.setCachableProperties(rootEntry.getCachableProperties());
                }
            }
            this.writeEntry(writer, name, entry, rootEntry);
        }
    }

    private void writeEntry(Writer writer, String name, SVNEntry entry, SVNEntry rootEntry) throws IOException, SVNException {
        String thisDirUUID;
        String thisDirCachableProps;
        String kind;
        boolean isThisDir = this.getThisDirName().equals(name);
        boolean isSubDir = !isThisDir && entry.isDirectory();
        int emptyFields = 0;
        if (!this.writeString(writer, name, emptyFields)) {
            ++emptyFields;
        }
        emptyFields = this.writeValue(writer, kind = entry.getKind().toString(), emptyFields) ? 0 : ++emptyFields;
        long revision = -1L;
        if (isThisDir) {
            revision = entry.getRevision();
        } else if (!isSubDir && (revision = entry.getRevision()) == rootEntry.getRevision()) {
            revision = -1L;
        }
        emptyFields = this.writeRevision(writer, revision, emptyFields) ? 0 : ++emptyFields;
        String url = null;
        if (isThisDir) {
            url = entry.getURL();
        } else if (!isSubDir) {
            url = entry.getURL();
            String expectedURL = SVNPathUtil.append(rootEntry.getURL(), SVNEncodingUtil.uriEncode(name));
            if (url != null && url.equals(expectedURL)) {
                url = null;
            }
        }
        emptyFields = this.writeString(writer, url, emptyFields) ? 0 : ++emptyFields;
        String root = null;
        if (isThisDir) {
            root = entry.getRepositoryRoot();
        } else if (!isSubDir) {
            String thisDirRoot = rootEntry.getRepositoryRoot();
            root = entry.getRepositoryRoot();
            if (root != null && root.equals(thisDirRoot)) {
                root = null;
            }
        }
        emptyFields = this.writeString(writer, root, emptyFields) ? 0 : ++emptyFields;
        String schedule = entry.getSchedule();
        if (!(schedule == null || "add".equals(schedule) || "delete".equals(schedule) || "replace".equals(schedule))) {
            schedule = null;
        }
        emptyFields = this.writeValue(writer, schedule, emptyFields) ? 0 : ++emptyFields;
        String textTime = entry.getTextTime();
        emptyFields = this.writeTime(writer, textTime, emptyFields) ? 0 : ++emptyFields;
        String checksum = entry.getChecksum();
        emptyFields = this.writeValue(writer, checksum, emptyFields) ? 0 : ++emptyFields;
        String committedDate = entry.getCommittedDate();
        emptyFields = this.writeTime(writer, committedDate, emptyFields) ? 0 : ++emptyFields;
        long committedRevision = entry.getCommittedRevision();
        emptyFields = this.writeRevision(writer, committedRevision, emptyFields) ? 0 : ++emptyFields;
        String committedAuthor = entry.getAuthor();
        emptyFields = this.writeString(writer, committedAuthor, emptyFields) ? 0 : ++emptyFields;
        boolean hasProps = entry.hasProperties();
        if (hasProps) {
            this.writeValue(writer, ATTRIBUTE_HAS_PROPS, emptyFields);
            emptyFields = 0;
        } else {
            ++emptyFields;
        }
        boolean hasPropsMods = entry.hasPropertiesModifications();
        if (hasPropsMods) {
            this.writeValue(writer, ATTRIBUTE_HAS_PROP_MODS, emptyFields);
            emptyFields = 0;
        } else {
            ++emptyFields;
        }
        String cachableProps = SVNAdminArea14.asString(entry.getCachableProperties(), " ");
        if (!isThisDir && (thisDirCachableProps = SVNAdminArea14.asString(rootEntry.getCachableProperties(), " ")) != null && cachableProps != null && thisDirCachableProps.equals(cachableProps)) {
            cachableProps = null;
        }
        emptyFields = this.writeValue(writer, cachableProps, emptyFields) ? 0 : ++emptyFields;
        String presentProps = SVNAdminArea14.asString(entry.getPresentProperties(), " ");
        emptyFields = this.writeValue(writer, presentProps, emptyFields) ? 0 : ++emptyFields;
        String propRejectFile = entry.getPropRejectFile();
        emptyFields = this.writeString(writer, propRejectFile, emptyFields) ? 0 : ++emptyFields;
        String conflictOldFile = entry.getConflictOld();
        emptyFields = this.writeString(writer, conflictOldFile, emptyFields) ? 0 : ++emptyFields;
        String conflictNewFile = entry.getConflictNew();
        emptyFields = this.writeString(writer, conflictNewFile, emptyFields) ? 0 : ++emptyFields;
        String conflictWrkFile = entry.getConflictWorking();
        emptyFields = this.writeString(writer, conflictWrkFile, emptyFields) ? 0 : ++emptyFields;
        boolean copiedAttr = entry.isCopied();
        if (copiedAttr) {
            this.writeValue(writer, ATTRIBUTE_COPIED, emptyFields);
            emptyFields = 0;
        } else {
            ++emptyFields;
        }
        String copyfromURL = entry.getCopyFromURL();
        emptyFields = this.writeString(writer, copyfromURL, emptyFields) ? 0 : ++emptyFields;
        long copyfromRevision = entry.getCopyFromRevision();
        emptyFields = this.writeRevision(writer, copyfromRevision, emptyFields) ? 0 : ++emptyFields;
        boolean deletedAttr = entry.isDeleted();
        if (deletedAttr) {
            this.writeValue(writer, ATTRIBUTE_DELETED, emptyFields);
            emptyFields = 0;
        } else {
            ++emptyFields;
        }
        boolean absentAttr = entry.isAbsent();
        if (absentAttr) {
            this.writeValue(writer, ATTRIBUTE_ABSENT, emptyFields);
            emptyFields = 0;
        } else {
            ++emptyFields;
        }
        boolean incompleteAttr = entry.isIncomplete();
        if (incompleteAttr) {
            this.writeValue(writer, ATTRIBUTE_INCOMPLETE, emptyFields);
            emptyFields = 0;
        } else {
            ++emptyFields;
        }
        String uuid = entry.getUUID();
        if (!isThisDir && (thisDirUUID = rootEntry.getUUID()) != null && uuid != null && thisDirUUID.equals(uuid)) {
            uuid = null;
        }
        emptyFields = this.writeValue(writer, uuid, emptyFields) ? 0 : ++emptyFields;
        String lockToken = entry.getLockToken();
        emptyFields = this.writeString(writer, lockToken, emptyFields) ? 0 : ++emptyFields;
        String lockOwner = entry.getLockOwner();
        emptyFields = this.writeString(writer, lockOwner, emptyFields) ? 0 : ++emptyFields;
        String lockComment = entry.getLockComment();
        emptyFields = this.writeString(writer, lockComment, emptyFields) ? 0 : ++emptyFields;
        String lockCreationDate = entry.getLockCreationDate();
        emptyFields = this.writeTime(writer, lockCreationDate, emptyFields) ? 0 : ++emptyFields;
        this.writeExtraOptions(writer, name, entry, emptyFields);
        writer.write("\f\n");
        writer.flush();
    }

    @Override
    protected int writeExtraOptions(Writer writer, String entryName, SVNEntry entry, int emptyFields) throws SVNException, IOException {
        return emptyFields;
    }

    protected boolean writeString(Writer writer, String str, int emptyFields) throws IOException {
        if (str != null && str.length() > 0) {
            int i;
            for (i = 0; i < emptyFields; ++i) {
                writer.write(10);
            }
            for (i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (SVNEncodingUtil.isASCIIControlChar(ch) || ch == '\\') {
                    writer.write("\\x");
                    writer.write(SVNFormatUtil.getHexNumberFromByte((byte)ch));
                    continue;
                }
                writer.write(ch);
            }
            writer.write(10);
            return true;
        }
        return false;
    }

    protected boolean writeValue(Writer writer, String val, int emptyFields) throws IOException {
        if (val != null && val.length() > 0) {
            for (int i = 0; i < emptyFields; ++i) {
                writer.write(10);
            }
            writer.write(val);
            writer.write(10);
            return true;
        }
        return false;
    }

    protected boolean writeTime(Writer writer, String val, int emptyFields) throws IOException {
        long time;
        if (val != null && val.length() > 0 && (time = SVNDate.parseDateAsMilliseconds(val)) > 0L) {
            for (int i = 0; i < emptyFields; ++i) {
                writer.write(10);
            }
            writer.write(val);
            writer.write(10);
            return true;
        }
        return false;
    }

    protected boolean writeRevision(Writer writer, long revValue, int emptyFields) throws IOException {
        if (revValue >= 0L) {
            for (int i = 0; i < emptyFields; ++i) {
                writer.write(10);
            }
            writer.write(Long.toString(revValue));
            writer.write(10);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPropModifications(String name) throws SVNException {
        SVNEntry entry = this.getEntry(name, true);
        if (entry != null) {
            return entry.hasPropertiesModifications();
        }
        return false;
    }

    @Override
    public boolean hasProperties(String name) throws SVNException {
        SVNEntry entry = this.getEntry(name, true);
        if (entry != null) {
            return entry.hasProperties();
        }
        return false;
    }

    public boolean lock() throws SVNException {
        return this.lock(false);
    }

    @Override
    public boolean lock(boolean stealLock) throws SVNException {
        if (!this.isVersioned()) {
            return false;
        }
        if (stealLock && this.myLockFile.isFile()) {
            this.setLocked(true);
            return true;
        }
        boolean created = false;
        try {
            created = SVNFileUtil.createNewFile(this.myLockFile);
        }
        catch (IOException e) {
            SVNErrorCode code = e.getMessage().indexOf("denied") >= 0 ? SVNErrorCode.WC_LOCKED : SVNErrorCode.WC_NOT_LOCKED;
            SVNErrorMessage err = SVNErrorMessage.create(code, "Cannot lock working copy ''{0}'': {1}", this.getRoot(), e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.WC);
        }
        if (created) {
            this.setLocked(true);
            return created;
        }
        if (this.myLockFile.isFile()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked; try performing ''cleanup''", (Object)this.getRoot());
            SVNErrorManager.error(err, SVNLogType.WC);
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Cannot lock working copy ''{0}''", (Object)this.getRoot());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return false;
    }

    @Override
    public SVNAdminArea createVersionedDirectory(File dir, String url, String rootURL, String uuid, long revNumber, boolean createMyself, SVNDepth depth) throws SVNException {
        dir = createMyself ? this.getRoot() : dir;
        dir.mkdirs();
        File adminDir = createMyself ? this.getAdminDirectory() : new File(dir, SVNFileUtil.getAdminDirectoryName());
        adminDir.mkdir();
        SVNFileUtil.setHidden(adminDir, true);
        File lockFile = createMyself ? this.myLockFile : new File(adminDir, "lock");
        SVNFileUtil.createEmptyFile(lockFile);
        File[] tmp = new File[]{createMyself ? this.getAdminFile("tmp") : new File(adminDir, "tmp"), createMyself ? this.getAdminFile("tmp" + File.separatorChar + "props") : new File(adminDir, "tmp" + File.separatorChar + "props"), createMyself ? this.getAdminFile("tmp" + File.separatorChar + "prop-base") : new File(adminDir, "tmp" + File.separatorChar + "prop-base"), createMyself ? this.getAdminFile("tmp" + File.separatorChar + "text-base") : new File(adminDir, "tmp" + File.separatorChar + "text-base"), createMyself ? this.getAdminFile("props") : new File(adminDir, "props"), createMyself ? this.getAdminFile("prop-base") : new File(adminDir, "prop-base"), createMyself ? this.getAdminFile("text-base") : new File(adminDir, "text-base")};
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i].mkdir();
        }
        this.createFormatFile(createMyself ? null : new File(adminDir, "format"), createMyself);
        SVNAdminArea14 adminArea = createMyself ? this : this.createAdminAreaForDir(dir);
        adminArea.setLocked(true);
        SVNEntry rootEntry = adminArea.getEntry(((SVNAdminArea)adminArea).getThisDirName(), true);
        if (rootEntry == null) {
            rootEntry = adminArea.addEntry(((SVNAdminArea)adminArea).getThisDirName());
        }
        if (url != null) {
            rootEntry.setURL(url);
        }
        rootEntry.setRepositoryRoot(rootURL);
        rootEntry.setRevision(revNumber);
        rootEntry.setKind(SVNNodeKind.DIR);
        rootEntry.setDepth(depth);
        if (uuid != null) {
            rootEntry.setUUID(uuid);
        }
        if (revNumber > 0L) {
            rootEntry.setIncomplete(true);
        }
        rootEntry.setCachableProperties(ourCachableProperties);
        try {
            ((SVNAdminArea)adminArea).saveEntries(false);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Error writing entries file for ''{0}''", dir);
            SVNErrorManager.error(err, svne, SVNLogType.WC);
        }
        SVNFileUtil.deleteFile(lockFile);
        return adminArea;
    }

    @Override
    protected SVNVersionedProperties formatBaseProperties(SVNProperties srcProperties) {
        SVNProperties props = new SVNProperties(srcProperties);
        return new SVNProperties13(props);
    }

    @Override
    protected SVNVersionedProperties formatProperties(SVNEntry entry, SVNProperties srcProperties) {
        SVNProperties props = new SVNProperties(srcProperties);
        return new SVNProperties14(props, this, entry.getName()){

            @Override
            protected SVNProperties loadProperties() throws SVNException {
                return this.getProperties();
            }
        };
    }

    private void makeKillMe(boolean killAdminOnly) throws SVNException {
        File killMe = this.getAdminFile("KILLME");
        if (killMe.getParentFile().isDirectory()) {
            SVNFileUtil.createFile(killMe, killAdminOnly ? KILL_ADM_ONLY : null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postCommit(String fileName, long revisionNumber, boolean implicit, boolean rerun, SVNErrorCode errorCode) throws SVNException {
        SVNErrorMessage err;
        File tmpFile;
        SVNFileType fileType;
        SVNEntry entry = this.getEntry(fileName, true);
        if (entry == null || !this.getThisDirName().equals(fileName) && entry.getKind() != SVNNodeKind.FILE) {
            SVNErrorMessage err2 = SVNErrorMessage.create(errorCode, "Log command for directory ''{0}'' is mislocated", (Object)this.getRoot());
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        if (!implicit && entry.isScheduledForDeletion()) {
            if (this.getThisDirName().equals(fileName)) {
                File killMe;
                entry.setRevision(revisionNumber);
                entry.setKind(SVNNodeKind.DIR);
                if (rerun && (killMe = this.getAdminFile("KILLME")).isFile()) {
                    return;
                }
                this.makeKillMe(entry.isKeepLocal());
            } else {
                this.removeFromRevisionControl(fileName, false, false);
                SVNEntry parentEntry = this.getEntry(this.getThisDirName(), true);
                if (revisionNumber > parentEntry.getRevision()) {
                    SVNEntry fileEntry = this.addEntry(fileName);
                    fileEntry.setKind(SVNNodeKind.FILE);
                    fileEntry.setDeleted(true);
                    fileEntry.setRevision(revisionNumber);
                }
            }
            return;
        }
        if (!implicit && entry.isScheduledForReplacement() && this.getThisDirName().equals(fileName)) {
            Iterator ents = this.entries(true);
            while (ents.hasNext()) {
                SVNEntry currentEntry = (SVNEntry)ents.next();
                if (!currentEntry.isScheduledForDeletion() || currentEntry.getKind() != SVNNodeKind.FILE && currentEntry.getKind() != SVNNodeKind.DIR) continue;
                this.removeFromRevisionControl(currentEntry.getName(), false, false);
            }
        }
        long fileLength = 0L;
        if (!this.getThisDirName().equals(fileName)) {
            File workingFile = this.getFile(fileName);
            fileLength = SVNFileUtil.getFileLength(workingFile);
        }
        long textTime = 0L;
        if (!(implicit || this.getThisDirName().equals(fileName) || (fileType = SVNFileType.getType(tmpFile = this.getBaseFile(fileName, true))) != SVNFileType.FILE && fileType != SVNFileType.SYMLINK)) {
            long wkTimestamp;
            boolean modified = false;
            File workingFile = this.getFile(fileName);
            long tmpTimestamp = SVNFileUtil.getFileLastModified(tmpFile);
            if (tmpTimestamp != (wkTimestamp = SVNFileUtil.getFileLastModified(workingFile))) {
                File tmpFile2 = SVNFileUtil.createUniqueFile(tmpFile.getParentFile(), fileName, ".tmp", true);
                try {
                    String tmpFile2Path = SVNFileUtil.getBasePath(tmpFile2);
                    SVNTranslator.translate((SVNAdminArea)this, fileName, fileName, tmpFile2Path, false);
                    modified = !SVNFileUtil.compareFiles(tmpFile, tmpFile2, null);
                }
                catch (SVNException svne) {
                    err = SVNErrorMessage.create(errorCode, "Error comparing ''{0}'' and ''{1}''", workingFile, tmpFile);
                    SVNErrorManager.error(err, svne, SVNLogType.WC);
                }
                finally {
                    tmpFile2.delete();
                }
            }
            long l = textTime = modified ? tmpTimestamp : wkTimestamp;
        }
        if (!implicit && entry.isScheduledForReplacement()) {
            SVNFileUtil.deleteFile(this.getBasePropertiesFile(fileName, false));
        }
        boolean setReadWrite = false;
        boolean setNotExecutable = false;
        SVNVersionedProperties baseProps = this.getBaseProperties(fileName);
        SVNVersionedProperties wcProps = this.getProperties(fileName);
        File tmpPropsFile = this.getPropertiesFile(fileName, true);
        File wcPropsFile = this.getPropertiesFile(fileName, false);
        File basePropertiesFile = this.getBasePropertiesFile(fileName, false);
        SVNFileType tmpPropsType = SVNFileType.getType(tmpPropsFile);
        if (tmpPropsType == SVNFileType.FILE) {
            if (!this.getThisDirName().equals(fileName)) {
                SVNVersionedProperties propDiff = baseProps.compareTo(wcProps);
                setReadWrite = propDiff != null && propDiff.containsProperty("svn:needs-lock") && propDiff.getPropertyValue("svn:needs-lock") == null;
                setNotExecutable = propDiff != null && propDiff.containsProperty("svn:executable") && propDiff.getPropertyValue("svn:executable") == null;
            }
            try {
                if (!tmpPropsFile.exists() || tmpPropsFile.length() <= 4L) {
                    SVNFileUtil.deleteFile(basePropertiesFile);
                } else {
                    SVNFileUtil.copyFile(tmpPropsFile, basePropertiesFile, true);
                    SVNFileUtil.setReadonly(basePropertiesFile, true);
                }
            }
            finally {
                SVNFileUtil.deleteFile(tmpPropsFile);
            }
        }
        if (!this.getThisDirName().equals(fileName) && !implicit) {
            File tmpFile2 = this.getBaseFile(fileName, true);
            File baseFile = this.getBaseFile(fileName, false);
            File wcFile = this.getFile(fileName);
            File tmpFile22 = null;
            try {
                boolean needsExecutable;
                boolean special;
                tmpFile22 = SVNFileUtil.createUniqueFile(tmpFile2.getParentFile(), fileName, ".tmp", false);
                boolean overwritten = false;
                SVNFileType fileType2 = SVNFileType.getType(tmpFile2);
                boolean bl = special = this.getProperties(fileName).getPropertyValue("svn:special") != null;
                if (!SVNFileUtil.symlinksSupported() || !special) {
                    if (fileType2 == SVNFileType.FILE) {
                        SVNTranslator.translate((SVNAdminArea)this, fileName, SVNFileUtil.getBasePath(tmpFile2), SVNFileUtil.getBasePath(tmpFile22), true);
                    } else {
                        SVNTranslator.translate((SVNAdminArea)this, fileName, fileName, SVNFileUtil.getBasePath(tmpFile22), true, true);
                    }
                    if (!SVNFileUtil.compareFiles(tmpFile22, wcFile, null)) {
                        SVNFileUtil.copyFile(tmpFile22, wcFile, true);
                        overwritten = true;
                    }
                }
                boolean needsReadonly = this.getProperties(fileName).getPropertyValue("svn:needs-lock") != null && entry.getLockToken() == null;
                boolean bl2 = needsExecutable = this.getProperties(fileName).getPropertyValue("svn:executable") != null;
                if (needsReadonly) {
                    SVNFileUtil.setReadonly(wcFile, true);
                    overwritten = true;
                }
                if (needsExecutable) {
                    SVNFileUtil.setExecutable(wcFile, true);
                    overwritten = true;
                }
                if (fileType2 == SVNFileType.FILE) {
                    SVNFileUtil.rename(tmpFile2, baseFile);
                }
                if (setReadWrite) {
                    SVNFileUtil.setReadonly(wcFile, false);
                    overwritten = true;
                }
                if (setNotExecutable) {
                    SVNFileUtil.setExecutable(wcFile, false);
                    overwritten = true;
                }
                if (overwritten) {
                    textTime = SVNFileUtil.getFileLastModified(wcFile);
                    fileLength = SVNFileUtil.getFileLength(wcFile);
                }
            }
            catch (SVNException svne) {
                SVNErrorMessage err3 = SVNErrorMessage.create(errorCode, "Error replacing text-base of ''{0}''", (Object)fileName);
                SVNErrorManager.error(err3, svne, SVNLogType.WC);
            }
            finally {
                tmpFile22.delete();
                tmpFile2.delete();
            }
        }
        SVNHashMap entryAttrs = new SVNHashMap();
        entryAttrs.put("svn:entry:revision", SVNProperty.toString(revisionNumber));
        entryAttrs.put("svn:entry:kind", this.getThisDirName().equals(fileName) ? "dir" : "file");
        if (!implicit) {
            entryAttrs.put("svn:entry:schedule", null);
        }
        entryAttrs.put("svn:entry:copied", SVNProperty.toString(false));
        entryAttrs.put("svn:entry:deleted", SVNProperty.toString(false));
        if (textTime != 0L && !implicit) {
            entryAttrs.put("svn:entry:text-time", SVNDate.formatDate(new Date(textTime)));
        }
        entryAttrs.put("svn:entry:conflict-new", null);
        entryAttrs.put("svn:entry:conflict-old", null);
        entryAttrs.put("svn:entry:conflict-wrk", null);
        entryAttrs.put("svn:entry:prop-reject-file", null);
        entryAttrs.put("svn:entry:copyfrom-rev", null);
        entryAttrs.put("svn:entry:copyfrom-url", null);
        entryAttrs.put("svn:entry:has-prop-mods", SVNProperty.toString(false));
        entryAttrs.put("svn:entry:working-size", Long.toString(fileLength));
        try {
            this.modifyEntry(fileName, entryAttrs, false, true);
        }
        catch (SVNException svne) {
            err = SVNErrorMessage.create(errorCode, "Error modifying entry of ''{0}''", (Object)fileName);
            SVNErrorManager.error(err, svne, SVNLogType.WC);
        }
        SVNFileUtil.deleteFile(wcPropsFile);
        if (!this.getThisDirName().equals(fileName)) {
            return;
        }
        File dirFile = this.getRoot();
        if (this.getWCAccess().isWCRoot(this.getRoot())) {
            return;
        }
        boolean unassociated = false;
        SVNAdminArea parentArea = null;
        try {
            parentArea = this.getWCAccess().retrieve(dirFile.getParentFile());
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                parentArea = this.getWCAccess().open(dirFile.getParentFile(), true, false, 0);
                unassociated = true;
            }
            throw svne;
        }
        SVNEntry entryInParent = parentArea.getEntry(dirFile.getName(), false);
        if (entryInParent != null) {
            entryAttrs.clear();
            if (!implicit) {
                entryAttrs.put("svn:entry:schedule", null);
            }
            entryAttrs.put("svn:entry:copied", SVNProperty.toString(false));
            entryAttrs.put("svn:entry:copyfrom-rev", null);
            entryAttrs.put("svn:entry:copyfrom-url", null);
            entryAttrs.put("svn:entry:deleted", SVNProperty.toString(false));
            try {
                parentArea.modifyEntry(entryInParent.getName(), entryAttrs, true, true);
            }
            catch (SVNException svne) {
                SVNErrorMessage err4 = SVNErrorMessage.create(errorCode, "Error modifying entry of ''{0}''", (Object)fileName);
                SVNErrorManager.error(err4, svne, SVNLogType.WC);
            }
        }
        parentArea.saveEntries(false);
        if (unassociated) {
            this.getWCAccess().closeAdminArea(dirFile.getParentFile());
        }
    }

    @Override
    public boolean unlock() throws SVNException {
        if (!this.myLockFile.exists()) {
            return true;
        }
        boolean killMe = this.getAdminFile("KILLME").exists();
        if (killMe) {
            return false;
        }
        File[] logs = SVNFileListUtil.listFiles(this.getAdminDirectory());
        for (int i = 0; logs != null && i < logs.length; ++i) {
            File log = logs[i];
            if (!"log".equals(log.getName()) && !log.getName().startsWith("log.")) continue;
            if (log.isFile() && log.exists()) {
                SVNDebugLog.getDefaultLog().logFiner(SVNLogType.WC, "unlock: log file: '" + log.getName() + "', listed, and exists.");
                return false;
            }
            SVNDebugLog.getDefaultLog().logFiner(SVNLogType.WC, "unlock: log file: '" + log.getName() + "', listed, but does not exist.");
        }
        boolean deleted = SVNFileUtil.deleteFile(this.myLockFile);
        if (!deleted) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Failed to unlock working copy ''{0}''", (Object)this.getRoot());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return deleted;
    }

    @Override
    public boolean isVersioned() {
        if (this.getAdminDirectory().isDirectory() && this.myEntriesFile.canRead()) {
            try {
                if (this.getEntry(THIS_DIR, false) != null) {
                    return true;
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isLocked() throws SVNException {
        if (!this.myWasLocked) {
            return false;
        }
        SVNFileType type = SVNFileType.getType(this.myLockFile);
        if (type == SVNFileType.FILE) {
            return true;
        }
        if (type == SVNFileType.NONE) {
            return false;
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Lock file ''{0}'' is not a regular file", (Object)this.myLockFile);
        SVNErrorManager.error(err, SVNLogType.WC);
        return false;
    }

    @Override
    public boolean hasTreeConflict(String name) throws SVNException {
        return false;
    }

    @Override
    public SVNTreeConflictDescription getTreeConflict(String name) throws SVNException {
        return null;
    }

    @Override
    public void addTreeConflict(SVNTreeConflictDescription conflict) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "This feature is not supported in version {0} of working copy format", (Object)String.valueOf(this.getFormatVersion()));
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    @Override
    public SVNTreeConflictDescription deleteTreeConflict(String name) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "This feature is not supported in version {0} of working copy format", (Object)String.valueOf(this.getFormatVersion()));
        SVNErrorManager.error(err, SVNLogType.WC);
        return null;
    }

    @Override
    public void setFileExternalLocation(String name, SVNURL url, SVNRevision pegRevision, SVNRevision revision, SVNURL reposRootURL) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "This feature is not supported in version {0} of working copy format", (Object)String.valueOf(this.getFormatVersion()));
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    @Override
    public int getFormatVersion() {
        return 8;
    }

    protected SVNAdminArea createAdminAreaForDir(File dir) {
        return new SVNAdminArea14(dir);
    }

    @Override
    protected boolean isEntryPropertyApplicable(String propName) {
        return propName != null && !INAPPLICABLE_PROPERTIES.contains(propName);
    }

    static {
        INAPPLICABLE_PROPERTIES.add("svn:entry:keep-local");
        INAPPLICABLE_PROPERTIES.add("svn:entry:changelist");
        INAPPLICABLE_PROPERTIES.add("svn:entry:working-size");
        INAPPLICABLE_PROPERTIES.add("svn:entry:depth");
        INAPPLICABLE_PROPERTIES.add("svn:entry:prop-time");
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-path");
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-revision");
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-peg-revision");
        INAPPLICABLE_PROPERTIES.add("svn:entry:tree-conflicts");
    }
}

