/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.filters;

import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeParameter;

public class TypedSymbolNodeFilter
implements NodeFilter {
    private static final NodeFilter INSTANCE = new TypedSymbolNodeFilter();

    private TypedSymbolNodeFilter() {
    }

    @Override
    public boolean accepts(PsiElement element) {
        PsiJavaCodeReferenceElement referenceElement;
        PsiReferenceParameterList parameterList;
        if (element instanceof PsiClass) {
            if (element instanceof PsiTypeParameter) {
                return false;
            }
            PsiClass aClass = (PsiClass)element;
            return aClass.hasTypeParameters();
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            return method.hasTypeParameters();
        }
        if (element instanceof PsiJavaCodeReferenceElement && (parameterList = (referenceElement = (PsiJavaCodeReferenceElement)element).getParameterList()) != null) {
            return parameterList.getTypeParameterElements().length > 0;
        }
        return false;
    }

    public static NodeFilter getInstance() {
        return INSTANCE;
    }
}

