/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import gnu.trove.THashSet;

abstract class OptimizingSearchHelperBase
implements OptimizingSearchHelper {
    private final THashSet<String> scanned = new THashSet();
    private final THashSet<String> scannedText = new THashSet();
    private final THashSet<String> scannedComments = new THashSet();
    private final THashSet<String> scannedLiterals = new THashSet();
    protected int scanRequest = 0;

    OptimizingSearchHelperBase() {
    }

    @Override
    public void clear() {
        this.scanned.clear();
        this.scannedComments.clear();
        this.scannedLiterals.clear();
    }

    @Override
    public boolean addWordToSearchInCode(String refname) {
        if (this.doOptimizing() && this.scanned.add((Object)refname)) {
            this.doAddSearchWordInCode(refname);
            return true;
        }
        return false;
    }

    @Override
    public boolean addWordToSearchInText(String refname) {
        if (this.doOptimizing() && this.scannedText.add((Object)refname)) {
            this.doAddSearchWordInText(refname);
            return true;
        }
        return false;
    }

    @Override
    public boolean addWordToSearchInComments(String refname) {
        if (this.doOptimizing() && this.scannedComments.add((Object)refname)) {
            this.doAddSearchWordInComments(refname);
            return true;
        }
        return false;
    }

    @Override
    public boolean addWordToSearchInLiterals(String refname) {
        if (this.doOptimizing() && this.scannedLiterals.add((Object)refname)) {
            this.doAddSearchWordInLiterals(refname);
            return true;
        }
        return false;
    }

    protected abstract void doAddSearchWordInCode(String var1);

    protected abstract void doAddSearchWordInText(String var1);

    protected abstract void doAddSearchWordInComments(String var1);

    protected abstract void doAddSearchWordInLiterals(String var1);

    @Override
    public void endTransaction() {
        ++this.scanRequest;
    }

    @Override
    public boolean isScannedSomething() {
        return this.scanned.size() > 0 || this.scannedComments.size() > 0 || this.scannedLiterals.size() > 0;
    }
}

