/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.List;

public class MatchContext {
    private MatchResultSink sink;
    private final Stack<MatchResultImpl> previousResults = new Stack();
    private MatchResultImpl result;
    private CompiledPattern pattern;
    private MatchOptions options;
    private GlobalMatchingVisitor matcher;
    private boolean shouldRecursivelyMatch = true;
    private List<PsiElement> myMatchedNodes;
    private MatchedElementsListener myMatchedElementsListener;

    public List<PsiElement> getMatchedNodes() {
        return this.myMatchedNodes;
    }

    public void setMatchedNodes(List<PsiElement> matchedNodes) {
        this.myMatchedNodes = matchedNodes;
    }

    public void setMatcher(GlobalMatchingVisitor matcher) {
        this.matcher = matcher;
    }

    public GlobalMatchingVisitor getMatcher() {
        return this.matcher;
    }

    public MatchOptions getOptions() {
        return this.options;
    }

    public void setOptions(MatchOptions options) {
        this.options = options;
    }

    public MatchResultImpl getPreviousResult() {
        return this.previousResults.isEmpty() ? null : (MatchResultImpl)this.previousResults.peek();
    }

    public MatchResultImpl getResult() {
        if (this.result == null) {
            this.result = new MatchResultImpl();
        }
        return this.result;
    }

    public void pushResult() {
        this.previousResults.push((Object)this.result);
        this.result = null;
    }

    public void popResult() {
        this.result = (MatchResultImpl)this.previousResults.pop();
    }

    public void setResult(MatchResultImpl result) {
        this.result = result;
        if (result == null) {
            this.pattern.clearHandlersState();
        }
    }

    public boolean hasResult() {
        return this.result != null;
    }

    public CompiledPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(CompiledPattern pattern) {
        this.pattern = pattern;
    }

    public MatchResultSink getSink() {
        return this.sink;
    }

    public void setSink(MatchResultSink sink) {
        this.sink = sink;
    }

    public void clear() {
        this.result = null;
        this.pattern = null;
    }

    public boolean shouldRecursivelyMatch() {
        return this.shouldRecursivelyMatch;
    }

    public void setShouldRecursivelyMatch(boolean shouldRecursivelyMatch) {
        this.shouldRecursivelyMatch = shouldRecursivelyMatch;
    }

    public void setMatchedElementsListener(MatchedElementsListener _matchedElementsListener) {
        this.myMatchedElementsListener = _matchedElementsListener;
    }

    public MatchedElementsListener getMatchedElementsListener() {
        return this.myMatchedElementsListener;
    }

    public static interface MatchedElementsListener {
        public void matchedElements(Collection<PsiElement> var1);

        public void commitUnmatched();
    }
}

