/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeFragmentType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class FileBasedCodeFragmentType
implements CodeFragmentType {
    private final VirtualFile myFile;
    private final Project myProject;

    public FileBasedCodeFragmentType(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            FileBasedCodeFragmentType.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FileBasedCodeFragmentType.$$$reportNull$$$0(1);
        }
        this.myFile = file;
        this.myProject = project;
    }

    @Override
    public CompositeAppearance getTitle(boolean selected) {
        CompositeAppearance.DequeEnd ending = new CompositeAppearance().getEnding();
        ending.addText(this.myFile.getName(), BasicTreeNode.getTextAttributes(selected));
        VirtualFile parent = this.myFile.getParent();
        ending.addComment(FileBasedCodeFragmentType.getPresentablePath(parent, this.myProject), BasicTreeNode.getCommentAttributes(selected));
        return ending.getAppearance();
    }

    @NotNull
    private static String getPresentablePath(@NotNull VirtualFile file, @NotNull Project project) {
        ProjectRootManager projectRootManager;
        int contentRootCount;
        if (file == null) {
            FileBasedCodeFragmentType.$$$reportNull$$$0(2);
        }
        if (project == null) {
            FileBasedCodeFragmentType.$$$reportNull$$$0(3);
        }
        if ((contentRootCount = (projectRootManager = ProjectRootManager.getInstance((Project)project)).getContentRoots().length) == 0) {
            String string = file.getPath();
            if (string == null) {
                FileBasedCodeFragmentType.$$$reportNull$$$0(4);
            }
            return string;
        }
        VirtualFile contentRoot = projectRootManager.getFileIndex().getContentRootForFile(file);
        if (contentRoot == null) {
            String string = file.getPath();
            if (string == null) {
                FileBasedCodeFragmentType.$$$reportNull$$$0(5);
            }
            return string;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot, (char)'/');
        if (relativePath == null) {
            String string = file.getPath();
            if (string == null) {
                FileBasedCodeFragmentType.$$$reportNull$$$0(6);
            }
            return string;
        }
        String presentableRelativePath = contentRootCount == 1 ? relativePath : contentRoot.getName() + '/' + relativePath;
        String string = FileUtil.toSystemDependentName((String)(".../" + presentableRelativePath));
        if (string == null) {
            FileBasedCodeFragmentType.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/resultUI/FileBasedCodeFragmentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/resultUI/FileBasedCodeFragmentType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

