/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.analysis.AnalysisScope;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.ExternalIntegerKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesIndex
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.dupLocator.DuplicatesIndex");
    private static final int MAX_COST = 7000;
    private final PersistentMap<Integer, List<MyEntry>> myPersistentHashMap;
    private final DuplicatesProfile[] myProfiles;
    private final Project myProject;
    private final File myMapFile;

    public DuplicatesIndex(@NotNull Project project, @NotNull DuplicatesProfile[] profiles) throws IOException {
        if (project == null) {
            DuplicatesIndex.$$$reportNull$$$0(0);
        }
        if (profiles == null) {
            DuplicatesIndex.$$$reportNull$$$0(1);
        }
        this.myProfiles = profiles;
        this.myProject = project;
        this.myMapFile = ProjectUtil.getProjectCachePath((Project)project, (String)"duplicates").toFile();
        PersistentHashMap.deleteFilesStartingWith((File)this.myMapFile);
        this.myPersistentHashMap = new PersistentHashMap(this.myMapFile, (KeyDescriptor)new ExternalIntegerKeyDescriptor(), (DataExternalizer)new MyDataExternalizer());
        this.myPersistentHashMap.force();
    }

    public void dispose() {
        try {
            this.myPersistentHashMap.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        PersistentHashMap.deleteFilesStartingWith((File)this.myMapFile);
    }

    public void update(@NotNull AnalysisScope scope) {
        if (scope == null) {
            DuplicatesIndex.$$$reportNull$$$0(2);
        }
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        final int totalFiles = scope.getFileCount();
        if (indicator != null) {
            indicator.setText(DupLocatorBundle.message("duplicates.indexing.progress", new Object[0]));
        }
        scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
            private int myFileCount = 0;

            public void visitFile(PsiFile baseFile) {
                VirtualFile vFile;
                Project project = baseFile.getProject();
                ++this.myFileCount;
                if (indicator != null) {
                    VirtualFile virtualFile = baseFile.getVirtualFile();
                    if (virtualFile != null) {
                        String url = virtualFile.getPresentableUrl();
                        String path = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)url, (Project)project, (boolean)true, (boolean)false);
                        indicator.setText2(path);
                    }
                    indicator.setFraction((double)this.myFileCount / (double)totalFiles);
                }
                if ((vFile = baseFile.getVirtualFile()) == null) {
                    return;
                }
                MyIndexingFragmentsCollector collector = new MyIndexingFragmentsCollector();
                DuplocateVisitor[] visitors = DuplicatesIndex.createVisitors(DuplicatesIndex.this.myProfiles, collector);
                for (PsiFile file : baseFile.getViewProvider().getAllFiles()) {
                    for (DuplocateVisitor visitor : visitors) {
                        visitor.visitNode((PsiElement)file);
                    }
                    PsiManager psiManager = PsiManager.getInstance((Project)project);
                    psiManager.dropResolveCaches();
                    InjectedLanguageManager.getInstance((Project)project).dropFileCaches(file);
                }
                Map<Integer, Set<MyEntry>> map = collector.getResult();
                for (Integer hash : map.keySet()) {
                    Set<MyEntry> newEntries = map.get(hash);
                    try {
                        ArrayList<MyEntry> entries = (ArrayList<MyEntry>)DuplicatesIndex.this.myPersistentHashMap.get((Object)hash);
                        if (entries == null) {
                            entries = new ArrayList<MyEntry>();
                        }
                        entries.addAll(newEntries);
                        DuplicatesIndex.this.myPersistentHashMap.put((Object)hash, new ArrayList(entries));
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        });
    }

    public void processAll(@NotNull AnalysisScope scope, @NotNull FragmentsCollector collector) {
        if (scope == null) {
            DuplicatesIndex.$$$reportNull$$$0(3);
        }
        if (collector == null) {
            DuplicatesIndex.$$$reportNull$$$0(4);
        }
        try {
            TIntArrayList hashes = new TIntArrayList();
            this.myPersistentHashMap.processKeys(hash -> {
                hashes.add(hash.intValue());
                return true;
            });
            final Map<VirtualFile, Map<Language, TIntHashSet>> map = this.getMap(hashes);
            final DuplocateVisitor[] visitors = DuplicatesIndex.createVisitors(this.myProfiles, new MyProcessingFragmentsCollector(map, collector));
            final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setText(DupLocatorBundle.message("duplicates.searching.progress", new Object[0]));
            }
            final int totalFiles = map.size();
            final Set<VirtualFile> fileSet = map.keySet();
            scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
                private int myIndex = 0;

                public void visitFile(PsiFile baseFile) {
                    if (!baseFile.isValid()) {
                        return;
                    }
                    VirtualFile vFile = baseFile.getVirtualFile();
                    if (vFile == null || !fileSet.contains(vFile)) {
                        return;
                    }
                    if (indicator != null) {
                        String url = vFile.getPresentableUrl();
                        String path = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)vFile, (String)url, (Project)DuplicatesIndex.this.myProject, (boolean)true, (boolean)false);
                        indicator.setText2(path);
                        indicator.setFraction((double)this.myIndex / (double)totalFiles);
                    }
                    ++this.myIndex;
                    for (Language language : ((Map)map.get(vFile)).keySet()) {
                        PsiFile file = baseFile.getViewProvider().getPsi(language);
                        if (file == null || !file.isValid()) continue;
                        for (DuplocateVisitor visitor : visitors) {
                            visitor.visitNode((PsiElement)file);
                        }
                        PsiManager psiManager = PsiManager.getInstance((Project)DuplicatesIndex.this.myProject);
                        psiManager.dropResolveCaches();
                        InjectedLanguageManager.getInstance((Project)DuplicatesIndex.this.myProject).dropFileCaches(file);
                    }
                }
            });
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    private static TIntHashSet getFragmentsSet(@NotNull Map<VirtualFile, Map<Language, TIntHashSet>> map, @NotNull PsiFragment fragment) {
        Map<Language, TIntHashSet> language2ranges;
        VirtualFile vFile;
        PsiFile file;
        Language language;
        if (map == null) {
            DuplicatesIndex.$$$reportNull$$$0(5);
        }
        if (fragment == null) {
            DuplicatesIndex.$$$reportNull$$$0(6);
        }
        if ((language = fragment.getLanguage()) != null && (file = fragment.getFile()) != null && (vFile = file.getVirtualFile()) != null && (language2ranges = map.get(vFile)) != null) {
            return language2ranges.get(language);
        }
        return null;
    }

    private Map<VirtualFile, Map<Language, TIntHashSet>> getMap(@NotNull TIntArrayList hashes) throws IOException {
        if (hashes == null) {
            DuplicatesIndex.$$$reportNull$$$0(7);
        }
        HashMap result = new HashMap();
        int n = hashes.size();
        for (int i = 0; i < n; ++i) {
            int hash = hashes.get(i);
            List entries = (List)this.myPersistentHashMap.get((Object)hash);
            if (entries.size() < 2) continue;
            for (MyEntry entry : entries) {
                TIntHashSet rangesSet;
                PersistentFS fs;
                VirtualFile vFile;
                Language language;
                if (entry.getTextRanges().length == 0 || (language = Language.findLanguageByID((String)entry.getLanguageId())) == null || (vFile = IndexInfrastructure.findFileById((PersistentFS)(fs = (PersistentFS)ManagingFS.getInstance()), (int)entry.getFileId())) == null) continue;
                Map language2ranges = (Map)result.get(vFile);
                if (language2ranges == null) {
                    language2ranges = new HashMap();
                    result.put(vFile, language2ranges);
                }
                if ((rangesSet = (TIntHashSet)language2ranges.get(language)) == null) {
                    rangesSet = new TIntHashSet();
                    language2ranges.put(language, rangesSet);
                }
                rangesSet.add(DuplicatesIndex.computeHash(entry.getTextRanges()));
            }
        }
        Iterator it = result.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (((Map)entry.getValue()).size() != 0) continue;
            it.remove();
        }
        return result;
    }

    private static int computeHash(@NotNull TextRange[] ranges) {
        if (ranges == null) {
            DuplicatesIndex.$$$reportNull$$$0(8);
        }
        int result = 0;
        for (TextRange range : ranges) {
            result = result * 31 + range.getStartOffset();
            result = result * 31 + range.getEndOffset();
        }
        return result;
    }

    private static DuplocateVisitor[] createVisitors(DuplicatesProfile[] profiles, FragmentsCollector collector) {
        DuplocateVisitor[] visitors = new DuplocateVisitor[profiles.length];
        for (int i = 0; i < visitors.length; ++i) {
            visitors[i] = profiles[i].createVisitor(collector);
        }
        return visitors;
    }

    @NotNull
    private static TextRange[] getTextRanges(@NotNull PsiFragment fragment) {
        if (fragment == null) {
            DuplicatesIndex.$$$reportNull$$$0(9);
        }
        PsiElement[] elements = fragment.getElements();
        ArrayList<TextRange> ranges = new ArrayList<TextRange>(elements.length);
        for (PsiElement element : elements) {
            ranges.add(element != null ? element.getTextRange() : TextRange.EMPTY_RANGE);
        }
        TextRange[] textRangeArray = ranges.toArray(new TextRange[ranges.size()]);
        if (textRangeArray == null) {
            DuplicatesIndex.$$$reportNull$$$0(10);
        }
        return textRangeArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/DuplicatesIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/DuplicatesIndex";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFragmentsSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeHash";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextRanges";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyProcessingFragmentsCollector
    implements FragmentsCollector {
        private final Map<VirtualFile, Map<Language, TIntHashSet>> myMap;
        private final FragmentsCollector myCollector;

        public MyProcessingFragmentsCollector(Map<VirtualFile, Map<Language, TIntHashSet>> map, FragmentsCollector collector) {
            this.myMap = map;
            this.myCollector = collector;
        }

        @Override
        public void add(int hash, int cost, @Nullable PsiFragment frag) {
            TIntHashSet rangesSet;
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState(frag);
            if (duplocatorState == null) {
                return;
            }
            if (cost < duplocatorState.getLowerBound() || cost > 7000) {
                return;
            }
            if (frag != null && (rangesSet = DuplicatesIndex.getFragmentsSet(this.myMap, frag)) != null) {
                boolean shouldAdd = false;
                TextRange[] textRanges = DuplicatesIndex.getTextRanges(frag);
                int rangesHash = DuplicatesIndex.computeHash(textRanges);
                if (rangesSet.contains(rangesHash)) {
                    shouldAdd = true;
                }
                if (shouldAdd) {
                    this.myCollector.add(hash, cost, frag);
                }
                return;
            }
            this.myCollector.add(hash, cost, frag);
        }
    }

    private static class MyIndexingFragmentsCollector
    implements FragmentsCollector {
        private final Map<Integer, Set<MyEntry>> myMap = new HashMap();

        private MyIndexingFragmentsCollector() {
        }

        @NotNull
        public Map<Integer, Set<MyEntry>> getResult() {
            Map<Integer, Set<MyEntry>> map = this.myMap;
            if (map == null) {
                MyIndexingFragmentsCollector.$$$reportNull$$$0(0);
            }
            return map;
        }

        @Override
        public void add(int hash, int cost, @Nullable PsiFragment frag) {
            if (frag == null) {
                return;
            }
            PsiFile file = frag.getFile();
            if (file == null) {
                return;
            }
            VirtualFile vFile = file.getVirtualFile();
            if (vFile == null) {
                return;
            }
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState(frag);
            if (duplocatorState == null) {
                return;
            }
            int lowerBound = duplocatorState.getLowerBound();
            if (cost < lowerBound || cost > 7000) {
                return;
            }
            TextRange[] textRanges = DuplicatesIndex.getTextRanges(frag);
            Language language = frag.getLanguage();
            if (language == null) {
                return;
            }
            HashSet entrySet = this.myMap.get(hash);
            if (entrySet == null) {
                entrySet = new HashSet();
                this.myMap.put(hash, (Set<MyEntry>)entrySet);
            }
            int fileId = FileBasedIndex.getFileId((VirtualFile)vFile);
            entrySet.add(new MyEntry(fileId, language.getID(), textRanges));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/DuplicatesIndex$MyIndexingFragmentsCollector", "getResult"));
        }
    }

    private static class MyDataExternalizer
    implements DataExternalizer<List<MyEntry>> {
        private MyDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, List<MyEntry> entryList) throws IOException {
            if (out == null) {
                MyDataExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(entryList.size());
            for (MyEntry entry : entryList) {
                out.writeInt(entry.getFileId());
                out.writeUTF(entry.getLanguageId());
                TextRange[] textRanges = entry.getTextRanges();
                out.writeInt(textRanges.length);
                for (TextRange textRange : textRanges) {
                    if (textRange == null) {
                        out.writeInt(0);
                        out.writeInt(0);
                        continue;
                    }
                    out.writeInt(textRange.getStartOffset());
                    out.writeInt(textRange.getEndOffset());
                }
            }
        }

        public List<MyEntry> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyDataExternalizer.$$$reportNull$$$0(1);
            }
            int entriesCount = in.readInt();
            ArrayList<MyEntry> entryList = new ArrayList<MyEntry>(entriesCount);
            for (int i = 0; i < entriesCount; ++i) {
                int fileId = in.readInt();
                String languageId = in.readUTF();
                int textRangesCount = in.readInt();
                TextRange[] textRanges = new TextRange[textRangesCount];
                for (int j = 0; j < textRangesCount; ++j) {
                    int startOffset = in.readInt();
                    int endOffset = in.readInt();
                    textRanges[j] = startOffset == -1 || endOffset == -1 ? null : new TextRange(startOffset, endOffset);
                }
                MyEntry entry = new MyEntry(fileId, languageId, textRanges);
                entryList.add(entry);
            }
            return entryList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dupLocator/DuplicatesIndex$MyDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyEntry {
        private final int myFileId;
        private final String myLanguageId;
        private final TextRange[] myTextRanges;

        private MyEntry(int fileId, @NotNull String languageId, @NotNull TextRange[] textRanges) {
            if (languageId == null) {
                MyEntry.$$$reportNull$$$0(0);
            }
            if (textRanges == null) {
                MyEntry.$$$reportNull$$$0(1);
            }
            this.myFileId = fileId;
            this.myLanguageId = languageId;
            this.myTextRanges = textRanges;
        }

        public int getFileId() {
            return this.myFileId;
        }

        @NotNull
        public String getLanguageId() {
            String string = this.myLanguageId;
            if (string == null) {
                MyEntry.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public TextRange[] getTextRanges() {
            if (this.myTextRanges == null) {
                MyEntry.$$$reportNull$$$0(3);
            }
            return this.myTextRanges;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyEntry myEntry = (MyEntry)o;
            if (this.myFileId != myEntry.myFileId) {
                return false;
            }
            if (!this.myLanguageId.equals(myEntry.myLanguageId)) {
                return false;
            }
            return Arrays.equals(this.myTextRanges, myEntry.myTextRanges);
        }

        public int hashCode() {
            int result = this.myFileId;
            result = 31 * result + this.myLanguageId.hashCode();
            result = 31 * result + Arrays.hashCode(this.myTextRanges);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRanges";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dupLocator/DuplicatesIndex$MyEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dupLocator/DuplicatesIndex$MyEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguageId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

