/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.TimingLog;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsElementExtensionSerializerBase;
import org.jetbrains.jps.model.serialization.JpsLoaderBase;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.PathMacroUtil;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactSerializer;
import org.jetbrains.jps.model.serialization.facet.JpsFacetSerializer;
import org.jetbrains.jps.model.serialization.impl.JpsModuleSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.impl.JpsProjectSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.library.JpsLibraryTableSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkTableSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleClasspathSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModulePropertiesSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleRootModelSerializer;
import org.jetbrains.jps.model.serialization.runConfigurations.JpsRunConfigurationSerializer;
import org.jetbrains.jps.service.SharedThreadPool;

public class JpsProjectLoader
extends JpsLoaderBase {
    private static final Logger LOG = Logger.getInstance(JpsProjectLoader.class);
    private static final BoundedTaskExecutor ourThreadPool = new BoundedTaskExecutor("JpsProjectLoader pool", (Executor)SharedThreadPool.getInstance(), Runtime.getRuntime().availableProcessors());
    public static final String CLASSPATH_ATTRIBUTE = "classpath";
    public static final String CLASSPATH_DIR_ATTRIBUTE = "classpath-dir";
    private final JpsProject myProject;
    private final Map<String, String> myPathVariables;
    private final boolean myLoadUnloadedModules;

    private JpsProjectLoader(JpsProject project, Map<String, String> pathVariables, Path baseDir, boolean loadUnloadedModules) {
        super(JpsProjectLoader.createProjectMacroExpander(pathVariables, baseDir));
        this.myProject = project;
        this.myPathVariables = pathVariables;
        this.myProject.getContainer().setChild(JpsProjectSerializationDataExtensionImpl.ROLE, (JpsElement)new JpsProjectSerializationDataExtensionImpl(baseDir));
        this.myLoadUnloadedModules = loadUnloadedModules;
    }

    static JpsMacroExpander createProjectMacroExpander(Map<String, String> pathVariables, @NotNull Path baseDir) {
        if (baseDir == null) {
            JpsProjectLoader.$$$reportNull$$$0(0);
        }
        JpsMacroExpander expander = new JpsMacroExpander(pathVariables);
        expander.addFileHierarchyReplacements("PROJECT_DIR", baseDir.toFile());
        return expander;
    }

    public static void loadProject(JpsProject project, Map<String, String> pathVariables, String projectPath) throws IOException {
        JpsProjectLoader.loadProject(project, pathVariables, projectPath, false);
    }

    public static void loadProject(JpsProject project, Map<String, String> pathVariables, String projectPath, boolean loadUnloadedModules) throws IOException {
        Path file = Paths.get(FileUtil.toCanonicalPath((String)projectPath), new String[0]);
        if (Files.isRegularFile(file, new LinkOption[0]) && projectPath.endsWith(".ipr")) {
            new JpsProjectLoader(project, pathVariables, file.getParent(), loadUnloadedModules).loadFromIpr(file);
        } else {
            Path directory;
            Path dotIdea = file.resolve(".idea");
            if (Files.isDirectory(dotIdea, new LinkOption[0])) {
                directory = dotIdea;
            } else if (Files.isDirectory(file, new LinkOption[0]) && file.endsWith(".idea")) {
                directory = file;
            } else {
                throw new IOException("Cannot find IntelliJ IDEA project files at " + projectPath);
            }
            new JpsProjectLoader(project, pathVariables, directory.getParent(), loadUnloadedModules).loadFromDirectory(directory);
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static String getDirectoryBaseProjectName(@NotNull Path dir) {
        block25: {
            Throwable throwable;
            Stream<String> stream;
            block22: {
                String string;
                block23: {
                    block24: {
                        if (dir == null) {
                            JpsProjectLoader.$$$reportNull$$$0(1);
                        }
                        stream = Files.lines(dir.resolve(".name"));
                        throwable = null;
                        String value = stream.findFirst().map(String::trim).orElse(null);
                        if (value == null) break block22;
                        string = value;
                        if (stream == null) break block23;
                        if (throwable == null) break block24;
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block23;
                    }
                    stream.close();
                }
                String string2 = string;
                if (string2 == null) {
                    JpsProjectLoader.$$$reportNull$$$0(2);
                }
                return string2;
            }
            try {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
                break block25;
                {
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (stream != null) {
                                if (throwable != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string = dir.getParent().getFileName().toString();
        if (string == null) {
            JpsProjectLoader.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    protected Element loadRootElement(@NotNull Path file) {
        if (file == null) {
            JpsProjectLoader.$$$reportNull$$$0(4);
        }
        return super.loadRootElement(file);
    }

    @Override
    @Nullable
    protected <E extends JpsElement> Element loadComponentData(@NotNull JpsElementExtensionSerializerBase<E> serializer, @NotNull Path configFile) {
        if (serializer == null) {
            JpsProjectLoader.$$$reportNull$$$0(5);
        }
        if (configFile == null) {
            JpsProjectLoader.$$$reportNull$$$0(6);
        }
        Path externalConfigDir = JpsProjectLoader.resolveExternalProjectConfig("project");
        Element data = super.loadComponentData(serializer, configFile);
        if (externalConfigDir != null && serializer.getComponentName().equals("CompilerConfiguration")) {
            Element externalData = JDomSerializationUtil.findComponent(this.loadRootElement(externalConfigDir.resolve(configFile.getFileName())), "External" + serializer.getComponentName());
            if (data == null) {
                return externalData;
            }
            if (externalData != null) {
                return JDOMUtil.deepMerge((Element)data, (Element)externalData);
            }
        }
        return data;
    }

    private void loadFromDirectory(@NotNull Path dir) {
        Element externalModuleData;
        if (dir == null) {
            JpsProjectLoader.$$$reportNull$$$0(7);
        }
        this.myProject.setName(JpsProjectLoader.getDirectoryBaseProjectName(dir));
        Path defaultConfigFile = dir.resolve("misc.xml");
        JpsSdkType<?> projectSdkType = this.loadProjectRoot(this.loadRootElement(defaultConfigFile));
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsProjectExtensionSerializer jpsProjectExtensionSerializer : extension.getProjectExtensionSerializers()) {
                this.loadComponents(dir, defaultConfigFile, jpsProjectExtensionSerializer, this.myProject);
            }
        }
        Path externalConfigDir = JpsProjectLoader.resolveExternalProjectConfig("project");
        if (externalConfigDir != null) {
            LOG.info("External project config dir is used: " + externalConfigDir);
        }
        Element moduleData = JDomSerializationUtil.findComponent(this.loadRootElement(dir.resolve("modules.xml")), "ProjectModuleManager");
        if (externalConfigDir == null) {
            externalModuleData = null;
        } else {
            Element element = this.loadRootElement(externalConfigDir.resolve("modules.xml"));
            if (element == null) {
                externalModuleData = null;
            } else {
                externalModuleData = JDomSerializationUtil.findComponent(element, "ExternalProjectModuleManager");
                if (externalModuleData == null) {
                    externalModuleData = JDomSerializationUtil.findComponent(element, "ExternalModuleListStorage");
                }
                if (externalModuleData == null && element.getName().equals("component")) {
                    externalModuleData = element;
                }
            }
        }
        if (externalModuleData != null) {
            String string = externalModuleData.getAttributeValue("name");
            LOG.assertTrue(string != null && string.startsWith("External"));
            externalModuleData.setAttribute("name", string.substring("External".length()));
            if (moduleData == null) {
                moduleData = externalModuleData;
            } else {
                JDOMUtil.deepMerge((Element)moduleData, (Element)externalModuleData);
            }
        }
        Path path = dir.resolve("workspace.xml");
        this.loadModules(moduleData, projectSdkType, path);
        Runnable timingLog = TimingLog.startActivity("loading project libraries");
        for (Path path2 : JpsProjectLoader.listXmlFiles(dir.resolve("libraries"))) {
            this.loadProjectLibraries(this.loadRootElement(path2));
        }
        if (externalConfigDir != null) {
            this.loadProjectLibraries(this.loadRootElement(externalConfigDir.resolve("libraries.xml")));
        }
        timingLog.run();
        Runnable artifactsTimingLog = TimingLog.startActivity("loading artifacts");
        for (Path artifactFile : JpsProjectLoader.listXmlFiles(dir.resolve("artifacts"))) {
            this.loadArtifacts(this.loadRootElement(artifactFile));
        }
        artifactsTimingLog.run();
        if (JpsProjectLoader.hasRunConfigurationSerializers()) {
            Runnable runnable = TimingLog.startActivity("loading run configurations");
            for (Path configurationFile : JpsProjectLoader.listXmlFiles(dir.resolve("runConfigurations"))) {
                JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, this.loadRootElement(configurationFile));
            }
            JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, JDomSerializationUtil.findComponent(this.loadRootElement(path), "RunManager"));
            runnable.run();
        }
    }

    private static boolean hasRunConfigurationSerializers() {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            if (extension.getRunConfigurationPropertiesSerializers().isEmpty()) continue;
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static List<Path> listXmlFiles(@NotNull Path dir) {
        List list;
        Throwable throwable;
        DirectoryStream<Path> stream;
        block17: {
            block18: {
                if (dir == null) {
                    JpsProjectLoader.$$$reportNull$$$0(8);
                }
                stream = Files.newDirectoryStream(dir, it -> it.getFileName().toString().endsWith(".xml") && Files.isRegularFile(it, new LinkOption[0]));
                throwable = null;
                list = ContainerUtil.collect(stream.iterator());
                if (stream == null) break block17;
                if (throwable == null) break block18;
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block17;
            }
            stream.close();
        }
        List list2 = list;
        if (list2 == null) {
            JpsProjectLoader.$$$reportNull$$$0(9);
        }
        return list2;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (stream != null) {
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                stream.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    List<Path> list3 = Collections.emptyList();
                    if (list3 == null) {
                        JpsProjectLoader.$$$reportNull$$$0(10);
                    }
                    return list3;
                }
            }
        }
    }

    private void loadFromIpr(@NotNull Path iprFile) {
        if (iprFile == null) {
            JpsProjectLoader.$$$reportNull$$$0(11);
        }
        Element iprRoot = this.loadRootElement(iprFile);
        String projectName = FileUtil.getNameWithoutExtension((String)iprFile.getFileName().toString());
        this.myProject.setName(projectName);
        Path iwsFile = iprFile.getParent().resolve(projectName + ".iws");
        Element iwsRoot = this.loadRootElement(iwsFile);
        JpsSdkType<?> projectSdkType = this.loadProjectRoot(iprRoot);
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsProjectExtensionSerializer jpsProjectExtensionSerializer : extension.getProjectExtensionSerializers()) {
                Element rootTag = "workspace.xml".equals(jpsProjectExtensionSerializer.getConfigFileName()) ? iwsRoot : iprRoot;
                Element component = JDomSerializationUtil.findComponent(rootTag, jpsProjectExtensionSerializer.getComponentName());
                if (component != null) {
                    jpsProjectExtensionSerializer.loadExtension(this.myProject, component);
                    continue;
                }
                jpsProjectExtensionSerializer.loadExtensionWithDefaultSettings(this.myProject);
            }
        }
        this.loadModules(JDomSerializationUtil.findComponent(iprRoot, "ProjectModuleManager"), projectSdkType, iwsFile);
        this.loadProjectLibraries(JDomSerializationUtil.findComponent(iprRoot, "libraryTable"));
        this.loadArtifacts(JDomSerializationUtil.findComponent(iprRoot, "ArtifactManager"));
        if (JpsProjectLoader.hasRunConfigurationSerializers()) {
            JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, JDomSerializationUtil.findComponent(iprRoot, "ProjectRunConfigurationManager"));
            JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, JDomSerializationUtil.findComponent(iwsRoot, "RunManager"));
        }
    }

    private void loadArtifacts(@Nullable Element artifactManagerComponent) {
        JpsArtifactSerializer.loadArtifacts(this.myProject, artifactManagerComponent);
    }

    @Nullable
    private JpsSdkType<?> loadProjectRoot(@Nullable Element root) {
        JpsSdkType<?> sdkType = null;
        Element rootManagerElement = JDomSerializationUtil.findComponent(root, "ProjectRootManager");
        if (rootManagerElement != null) {
            String sdkName = rootManagerElement.getAttributeValue("project-jdk-name");
            String sdkTypeId = rootManagerElement.getAttributeValue("project-jdk-type");
            if (sdkName != null) {
                sdkType = JpsSdkTableSerializer.getSdkType(sdkTypeId);
                JpsSdkTableSerializer.setSdkReference(this.myProject.getSdkReferencesTable(), sdkName, sdkType);
            }
        }
        return sdkType;
    }

    private void loadProjectLibraries(@Nullable Element libraryTableElement) {
        JpsLibraryTableSerializer.loadLibraries(libraryTableElement, this.myProject.getLibraryCollection());
    }

    private void loadModules(@Nullable Element componentElement, @Nullable JpsSdkType<?> projectSdkType, @NotNull Path workspaceFile) {
        if (workspaceFile == null) {
            JpsProjectLoader.$$$reportNull$$$0(12);
        }
        Runnable timingLog = TimingLog.startActivity("loading modules");
        if (componentElement == null) {
            return;
        }
        HashSet<String> unloadedModules = new HashSet<String>();
        if (!this.myLoadUnloadedModules && Files.exists(workspaceFile, new LinkOption[0])) {
            Element unloadedModulesList = JDomSerializationUtil.findComponent(this.loadRootElement(workspaceFile), "UnloadedModulesList");
            for (Element element : JDOMUtil.getChildren((Element)unloadedModulesList, (String)"module")) {
                unloadedModules.add(element.getAttributeValue("name"));
            }
        }
        THashSet foundFiles = new THashSet();
        ArrayList<Path> moduleFiles = new ArrayList<Path>();
        for (Element moduleElement : JDOMUtil.getChildren((Element)componentElement.getChild("modules"), (String)"module")) {
            String path = moduleElement.getAttributeValue("filepath");
            Path file = Paths.get(path, new String[0]);
            if (!foundFiles.add(file) || unloadedModules.contains(JpsProjectLoader.getModuleName(file))) continue;
            moduleFiles.add(file);
        }
        List<JpsModule> modules = JpsProjectLoader.loadModules(moduleFiles, projectSdkType, this.myPathVariables);
        for (JpsModule module : modules) {
            this.myProject.addModule(module);
        }
        timingLog.run();
    }

    @Nullable
    private static Path resolveExternalProjectConfig(@NotNull String subDirName) {
        String externalProjectConfigDir;
        if (subDirName == null) {
            JpsProjectLoader.$$$reportNull$$$0(13);
        }
        return StringUtil.isEmptyOrSpaces((String)(externalProjectConfigDir = System.getProperty("external.project.config"))) ? null : Paths.get(externalProjectConfigDir, subDirName);
    }

    @NotNull
    public static List<JpsModule> loadModules(@NotNull List<Path> moduleFiles, @Nullable JpsSdkType<?> projectSdkType, @NotNull Map<String, String> pathVariables) {
        ArrayList<JpsModule> arrayList;
        if (moduleFiles == null) {
            JpsProjectLoader.$$$reportNull$$$0(14);
        }
        if (pathVariables == null) {
            JpsProjectLoader.$$$reportNull$$$0(15);
        }
        ArrayList<JpsModule> modules = new ArrayList<JpsModule>();
        ArrayList<Future> futureModuleFilesContents = new ArrayList<Future>();
        Path externalModuleDir = JpsProjectLoader.resolveExternalProjectConfig("modules");
        if (externalModuleDir != null) {
            LOG.info("External project config dir is used for modules: " + externalModuleDir);
        }
        for (Path path : moduleFiles) {
            futureModuleFilesContents.add(ourThreadPool.submit(() -> {
                Element externalData;
                if (pathVariables == null) {
                    JpsProjectLoader.$$$reportNull$$$0(24);
                }
                JpsMacroExpander expander = JpsProjectLoader.createModuleMacroExpander(pathVariables, path);
                Element data = JpsProjectLoader.loadRootElement(path, expander);
                Path externalPath = externalModuleDir == null ? null : externalModuleDir.resolve(FileUtilRt.getNameWithoutExtension((String)path.getFileName().toString()) + ".xml");
                Element element = externalData = externalPath == null ? null : JpsProjectLoader.loadRootElement(externalPath, expander);
                if (externalData != null) {
                    if (data == null) {
                        data = externalData;
                    } else {
                        JDOMUtil.merge((Element)data, (Element)externalData);
                    }
                }
                if (data == null) {
                    LOG.info("Module '" + JpsProjectLoader.getModuleName(path) + "' is skipped: " + path.toAbsolutePath() + " doesn't exist");
                }
                return Pair.create((Object)path, (Object)data);
            }));
        }
        try {
            ArrayList<String> classpathDirs = new ArrayList<String>();
            for (Future moduleFile : futureModuleFilesContents) {
                String classpathDir;
                Element rootElement = (Element)((Pair)moduleFile.get()).getSecond();
                if (rootElement == null || (classpathDir = rootElement.getAttributeValue(CLASSPATH_DIR_ATTRIBUTE)) == null) continue;
                classpathDirs.add(classpathDir);
            }
            ArrayList<Future> arrayList2 = new ArrayList<Future>();
            for (Future futureModuleFile : futureModuleFilesContents) {
                Pair moduleFile = (Pair)futureModuleFile.get();
                if (moduleFile.getSecond() == null) continue;
                arrayList2.add(ourThreadPool.submit(() -> {
                    if (pathVariables == null) {
                        JpsProjectLoader.$$$reportNull$$$0(23);
                    }
                    return JpsProjectLoader.loadModule((Path)moduleFile.getFirst(), (Element)moduleFile.getSecond(), classpathDirs, projectSdkType, pathVariables);
                }));
            }
            for (Future future : arrayList2) {
                JpsModule module = (JpsModule)future.get();
                if (module == null) continue;
                modules.add(module);
            }
            arrayList = modules;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (arrayList == null) {
            JpsProjectLoader.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private static JpsModule loadModule(@NotNull Path file, @NotNull Element moduleRoot, List<String> paths, @Nullable JpsSdkType<?> projectSdkType, Map<String, String> pathVariables) {
        if (file == null) {
            JpsProjectLoader.$$$reportNull$$$0(17);
        }
        if (moduleRoot == null) {
            JpsProjectLoader.$$$reportNull$$$0(18);
        }
        String name = JpsProjectLoader.getModuleName(file);
        String typeId = moduleRoot.getAttributeValue("type");
        JpsModulePropertiesSerializer<?> serializer = JpsProjectLoader.getModulePropertiesSerializer(typeId);
        JpsModule module = JpsProjectLoader.createModule(name, moduleRoot, serializer);
        module.getContainer().setChild(JpsModuleSerializationDataExtensionImpl.ROLE, (JpsElement)new JpsModuleSerializationDataExtensionImpl(file.getParent()));
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            extension.loadModuleOptions(module, moduleRoot);
        }
        String baseModulePath = FileUtil.toSystemIndependentName((String)file.getParent().toString());
        String classpath = moduleRoot.getAttributeValue(CLASSPATH_ATTRIBUTE);
        if (classpath == null) {
            JpsModuleRootModelSerializer.loadRootModel(module, JDomSerializationUtil.findComponent(moduleRoot, "NewModuleRootManager"), projectSdkType);
        } else {
            for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
                JpsModuleClasspathSerializer classpathSerializer = extension.getClasspathSerializer();
                if (classpathSerializer == null || !classpathSerializer.getClasspathId().equals(classpath)) continue;
                String classpathDir = moduleRoot.getAttributeValue(CLASSPATH_DIR_ATTRIBUTE);
                JpsMacroExpander expander = JpsProjectLoader.createModuleMacroExpander(pathVariables, file);
                classpathSerializer.loadClasspath(module, classpathDir, baseModulePath, expander, paths, projectSdkType);
            }
        }
        JpsFacetSerializer.loadFacets(module, JDomSerializationUtil.findComponent(moduleRoot, "FacetManager"));
        JpsModule jpsModule = module;
        if (jpsModule == null) {
            JpsProjectLoader.$$$reportNull$$$0(19);
        }
        return jpsModule;
    }

    @NotNull
    private static String getModuleName(@NotNull Path file) {
        if (file == null) {
            JpsProjectLoader.$$$reportNull$$$0(20);
        }
        String string = FileUtil.getNameWithoutExtension((String)file.getFileName().toString());
        if (string == null) {
            JpsProjectLoader.$$$reportNull$$$0(21);
        }
        return string;
    }

    static JpsMacroExpander createModuleMacroExpander(Map<String, String> pathVariables, @NotNull Path moduleFile) {
        if (moduleFile == null) {
            JpsProjectLoader.$$$reportNull$$$0(22);
        }
        JpsMacroExpander expander = new JpsMacroExpander(pathVariables);
        String moduleDirPath = PathMacroUtil.getModuleDir(moduleFile.toAbsolutePath().toString());
        if (moduleDirPath != null) {
            expander.addFileHierarchyReplacements("MODULE_DIR", new File(FileUtil.toSystemDependentName((String)moduleDirPath)));
        }
        return expander;
    }

    private static <P extends JpsElement> JpsModule createModule(String name, Element moduleRoot, JpsModulePropertiesSerializer<P> loader) {
        String componentName = loader.getComponentName();
        Element component = componentName != null ? JDomSerializationUtil.findComponent(moduleRoot, componentName) : null;
        return JpsElementFactory.getInstance().createModule(name, (JpsModuleType)loader.getType(), loader.loadProperties(component));
    }

    private static JpsModulePropertiesSerializer<?> getModulePropertiesSerializer(@Nullable String typeId) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsModulePropertiesSerializer<?> loader : extension.getModulePropertiesSerializers()) {
                if (!loader.getTypeId().equals(typeId)) continue;
                return loader;
            }
        }
        return new JpsModulePropertiesSerializer<JpsDummyElement>((JpsModuleType)JpsJavaModuleType.INSTANCE, "JAVA_MODULE", null){

            @Override
            public JpsDummyElement loadProperties(@Nullable Element componentElement) {
                return JpsElementFactory.getInstance().createDummyElement();
            }

            @Override
            public void saveProperties(@NotNull JpsDummyElement properties, @NotNull Element componentElement) {
                if (properties == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (componentElement == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "properties";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "componentElement";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/jps/model/serialization/JpsProjectLoader$1";
                objectArray[2] = "saveProperties";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/JpsProjectLoader";
                break;
            }
            case 4: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iprFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDirName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFiles";
                break;
            }
            case 15: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathVariables";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsProjectLoader";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryBaseProjectName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "listXmlFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModules";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModule";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProjectMacroExpander";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryBaseProjectName";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadRootElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadComponentData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadFromDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "listXmlFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadFromIpr";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadModules";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveExternalProjectConfig";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadModule";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createModuleMacroExpander";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadModules$2";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadModules$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

