/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.resin.configuration;

import com.intellij.execution.ExecutionException;
import java.io.InputStream;
import org.intellij.j2ee.web.resin.ResinModel;
import org.intellij.j2ee.web.resin.resin.ResinInstallation;
import org.intellij.j2ee.web.resin.resin.WebApp;
import org.intellij.j2ee.web.resin.resin.configuration.Resin2XConfigurationStrategy;
import org.intellij.j2ee.web.resin.resin.configuration.Resin31ConfigurationStrategy;
import org.intellij.j2ee.web.resin.resin.configuration.Resin3XConfigurationStrategy;
import org.intellij.j2ee.web.resin.resin.configuration.Resin4XmlConfigurationStrategy;
import org.intellij.j2ee.web.resin.resin.configuration.ResinXmlConfigurationStrategy;
import org.jdom.Document;

public abstract class ResinConfigurationStrategy {
    private Document myDocument;

    public void init(ResinModel serverModel, Document document) throws ExecutionException {
        this.myDocument = document;
    }

    protected final Document getDocument() {
        return this.myDocument;
    }

    public void save() throws ExecutionException {
    }

    public abstract void setPort(int var1);

    public abstract boolean deploy(WebApp var1) throws ExecutionException;

    public abstract boolean undeploy(WebApp var1) throws ExecutionException;

    public abstract InputStream getDefaultResinConfContent();

    public String getServerId() {
        return null;
    }

    public static ResinConfigurationStrategy getForInstallation(ResinInstallation installation) {
        String verNumber = installation.getVersion().getVersionNumber();
        int resinVersion = Integer.parseInt(verNumber.substring(0, verNumber.indexOf(46)));
        int buildVersion = Integer.parseInt(verNumber.substring(2, 3));
        switch (resinVersion) {
            case 2: {
                return new Resin2XConfigurationStrategy();
            }
            case 3: {
                switch (buildVersion) {
                    case 0: {
                        return new Resin3XConfigurationStrategy(installation);
                    }
                    case 1: {
                        return new Resin31ConfigurationStrategy(installation);
                    }
                }
                return new ResinXmlConfigurationStrategy(installation);
            }
            case 4: {
                return new Resin4XmlConfigurationStrategy(installation);
            }
        }
        return new Resin3XConfigurationStrategy(installation);
    }
}

