/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.resin;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.intellij.j2ee.web.resin.ResinBundle;
import org.intellij.j2ee.web.resin.resin.version.ResinLibCollector;
import org.intellij.j2ee.web.resin.resin.version.ResinVersion;
import org.intellij.j2ee.web.resin.resin.version.ResinVersionDetector;

public class ResinInstallation {
    private final File myHome;
    private final File myLib;

    public static ResinInstallation create(String homePath) throws ExecutionException {
        File home = new File(FileUtil.toSystemDependentName((String)homePath));
        if (!ResinInstallation.isExistingDir(home)) {
            throw new ExecutionException(ResinBundle.message("message.error.resin.home.doesnt.exist", new Object[0]));
        }
        File bin = new File(home, "bin");
        if (!ResinInstallation.isExistingDir(bin)) {
            throw new ExecutionException(ResinBundle.message("message.error.resin.bin.doesnt.exist", new Object[0]));
        }
        File lib = new File(home, "lib");
        if (!ResinInstallation.isExistingDir(lib)) {
            throw new ExecutionException(ResinBundle.message("message.error.resin.lib.doesnt.exist", new Object[0]));
        }
        return new ResinInstallation(home, lib);
    }

    private static boolean isExistingDir(File dirCandidate) {
        return dirCandidate.exists() && dirCandidate.isDirectory();
    }

    private ResinInstallation(File home, File lib) {
        this.myHome = home;
        this.myLib = lib;
    }

    public ResinVersion getVersion() {
        return ResinVersionDetector.getResinVersion(this.myHome);
    }

    public boolean isVersionDetected() {
        ResinVersion ver = this.getVersion();
        return ver != null && !ver.equals(ResinVersion.UNKNOWN_VERSION);
    }

    public File getResinHome() {
        return this.myHome;
    }

    public String getDisplayName() {
        return this.getVersion().toString();
    }

    public File[] getLibFiles(boolean all) {
        return ResinLibCollector.getLibFiles(this.myLib, all);
    }
}

