/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControlBuilder;
import org.jetbrains.plugins.gradle.service.settings.GradleSystemSettingsControlBuilder;
import org.jetbrains.plugins.gradle.service.settings.IdeaGradleProjectSettingsControlBuilder;
import org.jetbrains.plugins.gradle.service.settings.IdeaGradleSystemSettingsControlBuilder;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public abstract class GradleSettingsControlProvider {
    private static final ExtensionPointName<GradleSettingsControlProvider> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.plugins.gradle.settingsControlProvider");

    public abstract String getPlatformPrefix();

    public abstract GradleSystemSettingsControlBuilder getSystemSettingsControlBuilder(@NotNull GradleSettings var1);

    public abstract GradleProjectSettingsControlBuilder getProjectSettingsControlBuilder(@NotNull GradleProjectSettings var1);

    @NotNull
    public static GradleSettingsControlProvider get() {
        GradleSettingsControlProvider result = null;
        if (!PlatformUtils.isIntelliJ()) {
            String platformPrefix = PlatformUtils.getPlatformPrefix();
            for (GradleSettingsControlProvider provider : (GradleSettingsControlProvider[])EP_NAME.getExtensions()) {
                if (!StringUtil.equals((CharSequence)platformPrefix, (CharSequence)provider.getPlatformPrefix())) continue;
                assert (result == null) : "Multiple GradleSettingsControlProvider extensions found";
                result = provider;
            }
        }
        GradleSettingsControlProvider gradleSettingsControlProvider = (GradleSettingsControlProvider)ObjectUtils.notNull(result, (Object)new GradleSettingsControlProvider(){

            @Override
            public String getPlatformPrefix() {
                return null;
            }

            @Override
            public GradleSystemSettingsControlBuilder getSystemSettingsControlBuilder(@NotNull GradleSettings initialSettings) {
                if (initialSettings == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new IdeaGradleSystemSettingsControlBuilder(initialSettings);
            }

            @Override
            public GradleProjectSettingsControlBuilder getProjectSettingsControlBuilder(@NotNull GradleProjectSettings initialSettings) {
                if (initialSettings == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new IdeaGradleProjectSettingsControlBuilder(initialSettings).dropUseBundledDistributionButton();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "initialSettings";
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/settings/GradleSettingsControlProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getSystemSettingsControlBuilder";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getProjectSettingsControlBuilder";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (gradleSettingsControlProvider == null) {
            GradleSettingsControlProvider.$$$reportNull$$$0(0);
        }
        return gradleSettingsControlProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/GradleSettingsControlProvider", "get"));
    }
}

