/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.gradle.initialization.BuildLayoutParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleAutoImportAware
implements ExternalSystemAutoImportAware {
    @Nullable
    public String getAffectedExternalProjectPath(@NotNull String changedFileOrDirPath, @NotNull Project project) {
        if (changedFileOrDirPath == null) {
            GradleAutoImportAware.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleAutoImportAware.$$$reportNull$$$0(1);
        }
        if (!changedFileOrDirPath.endsWith("gradle")) {
            return null;
        }
        File file = new File(changedFileOrDirPath);
        if (file.isDirectory()) {
            return null;
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        assert (manager != null);
        AbstractExternalSystemSettings systemSettings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
        Collection projectsSettings = systemSettings.getLinkedProjectsSettings();
        if (projectsSettings.isEmpty()) {
            return null;
        }
        HashMap rootPaths = ContainerUtil.newHashMap();
        for (ExternalProjectSettings setting : projectsSettings) {
            if (setting == null) continue;
            for (String path : setting.getModules()) {
                rootPaths.put(new File(path).getAbsolutePath(), setting.getExternalProjectPath());
            }
        }
        for (File f = file.getParentFile(); f != null; f = f.getParentFile()) {
            String dirPath = f.getAbsolutePath();
            if (!rootPaths.containsKey(dirPath)) continue;
            return (String)rootPaths.get(dirPath);
        }
        return null;
    }

    public List<File> getAffectedExternalProjectFiles(String projectPath, @NotNull Project project) {
        if (project == null) {
            GradleAutoImportAware.$$$reportNull$$$0(2);
        }
        SmartList files = new SmartList();
        String serviceDirectoryPath = GradleSettings.getInstance(project).getServiceDirectoryPath();
        File gradleUserHomeDir = new BuildLayoutParameters().getGradleUserHomeDir();
        files.add(new File(serviceDirectoryPath != null ? serviceDirectoryPath : gradleUserHomeDir.getPath(), "gradle.properties"));
        files.add(new File(serviceDirectoryPath != null ? serviceDirectoryPath : gradleUserHomeDir.getPath(), "init.gradle"));
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(projectPath);
        files.add(new File(projectSettings == null ? projectPath : projectSettings.getExternalProjectPath(), "gradle.properties"));
        if (projectSettings != null && projectSettings.getDistributionType() == DistributionType.DEFAULT_WRAPPED) {
            files.add(new File(projectSettings.getExternalProjectPath(), "gradle/wrapper/gradle-wrapper.properties"));
        }
        Set subProjectPaths = projectSettings != null && FileUtil.pathsEqual((String)projectSettings.getExternalProjectPath(), (String)projectPath) ? projectSettings.getModules() : ContainerUtil.set((Object[])new String[]{projectPath});
        for (String path : subProjectPaths) {
            Object[] gradleScripts = new File(path).listFiles(file -> !file.isDirectory() && StringUtil.endsWith((CharSequence)file.getName(), (CharSequence)".gradle"));
            if (gradleScripts == null) continue;
            ContainerUtil.addAll((Collection)files, (Object[])gradleScripts);
        }
        return files;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedFileOrDirPath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAffectedExternalProjectPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAffectedExternalProjectFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

