/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.PatternGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class TestClassGradleConfigurationProducer
extends GradleTestRunConfigurationProducer {
    public TestClassGradleConfigurationProducer() {
        super((ConfigurationType)GradleExternalTaskConfigurationType.getInstance());
    }

    @Override
    protected boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        if (((PatternGradleConfigurationProducer)RunConfigurationProducer.getInstance(PatternGradleConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        PsiClass testClass = this.getPsiClassForLocation(contextLocation);
        if (testClass == null) {
            return false;
        }
        sourceElement.set((Object)testClass);
        Module module = context.getModule();
        if (module == null) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return false;
        }
        String projectPath = this.resolveProjectPath(module);
        if (projectPath == null) {
            return false;
        }
        List<String> tasksToRun = TestClassGradleConfigurationProducer.getTasksToRun(module);
        if (tasksToRun.isEmpty()) {
            return false;
        }
        configuration.getSettings().setExternalProjectPath(projectPath);
        configuration.getSettings().setTaskNames(tasksToRun);
        configuration.getSettings().setScriptParameters(String.format("--tests %s", TestClassGradleConfigurationProducer.getRuntimeQualifiedName(testClass)));
        configuration.setName(testClass.getName());
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, contextLocation);
        return true;
    }

    @Nullable
    protected PsiMethod getPsiMethodForLocation(Location contextLocation) {
        Location<PsiMethod> location = GradleRunnerUtil.getMethodLocation(contextLocation);
        return location != null ? (PsiMethod)location.getPsiElement() : null;
    }

    @Nullable
    protected PsiClass getPsiClassForLocation(Location contextLocation) {
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return null;
        }
        return JUnitUtil.getTestClass((Location)location);
    }

    @Override
    protected boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        if (((PatternGradleConfigurationProducer)RunConfigurationProducer.getInstance(PatternGradleConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        if (this.getPsiMethodForLocation(contextLocation) != null) {
            return false;
        }
        PsiClass testClass = this.getPsiClassForLocation(contextLocation);
        if (testClass == null || testClass.getQualifiedName() == null) {
            return false;
        }
        if (context.getModule() == null) {
            return false;
        }
        String projectPath = this.resolveProjectPath(context.getModule());
        if (projectPath == null) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)projectPath, (CharSequence)configuration.getSettings().getExternalProjectPath())) {
            return false;
        }
        if (!configuration.getSettings().getTaskNames().containsAll(TestClassGradleConfigurationProducer.getTasksToRun(context.getModule()))) {
            return false;
        }
        String scriptParameters = configuration.getSettings().getScriptParameters() + ' ';
        int i = scriptParameters.indexOf("--tests ");
        if (i == -1) {
            return false;
        }
        String str = scriptParameters.substring(i + "--tests ".length()).trim() + ' ';
        return str.startsWith(TestClassGradleConfigurationProducer.getRuntimeQualifiedName(testClass) + ' ') && !str.contains("--tests");
    }

    public void onFirstRun(final ConfigurationFromContext fromContext, ConfigurationContext context, @NotNull Runnable performRunnable) {
        InheritorChooser inheritorChooser;
        if (performRunnable == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(0);
        }
        if ((inheritorChooser = new InheritorChooser(){

            protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                if (!StringUtil.equals((CharSequence)ExternalSystemModulePropertyManager.getInstance((Module)context.getModule()).getExternalSystemId(), (CharSequence)GradleConstants.SYSTEM_ID.toString())) {
                    return;
                }
                ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)fromContext.getConfiguration();
                if (!TestClassGradleConfigurationProducer.applyTestConfiguration(configuration, context, (PsiClass[])ArrayUtil.toObjectArray(classes, PsiClass.class))) {
                    return;
                }
                super.runForClasses(classes, method, context, performRunnable);
            }

            protected void runForClass(PsiClass aClass, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable) {
                if (!StringUtil.equals((CharSequence)ExternalSystemModulePropertyManager.getInstance((Module)context.getModule()).getExternalSystemId(), (CharSequence)GradleConstants.SYSTEM_ID.toString())) {
                    return;
                }
                ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)fromContext.getConfiguration();
                if (!TestClassGradleConfigurationProducer.applyTestConfiguration(configuration, context, new PsiClass[]{aClass})) {
                    return;
                }
                super.runForClass(aClass, psiMethod, context, performRunnable);
            }
        }).runMethodInAbstractClass(context, performRunnable, null, (PsiClass)fromContext.getSourceElement())) {
            return;
        }
        super.onFirstRun(fromContext, context, performRunnable);
    }

    private static boolean applyTestConfiguration(@NotNull ExternalSystemRunConfiguration configuration, @NotNull ConfigurationContext context, PsiClass ... containingClasses) {
        Module module;
        if (configuration == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (containingClasses == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)(module = context.getModule()))) {
            return false;
        }
        String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (projectPath == null) {
            return false;
        }
        List<String> tasksToRun = TestClassGradleConfigurationProducer.getTasksToRun(module);
        if (tasksToRun.isEmpty()) {
            return false;
        }
        configuration.getSettings().setExternalProjectPath(projectPath);
        configuration.getSettings().setTaskNames(tasksToRun);
        StringBuilder buf = new StringBuilder();
        for (PsiClass aClass2 : containingClasses) {
            buf.append(String.format("--tests %s ", TestClassGradleConfigurationProducer.getRuntimeQualifiedName(aClass2)));
        }
        configuration.getSettings().setScriptParameters(buf.toString());
        configuration.setName(StringUtil.join((Object[])containingClasses, aClass -> aClass.getName(), (String)"|"));
        return true;
    }

    public static String getRuntimeQualifiedName(PsiClass psiClass) {
        PsiElement parent = psiClass.getParent();
        if (parent instanceof PsiClass) {
            return TestClassGradleConfigurationProducer.getRuntimeQualifiedName((PsiClass)parent) + "$" + psiClass.getName();
        }
        return psiClass.getQualifiedName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "performRunnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClasses";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/TestClassGradleConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onFirstRun";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "applyTestConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

