/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search;

import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search.Search;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.aether.artifact.DefaultArtifact;

public class JcenterSearch
implements Search {
    private static final String URL_PREFIX = "https://api.bintray.com/search/packages/maven?q=*";
    private static final String URL_SUFFIX = "*";
    private final HttpClient client = HttpClients.createDefault();
    private final String username;
    private final String password;

    public JcenterSearch(String username, String password) {
        this.username = username;
        this.password = password;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DefaultArtifact> getCoordinates(String query) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Repository", "Jcenter");
        try {
            HttpGet request = new HttpGet(URL_PREFIX + query + URL_SUFFIX);
            if (!this.username.isEmpty() && !this.password.isEmpty()) {
                String authStringEnc = new String(Base64.encodeBase64((byte[])(this.username + ":" + this.password).getBytes()));
                request.addHeader("Authorization", "Basic " + authStringEnc);
            }
            request.setHeader("Accept", "application/json");
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            try (JsonReader rdr = Json.createReader((InputStream)response.getEntity().getContent());){
                JsonArray obj = rdr.readArray();
                if (obj == null) return null;
                if (obj.isEmpty()) return null;
                List<DefaultArtifact> list = obj.getValuesAs(JsonObject.class).stream().map(o -> {
                    JsonArray ids = o.getJsonArray("system_ids");
                    if (ids != null && !ids.isEmpty()) {
                        return ids.stream().map(j -> j.toString().replaceAll("\"", "") + ":" + "[0,)").collect(Collectors.toList());
                    }
                    return null;
                }).filter(Objects::nonNull).flatMap(l -> l.stream()).distinct().map(gav -> new DefaultArtifact(gav, map)).collect(Collectors.toList());
                return list;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(JcenterSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
}

