/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.remote;

import com.intellij.openapi.util.text.StringUtil;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObject;
import groovy.lang.Script;
import java.net.URL;

public class GroovyHelper {
    private static final GroovyClassLoader ourGroovyLoader = new GroovyClassLoader(GroovyHelper.class.getClassLoader());

    public static Object invokeGroovyMethod(URL resource, String method, Object[] args) throws Exception {
        GroovyCodeSource codeSource = new GroovyCodeSource(resource);
        codeSource.setCachable(true);
        return ((GroovyObject)ourGroovyLoader.parseClass(codeSource).newInstance()).invokeMethod(method, (Object)args);
    }

    public static Object evaluateExpression(String expression) throws Exception {
        Object o = ourGroovyLoader.parseClass(expression).newInstance();
        return o instanceof Script ? ((Script)o).run() : null;
    }

    public static Object makeParameter(Object o) {
        if (!(o instanceof String)) {
            return o;
        }
        String str = (String)o;
        if (StringUtil.isQuotedString((String)str)) {
            return StringUtil.unquoteString((String)str);
        }
        try {
            return GroovyHelper.evaluateExpression(str);
        }
        catch (Exception e) {
            return str;
        }
    }
}

