/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.declarations;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.AbstractDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.PsiBasedClassMemberDeclarationProvider;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

public class FileBasedDeclarationProviderFactory
extends AbstractDeclarationProviderFactory {
    private final StorageManager storageManager;
    private final NotNullLazyValue<Index> index;

    public FileBasedDeclarationProviderFactory(@NotNull StorageManager storageManager, @NotNull Collection<KtFile> files2) {
        super(storageManager);
        this.storageManager = storageManager;
        this.index = storageManager.createLazyValue(() -> FileBasedDeclarationProviderFactory.computeFilesByPackage(files2));
    }

    @NotNull
    private static Index computeFilesByPackage(@NotNull Collection<KtFile> files2) {
        Index index2 = new Index();
        for (KtFile file2 : files2) {
            FqName packageFqName = file2.getPackageFqName();
            FileBasedDeclarationProviderFactory.addMeAndParentPackages(index2, packageFqName);
            index2.filesByPackage.put((Object)packageFqName, (Object)file2);
        }
        return index2;
    }

    private static void addMeAndParentPackages(@NotNull Index index2, @NotNull FqName name2) {
        index2.declaredPackages.add(name2);
        if (!name2.isRoot()) {
            FileBasedDeclarationProviderFactory.addMeAndParentPackages(index2, name2.parent());
        }
    }

    private boolean isPackageDeclaredExplicitly(@NotNull FqName packageFqName) {
        return ((Index)this.index.invoke()).declaredPackages.contains(packageFqName);
    }

    Collection<FqName> getAllDeclaredSubPackagesOf(@NotNull FqName parent2) {
        return CollectionsKt.filter((Iterable)((Index)this.index.invoke()).declaredPackages, fqName2 -> !fqName2.isRoot() && fqName2.parent().equals(parent2));
    }

    @Override
    @Nullable
    protected PackageMemberDeclarationProvider createPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
        if (this.isPackageDeclaredExplicitly(packageFqName)) {
            return new FileBasedPackageMemberDeclarationProvider(this.storageManager, packageFqName, this, ((Index)this.index.invoke()).filesByPackage.get((Object)packageFqName));
        }
        return null;
    }

    @Override
    @NotNull
    public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull KtClassLikeInfo classLikeInfo) {
        if (!((Index)this.index.invoke()).filesByPackage.containsKey((Object)classLikeInfo.getContainingPackageFqName())) {
            throw new IllegalStateException("This factory doesn't know about this class: " + classLikeInfo);
        }
        return new PsiBasedClassMemberDeclarationProvider(this.storageManager, classLikeInfo);
    }

    private static class Index {
        private final Multimap<FqName, KtFile> filesByPackage = LinkedHashMultimap.create();
        private final Set<FqName> declaredPackages = Sets.newHashSet();

        private Index() {
        }
    }
}

