/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclarationUtil;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinStubWithFqName;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

abstract class KtNamedDeclarationStub<T extends KotlinStubWithFqName<?>>
extends KtDeclarationStub<T>
implements KtNamedDeclaration {
    public KtNamedDeclarationStub(@NotNull T stub, @NotNull IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public KtNamedDeclarationStub(@NotNull ASTNode node) {
        super(node);
    }

    public String getName() {
        KotlinStubWithFqName stub = (KotlinStubWithFqName)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        PsiElement identifier2 = this.getNameIdentifier();
        if (identifier2 != null) {
            String text2 = identifier2.getText();
            return text2 != null ? KtPsiUtil.unquoteIdentifier(text2) : null;
        }
        return null;
    }

    @Override
    public Name getNameAsName() {
        String name2 = this.getName();
        return name2 != null ? Name.identifier(name2) : null;
    }

    @Override
    @NotNull
    public Name getNameAsSafeName() {
        return KtPsiUtil.safeName(this.getName());
    }

    public PsiElement getNameIdentifier() {
        return this.findChildByType(KtTokens.IDENTIFIER);
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        PsiElement newIdentifier;
        PsiElement identifier2 = this.getNameIdentifier();
        if (identifier2 == null) {
            return null;
        }
        KtModifierList modifierList = this.getModifierList();
        if (modifierList != null && modifierList.hasModifier(KtTokens.OPERATOR_KEYWORD) && !OperatorConventions.isConventionName(Name.identifier(name2))) {
            this.removeModifier(KtTokens.OPERATOR_KEYWORD);
        }
        if ((newIdentifier = KtPsiFactoryKt.KtPsiFactory(this).createNameIdentifierIfPossible(name2)) != null) {
            identifier2.replace(newIdentifier);
        } else {
            identifier2.delete();
        }
        return this;
    }

    public int getTextOffset() {
        PsiElement identifier2 = this.getNameIdentifier();
        return identifier2 != null ? identifier2.getTextRange().getStartOffset() : this.getTextRange().getStartOffset();
    }

    @NotNull
    public SearchScope getUseScope() {
        KtElement enclosingBlock = KtPsiUtil.getEnclosingElementForLocalDeclaration(this, false);
        if (enclosingBlock != null) {
            KtExpression condition2;
            PsiElement enclosingParent = enclosingBlock.getParent();
            if (enclosingParent instanceof KtContainerNode) {
                enclosingParent = enclosingParent.getParent();
            }
            if (enclosingBlock instanceof KtBlockExpression && enclosingParent instanceof KtDoWhileExpression && (condition2 = ((KtDoWhileExpression)enclosingParent).getCondition()) != null) {
                return new LocalSearchScope(new PsiElement[]{enclosingBlock, condition2});
            }
            return new LocalSearchScope((PsiElement)enclosingBlock);
        }
        if (this.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            KtElement companionObjectClass;
            KtElement containingClass = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)this, KtClassOrObject.class);
            if (containingClass instanceof KtObjectDeclaration && ((KtObjectDeclaration)containingClass).isCompanion() && (companionObjectClass = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)containingClass, KtClassOrObject.class)) != null) {
                containingClass = companionObjectClass;
            }
            if (containingClass != null) {
                return new LocalSearchScope((PsiElement)containingClass);
            }
        }
        SearchScope scope2 = super.getUseScope();
        KtClassOrObject classOrObject = KtPsiUtilKt.getContainingClassOrObject(this);
        if (classOrObject != null) {
            scope2 = scope2.intersectWith(classOrObject.getUseScope());
        }
        return scope2;
    }

    @Override
    @Nullable
    public FqName getFqName() {
        KotlinStubWithFqName stub = (KotlinStubWithFqName)this.getStub();
        if (stub != null) {
            return stub.getFqName();
        }
        return KtNamedDeclarationUtil.getFQName(this);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        KtClassOrObject classOrObject = KtPsiUtilKt.getContainingClassOrObject(this);
        super.delete();
        if (classOrObject instanceof KtObjectDeclaration && ((KtObjectDeclaration)classOrObject).isCompanion() && classOrObject.getDeclarations().isEmpty()) {
            classOrObject.delete();
        }
    }
}

