/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\tH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0004R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/util/DialogWithEditor;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "initialText", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "editor", "Lcom/intellij/openapi/editor/Editor;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getInitialText", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createCenterPanel", "Ljavax/swing/JComponent;", "createEditor", "dispose", "", "getPreferredFocusedComponent", "init", "idea"})
public class DialogWithEditor
extends DialogWrapper {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private final String initialText;

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    protected final void init() {
        super.init();
    }

    private final Editor createEditor() {
        EditorSettings settings2;
        Editor editor;
        EditorFactory editorFactory = EditorFactory.getInstance();
        if (editorFactory == null) {
            Intrinsics.throwNpe();
        }
        EditorFactory editorFactory2 = editorFactory;
        LightVirtualFile virtualFile2 = new LightVirtualFile("dummy.kt", (FileType)KotlinFileType.INSTANCE, (CharSequence)this.initialText);
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile2);
        if (document == null) {
            Intrinsics.throwNpe();
        }
        Document document2 = document;
        Editor editor2 = editor = editorFactory2.createEditor(document2, this.project, (FileType)KotlinFileType.INSTANCE, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
        EditorSettings editorSettings = settings2 = editor2.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorSettings, (String)"settings");
        editorSettings.setVirtualSpace(false);
        settings2.setLineMarkerAreaShown(false);
        settings2.setFoldingOutlineShown(false);
        settings2.setRightMarginShown(false);
        settings2.setAdditionalPageAtBottom(false);
        settings2.setAdditionalLinesCount(2);
        settings2.setAdditionalColumnsCount(12);
        boolean bl = editor instanceof EditorEx;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ((EditorEx)editor).setEmbeddedIntoDialogWrapper(true);
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        EditorColorsScheme editorColorsScheme2 = editor.getColorsScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme2, (String)"editor.getColorsScheme()");
        editorColorsScheme.setColor(EditorColors.CARET_ROW_COLOR, editorColorsScheme2.getDefaultBackground());
        return editor;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.editor.getComponent(), "Center");
        return panel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.editor.getContentComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"editor.contentComponent");
        return jComponent;
    }

    protected void dispose() {
        super.dispose();
        EditorFactory editorFactory = EditorFactory.getInstance();
        if (editorFactory == null) {
            Intrinsics.throwNpe();
        }
        editorFactory.releaseEditor(this.editor);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getInitialText() {
        return this.initialText;
    }

    public DialogWithEditor(@NotNull Project project, @NotNull String title, @NotNull String initialText) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)initialText, (String)"initialText");
        super(project, true);
        this.project = project;
        this.initialText = initialText;
        this.editor = this.createEditor();
        this.init();
        this.setTitle(title);
    }
}

